/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.stats.Stats;
import com.newrelic.agent.stats.StatsEngine;
import java.util.HashMap;
import java.util.Map;

public class MonotonicallyIncreasingStatsEngine {
    private final Map<String, MonotonicallyIncreasingStatsHelper> monoStatsHelpers = new HashMap<String, MonotonicallyIncreasingStatsHelper>();

    public void recordMonoStats(StatsEngine statsEngine, String name, float value) {
        MonotonicallyIncreasingStatsHelper monoStatsHelper = this.getMonotonicallyIncreasingStatsHelper(name);
        Stats stats = statsEngine.getStats(name);
        monoStatsHelper.recordDataPoint(stats, value);
    }

    private MonotonicallyIncreasingStatsHelper getMonotonicallyIncreasingStatsHelper(String name) {
        MonotonicallyIncreasingStatsHelper monoStatsHelper = this.monoStatsHelpers.get(name);
        if (monoStatsHelper == null) {
            monoStatsHelper = new MonotonicallyIncreasingStatsHelper();
            this.monoStatsHelpers.put(name, monoStatsHelper);
        }
        return monoStatsHelper;
    }

    private class MonotonicallyIncreasingStatsHelper {
        private float lastValue = 0.0f;

        public void recordDataPoint(Stats stats, float value) {
            if (this.lastValue > value) {
                this.lastValue = 0.0f;
            }
            stats.recordDataPoint(value - this.lastValue);
            this.lastValue = value;
        }
    }
}

