/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.weavepackage.language.scala;

import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AnnotationNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.api.agent.weaver.MatchType;
import com.newrelic.api.agent.weaver.Weave;
import com.newrelic.api.agent.weaver.scala.ScalaMatchType;
import com.newrelic.api.agent.weaver.scala.ScalaWeave;
import com.newrelic.weave.utils.ClassCache;
import com.newrelic.weave.utils.ClassLoaderFinder;
import com.newrelic.weave.utils.WeaveClassInfo;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.violation.WeaveViolation;
import com.newrelic.weave.weavepackage.language.LanguageAdapter;
import com.newrelic.weave.weavepackage.language.LanguageAdapterResult;
import com.newrelic.weave.weavepackage.language.scala.ScalaWeaveViolation;
import com.newrelic.weave.weavepackage.language.scala.ScalaWeaveViolationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScalaAdapter
implements LanguageAdapter {
    private static final String WEAVE_API_DESC = Type.getType(Weave.class).getDescriptor();
    private static final String SCALA_WEAVE_API_DESC = Type.getType(ScalaWeave.class).getDescriptor();
    private static final String MATCH_TYPE_DESC = Type.getType(MatchType.class).getDescriptor();
    private static final String SCALA_MATCH_TYPE_DESC = Type.getType(ScalaMatchType.class).getDescriptor();

    @Override
    public LanguageAdapterResult adapt(List<byte[]> input) {
        ArrayList<WeaveViolation> violations = new ArrayList<WeaveViolation>();
        HashMap<String, ClassNode> scalaNodes = new HashMap<String, ClassNode>(input.size());
        ArrayList<ClassNode> outputNodes = new ArrayList<ClassNode>(input.size());
        for (byte[] bytes : input) {
            ClassNode node = WeaveUtils.convertToClassNode(bytes);
            if (this.isScalaNode(node)) {
                scalaNodes.put(node.name, node);
                continue;
            }
            outputNodes.add(node);
        }
        if (scalaNodes.size() == 0) {
            return new ScalaAdapterResult(input, violations);
        }
        this.apiConversions(scalaNodes);
        violations.addAll(this.validateScalaNodes(scalaNodes));
        outputNodes.addAll(scalaNodes.values());
        return new ScalaAdapterResult(this.convertToBytes(outputNodes), violations);
    }

    private List<byte[]> convertToBytes(List<ClassNode> nodes) {
        ClassCache packageCache = new ClassCache(new ClassLoaderFinder(Thread.currentThread().getContextClassLoader()));
        ArrayList<byte[]> converted = new ArrayList<byte[]>(nodes.size());
        for (ClassNode node : nodes) {
            converted.add(WeaveUtils.convertToClassBytes(node, packageCache));
        }
        return converted;
    }

    private boolean isScalaNode(ClassNode node) {
        return node.sourceFile != null && node.sourceFile.endsWith(".scala");
    }

    private void apiConversions(Map<String, ClassNode> input) {
        for (ClassNode node : input.values()) {
            if (null == node.visibleAnnotations) continue;
            for (AnnotationNode annotation : node.visibleAnnotations) {
                if (!SCALA_WEAVE_API_DESC.equals(annotation.desc)) continue;
                annotation.desc = WEAVE_API_DESC;
                int originalNameIndex = -1;
                int matchTypeIndex = -1;
                for (int i = 0; i < annotation.values.size(); ++i) {
                    Object key = annotation.values.get(i);
                    if (!(key instanceof String)) continue;
                    if ("type".equals(key)) {
                        matchTypeIndex = i;
                        continue;
                    }
                    if (!"originalName".equals(key)) continue;
                    originalNameIndex = i;
                }
                if (matchTypeIndex == -1) continue;
                String[] matchVal = (String[])annotation.values.get(matchTypeIndex + 1);
                String scalaMatchType = matchVal[1];
                matchVal[0] = MATCH_TYPE_DESC;
                matchVal[1] = this.convertToJavaMatchType(matchVal[1]);
                if (!"Object".equals(scalaMatchType)) continue;
                if (originalNameIndex != -1) {
                    annotation.values.set(originalNameIndex + 1, annotation.values.get(originalNameIndex + 1) + "$");
                    continue;
                }
                annotation.values.add("originalName");
                annotation.values.add(WeaveUtils.getClassBinaryName(node.name) + "$");
            }
        }
    }

    private List<WeaveViolation> validateScalaNodes(Map<String, ClassNode> input) {
        ArrayList<WeaveViolation> violations = new ArrayList<WeaveViolation>();
        for (String name : input.keySet()) {
            String implName;
            ClassNode node = input.get(name);
            boolean isWeaveClass = this.isWeaveClass(node);
            if (isWeaveClass && this.isInterface(node)) {
                violations.add(new ScalaWeaveViolation(name, ScalaWeaveViolationType.CLASS_WEAVE_IS_TRAIT));
            }
            if (!isWeaveClass || !name.endsWith("$") || !input.containsKey(implName = name.substring(0, name.length() - 1))) continue;
            violations.add(new ScalaWeaveViolation(name, ScalaWeaveViolationType.CLASS_WEAVE_IS_OBJECT));
        }
        return violations;
    }

    private boolean isInterface(ClassNode node) {
        return (node.access & 0x200) != 0;
    }

    private boolean isWeaveClass(ClassNode node) {
        if (null != node && null != node.visibleAnnotations) {
            for (AnnotationNode annotation : node.visibleAnnotations) {
                if (!SCALA_WEAVE_API_DESC.equals(annotation.desc) && !WeaveClassInfo.WEAVE_DESC.equals(annotation.desc)) continue;
                return true;
            }
        }
        return false;
    }

    private String convertToJavaMatchType(String scalaMatch) {
        if (ScalaMatchType.Trait.name().equals(scalaMatch)) {
            return MatchType.Interface.name();
        }
        return MatchType.ExactClass.name();
    }

    private static class ScalaAdapterResult
    implements LanguageAdapterResult {
        private final List<byte[]> adaptedBytes;
        private final List<WeaveViolation> violations;

        public ScalaAdapterResult(List<byte[]> adaptedBytes, List<WeaveViolation> violations) {
            this.adaptedBytes = adaptedBytes;
            this.violations = violations;
        }

        @Override
        public List<byte[]> getAdaptedBytes() {
            return this.adaptedBytes;
        }

        @Override
        public List<WeaveViolation> getViolations() {
            return this.violations;
        }
    }
}

