/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.agentcontrol;

public class AgentHealth {
    private final long startTimeNanos;
    private Status status;

    AgentHealth(long startTimeNanos) {
        this.startTimeNanos = startTimeNanos;
        this.status = Status.HEALTHY;
    }

    void setUnhealthyStatus(Status newStatus, String ... additionalInfo) {
        this.status = newStatus;
        this.status.setAdditionalInfo(additionalInfo);
    }

    void setHealthyStatus(Category category) {
        if (category == this.status.category) {
            this.status = Status.HEALTHY;
        }
    }

    public boolean isHealthy() {
        return this.status.isHealthStatus();
    }

    public String getLastError() {
        return this.status.getCode();
    }

    public String getCurrentStatus() {
        return this.status.getDescription();
    }

    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    public static enum Status {
        HEALTHY("NR-APM-000", "Healthy", Category.AGENT),
        INVALID_LICENSE("NR-APM-001", "Invalid license key (HTTP status code 401)", Category.CONFIG),
        MISSING_LICENSE("NR-APM-002", "License key missing in configuration", Category.CONFIG),
        FORCED_DISCONNECT("NR-APM-003", "Forced disconnect received from New Relic (HTTP status code 410)", Category.HARVEST),
        HTTP_ERROR("NR-APM-004", "HTTP error response code [%s] received from New Relic while sending data type [%s]", Category.HARVEST),
        MISSING_APP_NAME("NR-APM-005", "Missing application name in agent configuration", Category.CONFIG),
        MAX_APP_NAMES_EXCEEDED("NR-APM-006", "The maximum number of configured app names (3) exceeded", Category.CONFIG),
        PROXY_ERROR("NR-APM-007", "HTTP Proxy configuration error; response code [%s]", Category.HARVEST),
        AGENT_DISABLED("NR-APM-008", "Agent is disabled via configuration", Category.CONFIG),
        INITIAL_CONNECT_FAILURE("NR-APM-009", "Failed to connect to New Relic data collector", Category.HARVEST),
        CONFIG_FILE_PARSE_ERROR("NR-APM-010", "Agent config file is not able to be parsed", Category.CONFIG),
        SHUTDOWN("NR-APM-099", "Agent has shutdown", Category.AGENT),
        GC_CIRCUIT_BREAKER("NR-APM-100", "Garbage collection circuit breaker triggered: Percent free memory %s; GC CPU time: %s", Category.CIRCUIT_BREAKER);

        private final String code;
        private final String description;
        private String[] additionalInfo;
        private final Category category;

        private Status(String code, String description, Category category) {
            this.code = code;
            this.description = description;
            this.category = category;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            String finalDescription = this.additionalInfo != null && this.additionalInfo.length > 0 ? String.format(this.description, this.additionalInfo) : this.description;
            return finalDescription;
        }

        public boolean isHealthStatus() {
            return this == HEALTHY;
        }

        void setAdditionalInfo(String[] additionalInfo) {
            this.additionalInfo = additionalInfo;
        }
    }

    public static enum Category {
        AGENT,
        CONFIG,
        HARVEST,
        CIRCUIT_BREAKER;

    }
}

