/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.cloud;

import com.newrelic.agent.cloud.CloudAccountInfoValidator;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Caffeine;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.LoadingCache;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.api.agent.CloudAccountInfo;
import com.newrelic.api.agent.NewRelic;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;

public class CloudAccountInfoCache {
    private final LoadingCache<Object, Map<CloudAccountInfo, String>> cache = Caffeine.newBuilder().initialCapacity(4).weakKeys().executor(Runnable::run).build(key -> Collections.synchronizedMap(new EnumMap(CloudAccountInfo.class)));
    private static final Object NULL_CLIENT = new Object();

    CloudAccountInfoCache() {
    }

    public void setAccountInfo(CloudAccountInfo cloudAccountInfo, String value) {
        this.setAccountInfo(NULL_CLIENT, cloudAccountInfo, value);
    }

    public void setAccountInfo(Object sdkClient, CloudAccountInfo cloudAccountInfo, String value) {
        if (sdkClient == null) {
            return;
        }
        if (value == null) {
            Map accountInfo = (Map)this.cache.getIfPresent(sdkClient);
            if (accountInfo != null) {
                accountInfo.remove(cloudAccountInfo);
            }
            return;
        }
        if (CloudAccountInfoValidator.validate(cloudAccountInfo, value)) {
            Map<CloudAccountInfo, String> accountInfo = this.cache.get(sdkClient);
            accountInfo.put(cloudAccountInfo, value);
        }
    }

    public String getAccountInfo(CloudAccountInfo cloudAccountInfo) {
        Map accountInfo = (Map)this.cache.getIfPresent(NULL_CLIENT);
        if (accountInfo == null) {
            return null;
        }
        return (String)accountInfo.get(cloudAccountInfo);
    }

    public String getAccountInfo(Object sdkClient, CloudAccountInfo cloudAccountInfo) {
        if (sdkClient == null) {
            return this.getAccountInfo(cloudAccountInfo);
        }
        Map accountInfo = (Map)this.cache.getIfPresent(sdkClient);
        if (accountInfo == null) {
            return this.getAccountInfo(cloudAccountInfo);
        }
        return (String)accountInfo.get(cloudAccountInfo);
    }

    void retrieveDataFromConfig() {
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.retrieveAwsAccountId(agentConfig);
    }

    private void retrieveAwsAccountId(AgentConfig agentConfig) {
        Object awsAccountId = agentConfig.getValue("cloud.aws.account_id");
        if (awsAccountId == null) {
            return;
        }
        NewRelic.getAgent().getLogger().log(Level.INFO, "Found AWS account ID configuration.");
        NewRelic.incrementCounter((String)"Supportability/Cloud/ConfigAccountInfo/aws_account_id");
        this.setAccountInfo(CloudAccountInfo.AWS_ACCOUNT_ID, awsAccountId.toString());
    }
}

