/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.commons.ClassRemapper;
import com.newrelic.agent.extension.DependencyRemapper;
import com.newrelic.agent.util.asm.PatchedClassWriter;
import com.newrelic.weave.utils.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class ExtensionRewriter {
    static final DependencyRemapper REMAPPER = new DependencyRemapper(ImmutableSet.of("com/newrelic/agent/deps/org/objectweb/asm/", "com/newrelic/agent/deps/com/github/benmanes/caffeine/", "com/newrelic/agent/deps/com/google/", "com/newrelic/agent/deps/org/apache/commons/"));

    private ExtensionRewriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] rewrite(JarFile jar, ClassLoader classLoader) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JarOutputStream jarOut = new JarOutputStream(out);
        boolean modified = false;
        try {
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                JarEntry newEntry = new JarEntry(entry.getName());
                InputStream inputStream = jar.getInputStream(entry);
                try {
                    if (entry.getName().endsWith(".class")) {
                        ClassReader cr = new ClassReader(inputStream);
                        PatchedClassWriter writer = new PatchedClassWriter(2, classLoader);
                        ClassRemapper cv = new ClassRemapper(writer, REMAPPER);
                        cr.accept(cv, 4);
                        if (!REMAPPER.getRemappings().isEmpty()) {
                            modified = true;
                        }
                        inputStream.close();
                        inputStream = new ByteArrayInputStream(writer.toByteArray());
                    }
                    jarOut.putNextEntry(newEntry);
                    Streams.copy(inputStream, (OutputStream)jarOut, inputStream.available());
                }
                finally {
                    jarOut.closeEntry();
                    inputStream.close();
                }
            }
        }
        finally {
            jarOut.close();
            jar.close();
            out.close();
        }
        return modified ? out.toByteArray() : null;
    }
}

