/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx;

import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.jmx.LinkingMetadata;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.api.agent.Logger;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class LinkingMetadataRegistration {
    public static final String MBEAN_NAME = "com.newrelic.jfr:type=LinkingMetadata";
    private final Logger logger;

    public LinkingMetadataRegistration(Logger logger) {
        this.logger = logger;
    }

    public void registerLinkingMetadata() {
        try {
            MBeanServer server = this.getMbeanServer();
            ObjectName name = new ObjectName(MBEAN_NAME);
            this.logger.log(Level.INFO, "JMX LinkingMetadata started, registering MBean: " + name);
            LinkingMetadata bean = new LinkingMetadata();
            server.registerMBean(bean, name);
            this.logger.log(Level.INFO, "JMX LinkingMetadata bean registered");
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork("Supportability/LinkingMetadataMBean/Enabled", 1.0f), "Supportability/LinkingMetadataMBean/Enabled");
        }
        catch (Exception | NoClassDefFoundError e) {
            this.logger.log(Level.INFO, "Error registering JMX LinkingMetadata MBean", (Object)e);
        }
    }

    @VisibleForTesting
    protected MBeanServer getMbeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }
}

