/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.daemon;

import com.newrelic.agent.deps.org.slf4j.Logger;
import com.newrelic.agent.deps.org.slf4j.LoggerFactory;
import com.newrelic.jfr.ProfilerRegistry;
import com.newrelic.jfr.ThreadNameNormalizer;
import com.newrelic.jfr.ToEventRegistry;
import com.newrelic.jfr.ToMetricRegistry;
import com.newrelic.jfr.ToSummaryRegistry;
import com.newrelic.jfr.daemon.BufferedTelemetry;
import com.newrelic.jfr.daemon.RecordedEventBuffer;
import com.newrelic.jfr.profiler.EventToEventSummary;
import com.newrelic.jfr.tosummary.EventToSummary;
import com.newrelic.telemetry.Attributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.jfr.consumer.RecordedEvent;

public class EventConverter {
    private static final Logger logger = LoggerFactory.getLogger(EventConverter.class.getName());
    private final Attributes commonAttributes;
    private final ToMetricRegistry toMetricRegistry;
    private final ToSummaryRegistry toSummaryRegistry;
    private final ToEventRegistry toEventRegistry;
    private final Map<String, AtomicInteger> eventCount = new HashMap<String, AtomicInteger>();
    private final ProfilerRegistry profilerRegistry;

    public EventConverter(Attributes commonAttributes, String pattern) {
        this(commonAttributes, new ThreadNameNormalizer(pattern));
    }

    private EventConverter(Attributes commonAttributes, ThreadNameNormalizer nameNormalizer) {
        this(commonAttributes, ToMetricRegistry.createDefault(), ToSummaryRegistry.create(nameNormalizer), ToEventRegistry.createDefault(), ProfilerRegistry.createDefault(nameNormalizer));
    }

    EventConverter(Attributes commonAttributes, ToMetricRegistry toMetricRegistry, ToSummaryRegistry toSummaryRegistry, ToEventRegistry toEventRegistry, ProfilerRegistry profilerRegistry) {
        this.commonAttributes = commonAttributes;
        this.toMetricRegistry = toMetricRegistry;
        this.toSummaryRegistry = toSummaryRegistry;
        this.toEventRegistry = toEventRegistry;
        this.profilerRegistry = profilerRegistry;
    }

    public BufferedTelemetry convert(RecordedEventBuffer buffer) {
        BufferedTelemetry batches = BufferedTelemetry.create(this.commonAttributes);
        buffer.drainToStream().filter(Objects::nonNull).forEach(recordedEvent -> this.convertAndBuffer(batches, (RecordedEvent)recordedEvent));
        this.profilerRegistry.all().forEach(s2 -> s2.summarize().forEach(batches::addEvent));
        this.profilerRegistry.all().forEach(EventToEventSummary::reset);
        this.toSummaryRegistry.all().forEach(s2 -> s2.summarize().forEach(batches::addMetric));
        this.toSummaryRegistry.all().forEach(EventToSummary::reset);
        logger.debug("This conversion had {} events", (Object)this.eventCount.size());
        logger.debug("Detailed view of event counts: {}", (Object)this.eventCount);
        this.eventCount.clear();
        return batches;
    }

    private void convertAndBuffer(BufferedTelemetry batches, RecordedEvent event) {
        String name = event.getEventType().getName();
        this.eventCount.computeIfAbsent(name, key -> new AtomicInteger()).incrementAndGet();
        try {
            this.toMetricRegistry.all().filter(m4 -> m4.test(event)).flatMap(m4 -> ((List)m4.apply(event)).stream()).forEach(batches::addMetric);
            this.toEventRegistry.all().filter(m4 -> m4.test(event)).flatMap(m4 -> ((List)m4.apply(event)).stream()).forEach(batches::addEvent);
            this.toSummaryRegistry.all().filter(m4 -> m4.test(event)).forEach(m4 -> m4.accept(event));
            this.profilerRegistry.all().filter(m4 -> m4.test(event)).forEach(m4 -> m4.accept(event));
        }
        catch (Throwable e) {
            logger.error("Dropping event " + event.getEventType().getName() + " " + event.getEventType().getDescription() + " due to error", e);
        }
    }
}

