/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave;

import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InsnList;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.LabelNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.TypeInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.VarInsnNode;
import com.newrelic.weave.utils.WeaveUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class CallOriginalReplacement {
    private final String weaveClassName;
    private final MethodNode weaveMethod;
    private MethodNode result;
    private boolean success;
    private LabelNode startOfCallOriginal = null;
    private LabelNode endOfCallOriginal = null;
    private static final Map<Type, Type> PRIMITIVE_TO_OBJECT_TYPE = Collections.unmodifiableMap(new HashMap<Type, Type>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Type.BOOLEAN_TYPE, Type.getType(Boolean.class));
            this.put(Type.BYTE_TYPE, Type.getType(Byte.class));
            this.put(Type.CHAR_TYPE, Type.getType(Character.class));
            this.put(Type.DOUBLE_TYPE, Type.getType(Double.class));
            this.put(Type.FLOAT_TYPE, Type.getType(Float.class));
            this.put(Type.INT_TYPE, Type.getType(Integer.class));
            this.put(Type.LONG_TYPE, Type.getType(Long.class));
            this.put(Type.SHORT_TYPE, Type.getType(Short.class));
        }
    });

    private CallOriginalReplacement(String weaveClassName, MethodNode weaveMethod) {
        this.weaveClassName = "INLINER_" + weaveClassName;
        this.weaveMethod = weaveMethod;
    }

    public static CallOriginalReplacement replace(String weaveClassName, MethodNode weaveMethod) {
        CallOriginalReplacement result = new CallOriginalReplacement(weaveClassName, weaveMethod);
        result.replace();
        return result;
    }

    private void replace() {
        MethodNode result = WeaveUtils.copy(this.weaveMethod);
        MethodInsnNode originalInsn = CallOriginalReplacement.findOriginalIndex(result.instructions);
        if (originalInsn == null) {
            this.success = true;
            this.result = result;
            return;
        }
        this.startOfCallOriginal = WeaveUtils.makeLabelNode();
        this.endOfCallOriginal = WeaveUtils.makeLabelNode();
        result.instructions.insertBefore((AbstractInsnNode)originalInsn, this.startOfCallOriginal);
        boolean isStatic = (this.weaveMethod.access & 8) != 0;
        int index = 0;
        if (!isStatic) {
            result.instructions.insertBefore((AbstractInsnNode)originalInsn, new VarInsnNode(25, index++));
        }
        for (Type argType : Type.getArgumentTypes(result.desc)) {
            result.instructions.insertBefore((AbstractInsnNode)originalInsn, new VarInsnNode(argType.getOpcode(21), index));
            index += argType.getSize();
        }
        int invokeOpcode = isStatic ? 184 : 182;
        result.instructions.insertBefore((AbstractInsnNode)originalInsn, new MethodInsnNode(invokeOpcode, this.weaveClassName, result.name, result.desc, false));
        Type returnType = Type.getReturnType(this.weaveMethod.desc);
        AbstractInsnNode nextInsn = originalInsn.getNext();
        switch (returnType.getSort()) {
            case 0: {
                if (nextInsn.getOpcode() != 87) {
                    return;
                }
                result.instructions.remove(nextInsn);
                result.instructions.insert((AbstractInsnNode)originalInsn, this.endOfCallOriginal);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (nextInsn.getOpcode() == 87) {
                    if (returnType.getSize() == 2) {
                        result.instructions.remove(nextInsn);
                        result.instructions.insert((AbstractInsnNode)originalInsn, new InsnNode(88));
                    }
                    result.instructions.insert((AbstractInsnNode)originalInsn, this.endOfCallOriginal);
                    break;
                }
                boolean unboxesReturnValue = false;
                Type boxedType = PRIMITIVE_TO_OBJECT_TYPE.get(returnType);
                if (nextInsn.getOpcode() == 192) {
                    TypeInsnNode castInsn = (TypeInsnNode)nextInsn;
                    if (!Type.getObjectType(castInsn.desc).equals(boxedType)) {
                        return;
                    }
                    result.instructions.remove(castInsn);
                    AbstractInsnNode thirdInsn = originalInsn.getNext();
                    if (thirdInsn.getOpcode() == 182) {
                        MethodInsnNode invokeInsn = (MethodInsnNode)thirdInsn;
                        boolean bl = unboxesReturnValue = invokeInsn.owner.equals(boxedType.getInternalName()) && Type.getReturnType(invokeInsn.desc).equals(returnType);
                        if (unboxesReturnValue) {
                            result.instructions.remove(invokeInsn);
                        }
                    }
                }
                if (!unboxesReturnValue) {
                    String boxMethodDesc = Type.getMethodDescriptor(boxedType, returnType);
                    MethodInsnNode boxInsn = new MethodInsnNode(184, boxedType.getInternalName(), "valueOf", boxMethodDesc, false);
                    result.instructions.insert((AbstractInsnNode)originalInsn, boxInsn);
                }
                result.instructions.insert((AbstractInsnNode)originalInsn, this.endOfCallOriginal);
                break;
            }
            case 9: 
            case 10: {
                if (nextInsn.getOpcode() == 192) {
                    result.instructions.insert(nextInsn, this.endOfCallOriginal);
                    TypeInsnNode castInsn = (TypeInsnNode)nextInsn;
                    if (!Type.getObjectType(castInsn.desc).equals(returnType)) break;
                    result.instructions.remove(castInsn);
                    break;
                }
                result.instructions.insert((AbstractInsnNode)originalInsn, this.endOfCallOriginal);
                break;
            }
            default: {
                return;
            }
        }
        result.instructions.remove(originalInsn);
        this.success = true;
        this.result = result;
    }

    private static MethodInsnNode findOriginalIndex(InsnList instructions) {
        int size = instructions.size();
        for (int i = 0; i < size; ++i) {
            AbstractInsnNode insn = instructions.get(i);
            if (insn.getType() != 5) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)insn;
            if (!WeaveUtils.isOriginalMethodInvocation(methodInsn.owner, methodInsn.name, methodInsn.desc)) continue;
            return methodInsn;
        }
        return null;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public MethodNode getResult() {
        return this.result;
    }

    public LabelNode getStartOfOriginalMethodLabelNode() {
        return this.startOfCallOriginal;
    }

    public LabelNode getEndOfOriginalMethodLabelNode() {
        return this.endOfCallOriginal;
    }
}

