/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util.asm;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.util.asm.ClassResolver;
import com.newrelic.agent.util.asm.ClassResolvers;
import com.newrelic.agent.util.asm.PatchedClassWriter;
import java.io.IOException;
import java.util.logging.Level;

public class CustomClassLoaderClassWriter
extends PatchedClassWriter {
    private final ClassLoader classLoader;
    private final ClassResolver classResolver;

    public CustomClassLoaderClassWriter(int flags, ClassLoader classLoader) {
        super(flags, classLoader);
        this.classLoader = classLoader;
        this.classResolver = ClassResolvers.getClassLoaderResolver(classLoader == null ? AgentBridge.getAgent().getClass().getClassLoader() : classLoader);
    }

    private Class loadClass(String type) throws ClassNotFoundException {
        Class<?> result = null;
        try {
            result = this.classLoader.loadClass(type);
        }
        catch (ClassNotFoundException e) {
            Agent.LOG.log(Level.FINEST, "class not found in custom classloader: " + type);
            try {
                result = this.getClass().getClassLoader().loadClass(type);
            }
            catch (ClassNotFoundException e2) {
                Agent.LOG.log(Level.FINEST, "class not found in base classloader: " + type);
                try {
                    ClassReader classReader = this.getClassReader(type);
                    if (classReader != null) {
                        result = classReader.getClass();
                    }
                }
                catch (IOException ioe) {
                    Agent.LOG.log(Level.FINEST, ioe.toString(), ioe);
                    throw new ClassNotFoundException("Could not find class via ClassReader: " + type);
                }
            }
        }
        return result;
    }

    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        Class class2;
        Class class1;
        try {
            class1 = this.loadClass(type1);
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(type1, e);
        }
        try {
            class2 = this.loadClass(type2);
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(type2, e);
        }
        if (class1 == null || class2 == null) {
            return "java/lang/Object";
        }
        if (class1.isAssignableFrom(class2)) {
            return type1;
        }
        if (class2.isAssignableFrom(class1)) {
            return type2;
        }
        if (!class1.isInterface() && !class2.isInterface()) {
            while (!(class1 = class1.getSuperclass()).isAssignableFrom(class2)) {
            }
            return class1.getName().replace('.', '/');
        }
        return "java/lang/Object";
    }
}

