/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent;

import com.newrelic.api.agent.DestinationType;
import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.OutboundHeaders;

public class MessageProduceParameters
implements ExternalParameters {
    private final String library;
    private final DestinationType destinationType;
    private final String destinationName;
    private final OutboundHeaders outboundHeaders;

    protected MessageProduceParameters(String library, DestinationType destinationType, String destinationName, OutboundHeaders outboundHeaders) {
        this.library = library;
        this.destinationType = destinationType;
        this.destinationName = destinationName;
        this.outboundHeaders = outboundHeaders;
    }

    protected MessageProduceParameters(MessageProduceParameters messageProduceParameters) {
        this.library = messageProduceParameters.library;
        this.destinationType = messageProduceParameters.destinationType;
        this.destinationName = messageProduceParameters.destinationName;
        this.outboundHeaders = messageProduceParameters.outboundHeaders;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public OutboundHeaders getOutboundHeaders() {
        return this.outboundHeaders;
    }

    public String getLibrary() {
        return this.library;
    }

    public static DestinationTypeParameter library(String library) {
        return new Builder(library);
    }

    public static interface Build {
        public MessageProduceParameters build();
    }

    public static interface OutboundHeadersParameter {
        public Build outboundHeaders(OutboundHeaders var1);
    }

    public static interface DestinationNameParameter {
        public OutboundHeadersParameter destinationName(String var1);
    }

    public static interface DestinationTypeParameter {
        public DestinationNameParameter destinationType(DestinationType var1);
    }

    protected static class Builder
    implements DestinationTypeParameter,
    DestinationNameParameter,
    OutboundHeadersParameter,
    Build {
        private String library;
        private DestinationType destinationType;
        private String destinationName;
        private OutboundHeaders outboundHeaders;

        public Builder(String library) {
            this.library = library;
        }

        @Override
        public DestinationNameParameter destinationType(DestinationType destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public OutboundHeadersParameter destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        @Override
        public Build outboundHeaders(OutboundHeaders outboundHeaders) {
            this.outboundHeaders = outboundHeaders;
            return this;
        }

        @Override
        public MessageProduceParameters build() {
            return new MessageProduceParameters(this.library, this.destinationType, this.destinationName, this.outboundHeaders);
        }
    }
}

