/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent;

import com.newrelic.api.agent.DestinationType;
import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.OutboundHeaders;

public class MessageProduceParameters
implements ExternalParameters {
    private final String library;
    private final String otelLibrary;
    private final DestinationType destinationType;
    private final String destinationName;
    private final OutboundHeaders outboundHeaders;
    private final String cloudAccountId;
    private final String cloudRegion;

    private MessageProduceParameters(Builder builder) {
        this.library = builder.library;
        this.otelLibrary = builder.otelLibrary;
        this.destinationType = builder.destinationType;
        this.destinationName = builder.destinationName;
        this.outboundHeaders = builder.outboundHeaders;
        this.cloudAccountId = builder.cloudAccountId;
        this.cloudRegion = builder.cloudRegion;
    }

    @Deprecated
    protected MessageProduceParameters(String library, DestinationType destinationType, String destinationName, OutboundHeaders outboundHeaders) {
        this.library = library;
        this.otelLibrary = null;
        this.destinationType = destinationType;
        this.destinationName = destinationName;
        this.outboundHeaders = outboundHeaders;
        this.cloudAccountId = null;
        this.cloudRegion = null;
    }

    protected MessageProduceParameters(MessageProduceParameters messageProduceParameters) {
        this.library = messageProduceParameters.library;
        this.otelLibrary = messageProduceParameters.otelLibrary;
        this.destinationType = messageProduceParameters.destinationType;
        this.destinationName = messageProduceParameters.destinationName;
        this.outboundHeaders = messageProduceParameters.outboundHeaders;
        this.cloudAccountId = messageProduceParameters.cloudAccountId;
        this.cloudRegion = messageProduceParameters.cloudRegion;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public OutboundHeaders getOutboundHeaders() {
        return this.outboundHeaders;
    }

    public String getCloudAccountId() {
        return this.cloudAccountId;
    }

    public String getCloudRegion() {
        return this.cloudRegion;
    }

    public String getLibrary() {
        return this.library;
    }

    public String getOtelLibrary() {
        return this.otelLibrary;
    }

    public static DestinationTypeParameter library(String library) {
        return new Builder(library);
    }

    public static DestinationTypeParameter library(String library, String otelLibrary) {
        return new Builder(library).otelLibrary(otelLibrary);
    }

    public static interface Build {
        public Build cloudAccountId(String var1);

        public Build cloudRegion(String var1);

        public MessageProduceParameters build();
    }

    public static interface OutboundHeadersParameter {
        public Build outboundHeaders(OutboundHeaders var1);
    }

    public static interface DestinationNameParameter {
        public OutboundHeadersParameter destinationName(String var1);
    }

    public static interface DestinationTypeParameter {
        public DestinationNameParameter destinationType(DestinationType var1);
    }

    protected static class Builder
    implements DestinationTypeParameter,
    DestinationNameParameter,
    OutboundHeadersParameter,
    Build {
        private String library;
        private String otelLibrary;
        private DestinationType destinationType;
        private String destinationName;
        private OutboundHeaders outboundHeaders;
        private String cloudAccountId;
        private String cloudRegion;

        public Builder(String library) {
            this.library = library;
        }

        public DestinationTypeParameter otelLibrary(String otelLibrary) {
            this.otelLibrary = otelLibrary;
            return this;
        }

        @Override
        public DestinationNameParameter destinationType(DestinationType destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public OutboundHeadersParameter destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        @Override
        public Build outboundHeaders(OutboundHeaders outboundHeaders) {
            this.outboundHeaders = outboundHeaders;
            return this;
        }

        @Override
        public Build cloudAccountId(String cloudAccountId) {
            this.cloudAccountId = cloudAccountId;
            return this;
        }

        @Override
        public Build cloudRegion(String cloudRegion) {
            this.cloudRegion = cloudRegion;
            return this;
        }

        @Override
        public MessageProduceParameters build() {
            return new MessageProduceParameters(this);
        }
    }
}

