/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.api.agent.weaver.internal.WeavePackageType;

public class MetricNames {
    public static final char SEGMENT_DELIMITER = '/';
    public static final String SEGMENT_DELIMITER_STRING = "/";
    public static final String ALL = "all";
    public static final String ALL_WEB = "allWeb";
    public static final String ALL_OTHER = "allOther";
    public static final String CLIENT_APPLICATION_FORMAT = "ClientApplication/{0}/all";
    public static final String BREAKER_TRIPPED = "AgentCheck/CircuitBreaker/tripped/all";
    public static final String BREAKER_TRIPPED_MEMORY = "AgentCheck/CircuitBreaker/tripped/memory";
    public static final String CPU = "CPU/User Time";
    public static final String CPU_UTILIZATION = "CPU/User/Utilization";
    public static final String MEMORY = "Memory/Physical";
    public static final String MEMORY_USED = "Memory/Used";
    public static final String HEAP_USED = "Memory/Heap/Used";
    public static final String HEAP_COMMITTED = "Memory/Heap/Committed";
    public static final String HEAP_MAX = "Memory/Heap/Max";
    public static final String HEAP_UTILIZATION = "Memory/Heap/Utilization";
    public static final String NON_HEAP_USED = "Memory/NonHeap/Used";
    public static final String NON_HEAP_COMMITTED = "Memory/NonHeap/Committed";
    public static final String NON_HEAP_MAX = "Memory/NonHeap/Max";
    public static final String MEMORY_POOL_USED_MASK = "MemoryPool/{0}/{1}/Used";
    public static final String MEMORY_POOL_COMMITTED_MASK = "MemoryPool/{0}/{1}/Committed";
    public static final String MEMORY_POOL_MAX_MASK = "MemoryPool/{0}/{1}/Max";
    public static final String THREAD_COUNT = "Threads/all";
    public static final String THREAD_DEADLOCK_COUNT = "Threads/Deadlocks/all";
    public static final String TOTAL_TIME = "TotalTime";
    public static final String FIRST_BYTE = "TimeToFirstByte";
    public static final String LAST_BYTE = "TimeToLastByte";
    public static final String CPU_PREFIX = "CPU/";
    public static final String CPU_WEB = "CPU/WebTransaction";
    public static final String CPU_OTHER = "CPU/OTherTransaction";
    public static final String WEB_TRANSACTION = "WebTransaction";
    public static final String WEB_TRANSACTION_TOTAL_TIME = "WebTransactionTotalTime";
    public static final String WEB_TRANSACTION_FIRST_BYTE = "WebTransactionTimeToFirstByte";
    public static final String WEB_TRANSACTION_LAST_BYTE = "WebTransactionTimeToLastByte";
    public static final String UNKNOWN = "Unknown";
    public static final String UNKNOWN_HOST = "UnknownHost";
    public static final String URI = "Uri";
    public static final String URI_WEB_TRANSACTION = "WebTransaction/Uri";
    public static final String NORMALIZED_URI = "NormalizedUri";
    public static final String NORMALIZED_URI_WEB_TRANSACTION = "WebTransaction/NormalizedUri";
    public static final String OTHER_TRANSACTION = "OtherTransaction";
    public static final String OTHER_TRANSACTION_INITIALIZER = "OtherTransaction/Initializer";
    public static final String OTHER_TRANSACTION_JOB = "OtherTransaction/Job";
    public static final String OTHER_TRANSACTION_ALL = "OtherTransaction/all";
    public static final String OTHER_TRANSACTION_TOTAL_TIME = "OtherTransactionTotalTime";
    public static final String OTHER_TRANSACTION_TOTAL_TIME_ALL = "OtherTransactionTotalTime/all";
    public static final String OTHER_TRANSACTION_CUSTOM = "OtherTransaction/Custom";
    public static final String CUSTOM = "Custom";
    public static final String JAVA = "Java";
    public static final String DISPATCHER = "HttpDispatcher";
    public static final String REQUEST_DISPATCHER = "RequestDispatcher";
    public static final String APDEX = "Apdex";
    public static final String APDEX_OTHER = "ApdexOther";
    public static final String APDEX_OTHER_TRANSACTION = "ApdexOther/Transaction";
    public static final String ERRORS = "Errors";
    public static final String ERRORS_EXPECTED = "ErrorsExpected";
    public static final String ERRORS_SLASH = "Errors/";
    public static final String ERRORS_ALL = "Errors/all";
    public static final String ERRORS_EXPECTED_ALL = "ErrorsExpected/all";
    public static final String WEB_TRANSACTION_ERRORS_ALL = "Errors/allWeb";
    public static final String OTHER_TRANSACTION_ERRORS_ALL = "Errors/allOther";
    public static final String SESSION_COUNT = "Sessions";
    public static final String EXTERNAL_PATH = "External";
    public static final String EXTERNAL_METRIC_FORMAT = "External/{0}/{1}";
    public static final String EXTERNAL_TRANSACTION_SEGMENT_FORMAT = "External/{0}/{1}/{2}";
    public static final String EXTERNAL_ALL = "External/all";
    public static final String EXTERNAL_ERRORS = "ExternalErrors";
    public static final String EXTERNAL_ERRORS_ALL = "ExternalErrors/all";
    public static final String WEB_TRANSACTION_EXTERNAL_ALL = "External/allWeb";
    public static final String OTHER_TRANSACTION_EXTERNAL_ALL = "External/allOther";
    public static final String JAVA_OTHER = "Java/other";
    public static final String JMX = "JMX";
    public static final String JMX_WITH_SLASH = "JMX/";
    public static final String JMX_CUSTOM = "JmxBuiltIn";
    public static final String JMX_THREAD_POOL = "JmxBuiltIn/ThreadPool/";
    public static final String JMX_THREAD_POOL_MAX = "Max";
    public static final String JMX_THREAD_POOL_ACTIVE = "Active";
    public static final String JMX_THREAD_POOL_IDLE = "Idle";
    public static final String JMX_THREAD_POOL_STANDBY = "Standby";
    public static final String JMX_SESSION = "JmxBuiltIn/Session/";
    public static final String JMX_SESSION_ALIVE_TIME = "AverageAliveTime";
    public static final String JMX_SESSION_ACTIVE = "Active";
    public static final String JMX_SESSION_REJECTED = "Rejected";
    public static final String JMX_SESSION_EXPIRED = "Expired";
    public static final String JMX_TRANSACITON = "JmxBuiltIn/Transactions/";
    public static final String JMX_TRANS_ACTIVE = "Currently/Active";
    public static final String JMX_TRANS_NESTED = "Created/Nested";
    public static final String JMX_TRANS_TOP_LEVEL = "Created/Top Level";
    public static final String JMX_TRANS_COMMITTED = "Outcome/Committed";
    public static final String JMX_TRANS_ROLLED_BACK = "Outcome/Rolled Back";
    public static final String JMX_THREAD = "JmxBuiltIn/Threads/";
    public static final String JMX_THREAD_COUNT = "Thread Count";
    public static final String JMX_THREAD_TOTAL_COUNT = "TotalStartedCount";
    public static final String JMX_CLASSES = "JmxBuiltIn/Classes/";
    public static final String JMX_LOADED_CLASSES = "Loaded";
    public static final String JMX_UNLOADED_CLASSES = "Unloaded";
    public static final String JMX_DATASOURCES = "JmxBuiltIn/DataSources/";
    public static final String JMX_CONNECTIONS_AVAILABLE = "Connections/Available";
    public static final String JMX_CONNECTIONS_POOL_SIZE = "Connections/PoolSize";
    public static final String JMX_CONNECTIONS_CREATED = "Connections/Created";
    public static final String JMX_CONNECTIONS_ACTIVE = "Connections/Active";
    public static final String JMX_CONNECTIONS_LEAKED = "Connections/Leaked";
    public static final String JMX_CONNECTIONS_MAX = "Connections/Max";
    public static final String JMX_CONNECTIONS_IDLE = "Connections/Idle";
    public static final String JMX_CONNECTION_WAITING_REQUEST_COUNT = "Requests/Currently Waiting";
    public static final String JMX_CONNECTION_TOTAL_REQUEST_COUNT = "Requests/Count";
    public static final String JMX_CONNECTION_REQUEST_SUCCESS = "Requests/Successful";
    public static final String JMX_CONNECTION_REQUEST_FAILURE = "Requests/Failed";
    public static final String JMX_CONNECTIONS_CACHE_SIZE = "Statement Cache/Size";
    public static final String JMX_CONNECTIONS_MANAGED_COUNT = "Connections/Managed";
    public static final String JMX_CONNECTIONS_DESTROYED = "Connections/Destroyed";
    public static final String JMX_CONNECTIONS_HANDLE_COUNT = "Connections/Handle";
    public static final String JMX_CONNECTIONS_WAIT_TIME = "Connections/Wait time";
    public static final String JMX_EJB_POOL = "JmxBuiltIn/EJB/Pool/Bean/";
    public static final String JMX_ACTIVE_BEANS = "Beans/Active";
    public static final String JMX_AVAILABLE_BEANS = "Beans/Available";
    public static final String JMX_DESTROY_BEANS = "Beans/Destroyed";
    public static final String JMX_FAILED_ATTEMPTS = "Attempts/Failed";
    public static final String JMX_SUCCESSFUL_ATTEMPTS = "Attempts/Successful";
    public static final String JMX_THREADS_WAITING = "Threads/Waiting";
    public static final String JMX_JTA = "JmxBuiltIn/JTA/";
    public static final String JMX_EJB_TRANSACTION_APPLICATION = "JmxBuiltIn/EJB/Transactions/Application/";
    public static final String JMX_EJB_TRANSACTION_MODULE = "JmxBuiltIn/EJB/Transactions/Module/";
    public static final String JMX_EJB_TRANSACTION_BEAN = "JmxBuiltIn/EJB/Transactions/Bean/";
    public static final String JMX_COUNT = "Count";
    public static final String JMX_COMMIT = "Committed";
    public static final String JMX_ROLLBACK = "Rolled Back";
    public static final String JMX_ABANDONED = "Abandoned";
    public static final String JMX_TIMEOUT = "Timed Out";
    public static final String NETWORK_INBOUND_STATUS_CODE = "Network/Inbound/StatusCode/";
    public static final String SOLR = "Solr";
    public static final String SOLR_CLIENT = "SolrClient";
    public static final String SOLR_ALL = "Solr/all";
    public static final String ORM = "ORM";
    public static final String ORM_ALL = "ORM/all";
    public static final String QUEUE_TIME = "WebFrontend/QueueTime";
    public static final String GC_CUMULATIVE = "GC/cumulative";
    public static final String STUTS_ACTION = "StrutsAction";
    public static final String STUTS_ACTION_PREFIX = "StrutsAction/";
    public static final String TIMEOUT_ASYNC = "Java/Timeout/asyncActivityNotStarted";
    public static final String CLASS_HISTOGRAM_HEAP_TOTAL_SIZE = "ClassHistogram/Heap/TotalSize";
    public static final String CLASS_HISTOGRAM_HEAP_TOTAL_OBJECTS = "ClassHistogram/Heap/TotalObjects";
    public static final String SUPPORTABILITY_HARVEST_SERVICE_RESPONSE_TIME = "Supportability/Harvest";
    public static final String SUPPORTABILITY_ERROR_SERVICE_TRANSACTION_ERROR_SENT = "Supportability/Events/TransactionError/Sent";
    public static final String SUPPORTABILITY_ERROR_SERVICE_TRANSACTION_ERROR_SEEN = "Supportability/Events/TransactionError/Seen";
    public static final String SUPPORTABILITY_TRANSACTION_EVENT_SERVICE_TRANSACTION_EVENT_SENT = "Supportability/Events/TransactionEvent/Sent";
    public static final String SUPPORTABILITY_TRANSACTION_EVENT_SERVICE_TRANSACTION_EVENT_SEEN = "Supportability/Events/TransactionEvent/Seen";
    public static final String SUPPORTABILITY_INSIGHTS_SERVICE_CUSTOMER_SENT = "Supportability/Events/Customer/Sent";
    public static final String SUPPORTABILITY_INSIGHTS_SERVICE_CUSTOMER_SEEN = "Supportability/Events/Customer/Seen";
    public static final String SUPPORTABILITY_ERROR_SERVICE_REPORT_PERIOD_IN_SECONDS = "Supportability/Events/TransactionError/ReportPeriod";
    public static final String SUPPORTABILITY_INSIGHTS_SERVICE_REPORT_PERIOD_IN_SECONDS = "Supportability/Events/Customer/ReportPeriod";
    public static final String SUPPORTABILITY_TRANSACTION_EVENT_SERVICE_REPORT_PERIOD_IN_SECONDS = "Supportability/Events/TransactionEvent/ReportPeriod";
    public static final String SUPPORTABILITY_METRIC_HARVEST_INTERVAL = "Supportability/MetricHarvest/interval";
    public static final String SUPPORTABILITY_METRIC_HARVEST_TRANSMIT = "Supportability/MetricHarvest/transmit";
    public static final String SUPPORTABILITY_METRIC_HARVEST_COUNT = "Supportability/MetricHarvest/count";
    public static final String AGENT_METRICS_COUNT = "Agent/Metrics/Count";
    public static final String SUPPORTABILITY_ERROR_SERVICE_EVENT_HARVEST_INTERVAL = "Supportability/EventHarvest/TransactionError/interval";
    public static final String SUPPORTABILITY_ERROR_SERVICE_EVENT_HARVEST_TRANSMIT = "Supportability/EventHarvest/TransactionError/transmit";
    public static final String SUPPORTABILITY_TRANSACTION_EVENT_SERVICE_EVENT_HARVEST_INTERVAL = "Supportability/EventHarvest/TransactionEvent/interval";
    public static final String SUPPORTABILITY_TRANSACTION_EVENT_SERVICE_EVENT_HARVEST_TRANSMIT = "Supportability/EventHarvest/TransactionEvent/transmit";
    public static final String SUPPORTABILITY_INSIGHTS_SERVICE_EVENT_HARVEST_INTERVAL = "Supportability/EventHarvest/Customer/interval";
    public static final String SUPPORTABILITY_INSIGHTS_SERVICE_EVENT_HARVEST_TRANSMIT = "Supportability/EventHarvest/Customer/transmit";
    public static final String SUPPORTABILITY_SPAN_SERVICE_EVENT_HARVEST_INTERVAL = "Supportability/EventHarvest/SpanEvent/interval";
    public static final String SUPPORTABILITY_SPAN_SERVICE_EVENT_HARVEST_TRANSMIT = "Supportability/EventHarvest/SpanEvent/transmit";
    public static final String SUPPORTABILITY_ASYNC_FINISH_SEGMENT_NOT_CALLED = "Supportability/Timeout/finishSegmentNotCalled";
    public static final String SUPPORTABILITY_TRANSACTION_SIZE = "Supportability/TransactionSize";
    public static final String SUPPORTABILITY_TRANSACTION_SIZE_CLAMP = "Supportability/TransactionSizeClamp";
    public static final String SUPPORTABILITY_ASYNC_TOKEN_CREATE = "Supportability/Async/Token/Create";
    public static final String SUPPORTABILITY_ASYNC_TOKEN_EXPIRE = "Supportability/Async/Token/Expire";
    public static final String SUPPORTABILITY_ASYNC_TOKEN_TIMEOUT = "Supportability/Async/Token/Timeout";
    public static final String SUPPORTABILITY_ASYNC_TOKEN_TIMEOUT_CAUSE = "Supportability/Async/Token/Timeout/Cause/{0}";
    public static final String SUPPORTABILITY_ASYNC_TOKEN_LINK_SUCCESS = "Supportability/Async/Token/Link/Success";
    public static final String SUPPORTABILITY_ASYNC_TOKEN_LINK_IGNORE = "Supportability/Async/Token/Link/Ignore";
    public static final String SUPPORTABILITY_AWS_ERROR = "Supportability/utilization/aws/error";
    public static final String SUPPORTABILITY_PCF_ERROR = "Supportability/utilization/pcf/error";
    public static final String SUPPORTABILITY_AZURE_ERROR = "Supportability/utilization/azure/error";
    public static final String SUPPORTABILITY_GCP_ERROR = "Supportability/utilization/gcp/error";
    public static final String SUPPORTABILITY_BOOT_ID_ERROR = "Supportability/utilization/boot_id/error";
    public static final String SUPPORTABILITY_DATASTORE_PREFIX = "Supportability/Datastore/";
    public static final String SUPPORTABILITY_DATASTORE_UNPARSED_QUERY = "/unparsedQuery";
    public static final String SUPPORTABILITY_DATASTORE_UNKNOWN_HOST = "/unknownHost";
    public static final String SUPPORTABILITY_DATASTORE_UNKNOWN_PORT = "/unknownPort";
    public static final String SUPPORTABILITY_DATASTORE_UNKNOWN_DATABASE_NAME = "/unknownDatabaseName";
    public static final String SUPPORTABILITY_INIT = "Supportability/Instrumented/";
    public static final String SUPPORTABILITY_INSTRUMENT = "Supportability/Instrumented/{0}/{1}{2}";
    public static final String SUPPORTABILITY_PROXY = "Supportability/Instrumented/Proxy";
    public static final String SUPPORTABILITY_WEAVE_LOADED = "Supportability/WeaveInstrumentation/Loaded/{0}/{1}";
    public static final String SUPPORTABILITY_WEAVE_CUSTOM_LOADED = "Supportability/WeaveInstrumentation/Loaded/Custom/{0}/{1}";
    public static final String SUPPORTABILITY_WEAVE_SKIPPED = "Supportability/WeaveInstrumentation/Skipped/{0}/{1}";
    public static final String SUPPORTABILITY_WEAVE_CUSTOM_SKIPPED = "Supportability/WeaveInstrumentation/Skipped/Custom/{0}/{1}";
    public static final String SUPPORTABILITY_WEAVE_CLASS = "Supportability/WeaveInstrumentation/WeaveClass/{0}/{1}";
    public static final String SUPPORTABILITY_LOADED_CLASSES_SOURCE_VERSION = "Supportability/LoadedClasses/{0}/{1}/count";
    public static final String SUPPORTABILITY_SOURCE_LANGUAGE_VERSION = "Supportability/SourceLanguage/{0}/{1}";
    public static final String SUPPORTABILITY_POINTCUT_LOADED = "Supportability/PointCutInstrumentation/Loaded/{0}";
    public static final String SUPPORTABILITY_TIMING = "Supportability/Timing/";
    public static final String SUPPORTABILITY_TIMING_PREMAIN = "Supportability/Timing/Premain";
    public static final String SUPPORTABILITY_LITE_MODE = "Supportability/litemode";
    public static final String MESSAGE_BROKER_PRODUCE_NAMED = "MessageBroker/{0}/{1}/Produce/Named/{2}";
    public static final String MESSAGE_BROKER_PRODUCE_TEMP = "MessageBroker/{0}/{1}/Produce/Temp";
    public static final String MESSAGE_BROKER_CONSUME_NAMED = "MessageBroker/{0}/{1}/Consume/Named/{2}";
    public static final String MESSAGE_BROKER_CONSUME_TEMP = "MessageBroker/{0}/{1}/Consume/Temp";
    public static final String SUPPORTABILITY_API_TOKEN = "Token";
    public static final String SUPPORTABILITY_API_TOKEN_LINK = "Token/Link";
    public static final String SUPPORTABILITY_API_TOKEN_EXPIRE = "Token/Expire";
    public static final String SUPPORTABILITY_API_SEGMENT = "Segment";
    public static final String SUPPORTABILITY_API_SEGMENT_END = "Segment/End";
    public static final String SUPPORTABILITY_API_SEGMENT_IGNORE = "Segment/Ignore";
    public static final String SUPPORTABILITY_API_SEGMENT_SET_METRIC_NAME = "Segment/SetMetricName";
    public static final String SUPPORTABILITY_API_IGNORE = "Ignore";
    public static final String SUPPORTABILITY_API_IGNORE_APDEX = "IgnoreApdex";
    public static final String SUPPORTABILITY_API_SET_TRANSACTION_NAME = "SetTransactionName";
    public static final String SUPPORTABILITY_API_PROCESS_REQUEST_METADATA = "ProcessRequestMetadata";
    public static final String SUPPORTABILITY_API_PROCESS_RESPONSE_METADATA = "ProcessResponseMetadata";
    public static final String SUPPORTABILITY_API_REPORT_AS_EXTERNAL = "ReportAsExternal";
    public static final String SUPPORTABILITY_API_RECORD_CUSTOM_EVENT = "RecordCustomEvent";
    public static final String SUPPORTABILITY_API_ADD_CUSTOM_PARAMETER = "AddCustomParameter";
    public static final String SUPPORTABILITY_API_NOTICE_ERROR = "NoticeError";
    public static final String SUPPORTABILITY_API_SET_APP_SERVER_PORT = "SetAppServerPort";
    public static final String SUPPORTABILITY_API_SET_INSTANCE_NAME = "SetInstanceName";
    public static final String SUPPORTABILITY_API_SET_PRODUCT_NAME = "SetProductName";
    public static final String SUPPORTABILITY_API_SET_SERVER_INFO = "SetServerInfo";
    public static final String SUPPORTABILITY_API_SET_USER_NAME = "SetUserName";
    public static final String SUPPORTABILITY_API_SET_ACCOUNT_NAME = "SetAccountName";
    public static final String SUPPORTABILITY_TRANSACTION_STARTED = "Supportability/Transaction/StartedCount";
    public static final String SUPPORTABILITY_TRANSACTION_FINISHED = "Supportability/Transaction/FinishedCount";
    public static final String SUPPORTABILITY_TRANSACTION_CANCELLED = "Supportability/Transaction/CancelledCount";
    public static final String SUPPORTABILITY_HARVEST_TRANSACTION_STARTED = "Supportability/Transaction/Harvest/StartedCount";
    public static final String SUPPORTABILITY_HARVEST_TRANSACTION_FINISHED = "Supportability/Transaction/Harvest/FinishedCount";
    public static final String SUPPORTABILITY_HARVEST_TRANSACTION_CANCELLED = "Supportability/Transaction/Harvest/CancelledCount";
    public static final String SUPPORTABILITY_TRANSACTION_REQUEST_INITIALIZED = "Supportability/Transaction/RequestInitialized";
    public static final String SUPPORTABILITY_TRANSACTION_REQUEST_DESTROYED = "Supportability/Transaction/RequestDestroyed";
    public static final String SUPPORTABILITY_TRANSACTION_REQUEST_INITIALIZED_STARTED = "Supportability/Transaction/RequestInitialized/TransactionStarted";
    public static final String SUPPORTABILITY_ASYNC_API_LEGACY_SUSPEND = "Supportability/API/LegacyAsync/Suspend";
    public static final String SUPPORTABILITY_ASYNC_API_LEGACY_RESUME = "Supportability/API/LegacyAsync/Resume";
    public static final String SUPPORTABILITY_ASYNC_API_LEGACY_COMPLETE = "Supportability/API/LegacyAsync/Complete";
    public static final String SUPPORTABILITY_ASYNC_API_LEGACY_ERROR = "Supportability/API/LegacyAsync/Error";
    public static final String SUPPORTABILITY_CLASSLOADER_TRANSFORM_TIME = "Supportability/Classloader/TransformTime";
    public static final String SUPPORTABILITY_HTTP_CODE = "Supportability/Collector/HttpCode/{0}";
    public static final String SUPPORTABILITY_PAYLOAD_SIZE_EXCEEDS_MAX = "Supportability/Agent/Collector/MaxPayloadSizeLimit/{0}";
    public static final String SUPPORTABILITY_EVENT_HARVEST_REPORT_PERIOD_INVALID = "Supportability/EventHarvest/ReportPeriod/Invalid";
    public static final String SUPPORTABILITY_API_EXPECTED_ERROR_API_MESSAGE = "ExpectedError/Api/Message";
    public static final String SUPPORTABILITY_API_EXPECTED_ERROR_API_THROWABLE = "ExpectedError/Api/Throwable";
    public static final String SUPPORTABILITY_API_EXPECTED_ERROR_CONFIG_CLASS = "ExpectedError/Config/Class";
    public static final String SUPPORTABILITY_API_EXPECTED_ERROR_CONFIG_CLASS_MESSAGE = "ExpectedError/Config/ClassMessage";
    public static final String SUPPORTABILITY_API_IGNORE_ERROR_CONFIG_LEGACY = "IgnoreError/Config/Legacy";
    public static final String SUPPORTABILITY_API_IGNORE_ERROR_CONFIG_CLASS = "IgnoreError/Config/Class";
    public static final String SUPPORTABILITY_API_IGNORE_ERROR_CONFIG_CLASS_MESSAGE = "IgnoreError/Config/ClassMessage";
    public static final String SUPPORTABILITY_DISTRIBUTED_TRACING = "Supportability/DistributedTracing";
    public static final String SUPPORTABILITY_ACCEPT_PAYLOAD_SUCCESS = "Supportability/DistributedTrace/AcceptPayload/Success";
    public static final String SUPPORTABILITY_ACCEPT_PAYLOAD_EXCEPTION = "Supportability/DistributedTrace/AcceptPayload/Exception";
    public static final String SUPPORTABILITY_ACCEPT_PAYLOAD_IGNORED_MULTIPLE_ACCEPT = "Supportability/DistributedTrace/AcceptPayload/Ignored/Multiple";
    public static final String SUPPORTABILITY_ACCEPT_PAYLOAD_IGNORED_MAJOR_VERSION = "Supportability/DistributedTrace/AcceptPayload/Ignored/MajorVersion";
    public static final String SUPPORTABILITY_ACCEPT_PAYLOAD_CREATE_BEFORE_ACCEPT = "Supportability/DistributedTrace/AcceptPayload/Ignored/CreateBeforeAccept";
    public static final String SUPPORTABILITY_ACCEPT_PAYLOAD_IGNORED_UNTRUSTED_ACCOUNT = "Supportability/DistributedTrace/AcceptPayload/Ignored/UntrustedAccount";
    public static final String SUPPORTABILITY_ACCEPT_PAYLOAD_IGNORED_NULL = "Supportability/DistributedTrace/AcceptPayload/Ignored/Null";
    public static final String SUPPORTABILITY_ACCEPT_PAYLOAD_IGNORED_PARSE_EXCEPTION = "Supportability/DistributedTrace/AcceptPayload/ParseException";
    public static final String SUPPORTABILITY_CREATE_PAYLOAD_SUCCESS = "Supportability/DistributedTrace/CreatePayload/Success";
    public static final String SUPPORTABILITY_CREATE_PAYLOAD_EXCEPTION = "Supportability/DistributedTrace/CreatePayload/Exception";
    public static final String SUPPORTABILITY_SPAN_EVENTS = "Supportability/SpanEvents";
    public static final String SUPPORTABILITY_SPAN_EVENT_TOTAL_EVENTS_SENT = "Supportability/SpanEvent/TotalEventsSent";
    public static final String SUPPORTABILITY_SPAN_EVENT_TOTAL_EVENTS_SEEN = "Supportability/SpanEvent/TotalEventsSeen";
    public static final String SUPPORTABILITY_SPAN_EVENT_TOTAL_EVENTS_DISCARDED = "Supportability/SpanEvent/Discarded";
    public static final String SUPPORTABILITY_INTERNAL_CUSTOM_EVENTS_TOTAL_EVENTS_SENT = "Supportability/InternalCustomEvents/TotalEventsSent";
    public static final String SUPPORTABILITY_INTERNAL_CUSTOM_EVENTS_TOTAL_EVENTS_SEEN = "Supportability/InternalCustomEvents/TotalEventsSeen";
    public static final String SUPPORTABILITY_INTERNAL_CUSTOM_EVENTS_TOTAL_EVENTS_DISCARDED = "Supportability/InternalCustomEvents/Discarded";
    public static final String PARENT_DATA = "{0}/{1}/{2}/{3}/{4}";
    public static final String PARENT_DATA_ALL = "all";
    public static final String PARENT_DATA_ALL_WEB = "allWeb";
    public static final String PARENT_DATA_ALL_OTHER = "allOther";
    public static final String DURATION_BY_PARENT = "DurationByCaller/{0}/{1}/{2}/{3}/{4}";
    public static final String DURATION_BY_PARENT_UNKNOWN = "DurationByCaller/Unknown/Unknown/Unknown/Unknown/all";
    public static final String ERRORS_BY_PARENT = "ErrorsByCaller/{0}/{1}/{2}/{3}/{4}";
    public static final String ERRORS_BY_PARENT_UNKNOWN = "ErrorsByCaller/Unknown/Unknown/Unknown/Unknown/all";
    public static final String TRANSPORT_DURATION_BY_PARENT = "TransportDuration/{0}/{1}/{2}/{3}/{4}";

    public static void recordApiSupportabilityMetric(String metricName) {
        WeavePackageType weavePackageType = (WeavePackageType)AgentBridge.currentApiSource.get();
        if (!weavePackageType.isInternal()) {
            NewRelic.incrementCounter((String)weavePackageType.getSupportabilityMetric(metricName));
        }
    }
}

