/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.attributes;

import com.newrelic.agent.attributes.DestinationFilter;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AttributesConfigImpl;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.logging.Level;

public class AttributesFilter {
    private final boolean captureRequestParameters;
    private final boolean captureMessageParameters;
    private final DestinationFilter rootFilter;
    private final DestinationFilter errorFilter;
    private final DestinationFilter eventsFilter;
    private final DestinationFilter traceFilter;
    private final DestinationFilter browserFilter;
    private final Map<String, DestinationFilter> destinationFilterMap;

    public AttributesFilter(AgentConfig config) {
        this(config, AttributesConfigImpl.DEFAULT_BROWSER_EXCLUDES, AttributesConfigImpl.DEFAULT_ERRORS_EXCLUDES, AttributesConfigImpl.DEFAULT_EVENTS_EXCLUDES, AttributesConfigImpl.DEFAULT_TRACES_EXCLUDES);
    }

    public AttributesFilter(AgentConfig config, String[] defaultExcludeBrowser, String[] defaultExcludeErrors, String[] defaultExcludeEvents, String[] defaultExcludeTraces) {
        this.rootFilter = new DestinationFilter("attributes", true, config, defaultExcludeErrors, "attributes");
        this.errorFilter = new DestinationFilter("error_collector", true, config, defaultExcludeErrors, "error_collector");
        this.eventsFilter = new DestinationFilter("transaction_events", true, config, defaultExcludeEvents, "transaction_events");
        this.traceFilter = new DestinationFilter("transaction_tracer", true, config, defaultExcludeTraces, "transaction_tracer");
        this.browserFilter = new DestinationFilter("browser_monitoring", false, config, defaultExcludeBrowser, "browser_monitoring");
        this.destinationFilterMap = ImmutableMap.builder().put("attributes", this.rootFilter).put("error_collector", this.errorFilter).put("transaction_events", this.eventsFilter).put("transaction_tracer", this.traceFilter).put("browser_monitoring", this.browserFilter).build();
        boolean enabled = this.errorFilter.isEnabled() || this.eventsFilter.isEnabled() || this.traceFilter.isEnabled();
        this.captureRequestParameters = this.captureAllParams(enabled, config.isHighSecurity(), "request.parameters.");
        this.captureMessageParameters = this.captureAllParams(enabled, config.isHighSecurity(), "message.parameters.");
    }

    private boolean captureAllParams(boolean enabled, boolean highSecurity, String paramStart) {
        if (!enabled || highSecurity) {
            return false;
        }
        return this.errorFilter.isPotentialConfigMatch(paramStart) || this.eventsFilter.isPotentialConfigMatch(paramStart) || this.traceFilter.isPotentialConfigMatch(paramStart) || this.browserFilter.isPotentialConfigMatch(paramStart);
    }

    public boolean captureRequestParams() {
        return this.captureRequestParameters;
    }

    public boolean captureMessageParams() {
        return this.captureMessageParameters;
    }

    public boolean isAttributesEnabledForErrors() {
        return this.errorFilter.isEnabled();
    }

    public boolean isAttributesEnabledForEvents() {
        return this.eventsFilter.isEnabled();
    }

    public boolean isAttributesEnabledForTraces() {
        return this.traceFilter.isEnabled();
    }

    public boolean isAttributesEnabledForBrowser() {
        return this.browserFilter.isEnabled();
    }

    public Map<String, ? extends Object> filterErrorAttributes(Map<String, ? extends Object> values) {
        return this.errorFilter.filterAttributes(values);
    }

    public Map<String, ? extends Object> filterEventAttributes(Map<String, ? extends Object> values) {
        return this.eventsFilter.filterAttributes(values);
    }

    public Map<String, ? extends Object> filterTraceAttributes(Map<String, ? extends Object> values) {
        return this.traceFilter.filterAttributes(values);
    }

    public Map<String, ? extends Object> filterBrowserAttributes(Map<String, ? extends Object> values) {
        return this.browserFilter.filterAttributes(values);
    }

    public Map<String, ? extends Object> filterAttributes(Map<String, ? extends Object> values) {
        return this.rootFilter.filterAttributes(values);
    }

    public Map<String, ? extends Object> filterAttributesForDestination(Map<String, ? extends Object> values, String destination) {
        DestinationFilter destinationFilter = this.destinationFilterMap.get(destination);
        if (destinationFilter == null) {
            AgentBridge.getAgent().getLogger().log(Level.SEVERE, "Invalid destination for attribute filter {0}. Attributes are not filtered.", (Object)destination);
            return values;
        }
        return destinationFilter.filterAttributes(values);
    }
}

