/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import java.util.regex.Pattern;

public class JavaVersionUtils {
    private static final Pattern SUPPORTED_JAVA_VERSION_PATTERN = Pattern.compile("(^1\\.[78]$)|(^9$)|(^10$)");
    private static final Pattern EXCLUSIVE_MIN_JAVA_VERSION_PATTERN = Pattern.compile("^1\\.6$");
    private static final Pattern EXCLUSIVE_MAX_JAVA_VERSION_PATTERN = Pattern.compile("^11$");
    public static final String JAVA_6 = "1.6";
    public static final String JAVA_7 = "1.7";
    public static final String JAVA_8 = "1.8";
    public static final String JAVA_9 = "9";
    public static final String JAVA_10 = "10";
    public static final String JAVA_11 = "11";

    public static final String getJavaSpecificationVersion() {
        return System.getProperty("java.specification.version", "");
    }

    public static boolean isAgentSupportedJavaSpecVersion(String javaSpecificationVersion) {
        return javaSpecificationVersion != null && SUPPORTED_JAVA_VERSION_PATTERN.matcher(javaSpecificationVersion).matches();
    }

    public static boolean isAgentSupportedJavaSpecVersion() {
        return JavaVersionUtils.isAgentSupportedJavaSpecVersion(JavaVersionUtils.getJavaSpecificationVersion());
    }

    public static boolean isJavaSpecVersionGreaterThanOrEqualTo(String version) {
        return JavaVersionUtils.getJavaSpecificationVersion().compareTo(version) >= 0;
    }

    public static String getUnsupportedAgentJavaSpecVersionMessage(String javaSpecificationVersion) {
        if (javaSpecificationVersion == null) {
            return "";
        }
        StringBuilder message = new StringBuilder();
        if (EXCLUSIVE_MIN_JAVA_VERSION_PATTERN.matcher(javaSpecificationVersion).matches()) {
            message.append("Java version is: ").append(javaSpecificationVersion).append(". ");
            message.append("This version of the New Relic Agent does not support Java 1.6 or below. ").append("Please use a 4.3.x New Relic agent or a later version of Java.");
        } else if (EXCLUSIVE_MAX_JAVA_VERSION_PATTERN.matcher(javaSpecificationVersion).matches()) {
            message.append("Java version is: ").append(javaSpecificationVersion).append(". ");
            message.append("This version of the New Relic Agent does not support versions of Java greater than 10.");
        }
        return message.toString();
    }

    public static String getUnsupportedAgentJavaSpecVersionMessage() {
        String javaSpecificationVersion = JavaVersionUtils.getJavaSpecificationVersion();
        if (JavaVersionUtils.isAgentSupportedJavaSpecVersion(javaSpecificationVersion)) {
            return "";
        }
        return JavaVersionUtils.getUnsupportedAgentJavaSpecVersionMessage(javaSpecificationVersion);
    }
}

