/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ForceDisconnectException;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public final class LaspPolicies {
    public static final String LASP_RECORD_SQL = "record_sql";
    public static final String LASP_ATTRIBUTES_INCLUDE = "attributes_include";
    public static final String LASP_ALLOW_RAW_EXCEPTION_MESSAGES = "allow_raw_exception_messages";
    public static final String LASP_CUSTOM_EVENTS = "custom_events";
    public static final String LASP_CUSTOM_PARAMETERS = "custom_parameters";
    public static final String LASP_CUSTOM_INSTRUMENTATION_EDITOR = "custom_instrumentation_editor";
    public static final String LASP_MESSAGE_PARAMETERS = "message_parameters";
    public static final String ENABLED = "enabled";
    public static final String REQUIRED = "required";
    private static final Set<String> KNOWN_LASP_POLICIES = new HashSet<String>(Arrays.asList("record_sql", "attributes_include", "allow_raw_exception_messages", "custom_events", "custom_parameters", "custom_instrumentation_editor", "message_parameters"));

    private LaspPolicies() {
    }

    public static Map<String, Boolean> validatePolicies(JSONObject policies) throws ForceDisconnectException {
        HashMap<String, Boolean> validatedPolicies = new HashMap<String, Boolean>();
        Agent.LOG.log(Level.INFO, "LASP Policies received from server side: {0}", policies);
        if (policies == null) {
            return Collections.emptyMap();
        }
        Set policyEntries = policies.entrySet();
        for (Map.Entry entry : policyEntries) {
            String key = (String)entry.getKey();
            JSONObject value = (JSONObject)entry.getValue();
            if (((Boolean)value.get(REQUIRED)).booleanValue() && !KNOWN_LASP_POLICIES.contains(key)) {
                throw new ForceDisconnectException("Found unknown policy that is required: " + key);
            }
            if (!KNOWN_LASP_POLICIES.contains(key)) continue;
            validatedPolicies.put(key, (Boolean)value.get(ENABLED));
        }
        for (String knownPolicy : KNOWN_LASP_POLICIES) {
            if (validatedPolicies.containsKey(knownPolicy)) continue;
            throw new ForceDisconnectException("Did not receive all policies on preconnect");
        }
        return validatedPolicies;
    }

    public static Map<String, Object> convertToConnectPayload(Map<String, Boolean> policiesJson) {
        HashMap<String, Object> connectPayload = new HashMap<String, Object>();
        for (Map.Entry<String, Boolean> entry : policiesJson.entrySet()) {
            JSONObject value = new JSONObject();
            value.put(ENABLED, entry.getValue());
            connectPayload.put(entry.getKey(), value);
        }
        return connectPayload;
    }
}

