/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.jregex;

import com.newrelic.agent.deps.jregex.Find;
import com.newrelic.agent.deps.jregex.FindBack;
import com.newrelic.agent.deps.jregex.Term;

public class Optimizer {
    public static final int THRESHOLD = 20;
    private Term atom;
    private int distance;

    static Optimizer find(Term entry) {
        return Optimizer.find(entry, 0);
    }

    private static Optimizer find(Term term, int dist) {
        if (term == null) {
            return null;
        }
        Term next = term.next;
        int type = term.type;
        switch (type) {
            case 0: 
            case 6: 
            case 7: {
                return new Optimizer(term, dist);
            }
            case 1: 
            case 2: {
                if (term.weight <= 20) {
                    return new Optimizer(term, dist);
                }
                return Optimizer.find(term.next, dist + 1);
            }
            case 4: 
            case 5: {
                return Optimizer.find(next, dist + 1);
            }
            case 46: 
            case 47: {
                if (term.minCount > 0) {
                    return Optimizer.find(term.target, dist);
                }
                return null;
            }
        }
        if (type >= 11 && type <= 31) {
            return Optimizer.find(next, dist);
        }
        return null;
    }

    private Optimizer(Term atom, int distance) {
        this.atom = atom;
        this.distance = distance;
    }

    Term makeFirst(Term theFirst) {
        return new Find(this.atom, this.distance, theFirst);
    }

    Term makeBacktrack(Term back) {
        int min = back.minCount;
        switch (back.type) {
            case 50: {
                min = 0;
            }
            case 51: {
                return new FindBack(this.atom, this.distance, min, back);
            }
            case 54: {
                return back;
            }
        }
        throw new Error("unexpected iterator's backtracker:" + back);
    }
}

