/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.classmatchers;

import com.newrelic.agent.deps.com.google.common.base.Supplier;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMultimap;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Multimap;
import com.newrelic.agent.deps.com.google.common.collect.Multimaps;
import com.newrelic.agent.deps.com.google.common.collect.SetMultimap;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.classmatchers.ClassAndMethodMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public final class OptimizedClassMatcher
implements ClassMatchVisitorFactory {
    public static final Set<Method> METHODS_WE_NEVER_INSTRUMENT = ImmutableSet.of(new Method("equals", "(Ljava/lang/Object;)Z"), new Method("toString", "()Ljava/lang/String;"), new Method("finalize", "()V"), new Method("hashCode", "()I"));
    static final OptimizedClassMatcher EMPTY_MATCHER = new OptimizedClassMatcher();
    final Map.Entry<MethodMatcher, ClassAndMethodMatcher>[] methodMatchers;
    final Map<Method, Collection<ClassAndMethodMatcher>> methods;
    final Set<String> methodAnnotationsToMatch;
    Set<String> exactClassNames;
    public static final Method DEFAULT_CONSTRUCTOR = new Method("<init>", "()V");
    static final Supplier<Set<String>> STRING_COLLECTION_SUPPLIER = new Supplier<Set<String>>(){

        @Override
        public Set<String> get() {
            return Sets.newHashSet();
        }
    };

    private OptimizedClassMatcher() {
        this.methodAnnotationsToMatch = ImmutableSet.of();
        this.methodMatchers = new Map.Entry[0];
        this.methods = ImmutableMap.of();
    }

    protected OptimizedClassMatcher(Set<String> annotationMatchers, SetMultimap<Method, ClassAndMethodMatcher> methods, SetMultimap<MethodMatcher, ClassAndMethodMatcher> methodMatchers, Set<String> exactClassNames) {
        this.methodAnnotationsToMatch = ImmutableSet.copyOf(annotationMatchers);
        this.methodMatchers = methodMatchers.entries().toArray(new Map.Entry[0]);
        this.methods = ImmutableMap.copyOf(methods.asMap());
        this.exactClassNames = exactClassNames == null ? null : ImmutableSet.copyOf(exactClassNames);
    }

    @Override
    public ClassVisitor newClassMatchVisitor(ClassLoader loader, Class<?> classBeingRedefined, ClassReader reader, ClassVisitor cv, InstrumentationContext context) {
        if (this.exactClassNames != null && !this.exactClassNames.contains(reader.getClassName())) {
            return null;
        }
        return new ClassMethods(loader, reader, classBeingRedefined, cv, context);
    }

    private Multimap<ClassAndMethodMatcher, String> newClassMatches() {
        return Multimaps.newSetMultimap(Maps.newHashMap(), STRING_COLLECTION_SUPPLIER);
    }

    public String toString() {
        return "OptimizedClassMatcher [methodMatchers=" + Arrays.toString(this.methodMatchers) + ", methods=" + this.methods + ", methodAnnotationsToMatch=" + this.methodAnnotationsToMatch + ", exactClassNames=" + this.exactClassNames + "]";
    }

    private class ClassMethods
    extends ClassVisitor {
        private final Class<?> classBeingRedefined;
        private final ClassReader cr;
        private final ClassLoader loader;
        private SetMultimap<Method, ClassAndMethodMatcher> matches;
        private Map<Method, Set<String>> methodAnnotations;
        private Map<ClassMatcher, Boolean> classMatcherMatches;
        private final InstrumentationContext context;

        private ClassMethods(ClassLoader loader, ClassReader cr, Class<?> classBeingRedefined, ClassVisitor cv, InstrumentationContext context) {
            super(393216, cv);
            this.cr = cr;
            this.classBeingRedefined = classBeingRedefined;
            this.loader = loader;
            this.context = context;
        }

        private void addMethodAnnotations(Method method, Set<String> annotations) {
            if (!annotations.isEmpty()) {
                if (this.methodAnnotations == null) {
                    this.methodAnnotations = Maps.newHashMap();
                }
                this.methodAnnotations.put(method, annotations);
            }
        }

        private SetMultimap<Method, ClassAndMethodMatcher> getOrCreateMatches() {
            if (this.matches == null) {
                this.matches = Multimaps.newSetMultimap(Maps.newHashMap(), new Supplier<Set<ClassAndMethodMatcher>>(){

                    @Override
                    public Set<ClassAndMethodMatcher> get() {
                        return Sets.newHashSet();
                    }
                });
            }
            return this.matches;
        }

        private boolean isMatch(ClassMatcher classMatcher, ClassLoader loader, ClassReader cr, Class<?> classBeingRedefined) {
            Boolean match;
            if (null == this.classMatcherMatches) {
                this.classMatcherMatches = Maps.newHashMap();
            }
            if ((match = this.classMatcherMatches.get(classMatcher)) == null) {
                match = classBeingRedefined == null ? classMatcher.isMatch(loader, cr) : classMatcher.isMatch(classBeingRedefined);
                this.classMatcherMatches.put(classMatcher, match);
            }
            return match;
        }

        @Override
        public MethodVisitor visitMethod(final int access, String methodName, String methodDesc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
            if ((access & 0x400) == 0 && (access & 0x100) == 0) {
                final Method method = new Method(methodName, methodDesc);
                if (METHODS_WE_NEVER_INSTRUMENT.contains(method)) {
                    return mv;
                }
                if (!OptimizedClassMatcher.this.methodAnnotationsToMatch.isEmpty()) {
                    mv = new MethodVisitor(393216, mv){
                        final Set<String> annotations;
                        {
                            super(x0, x1);
                            this.annotations = Sets.newHashSet();
                        }

                        @Override
                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            if (OptimizedClassMatcher.this.methodAnnotationsToMatch.contains(desc)) {
                                this.annotations.add(desc);
                            }
                            return super.visitAnnotation(desc, visible);
                        }

                        @Override
                        public void visitEnd() {
                            super.visitEnd();
                            ClassMethods.this.addMethodAnnotations(method, this.annotations);
                            if (ClassMethods.this.addMethodIfMatches(access, method, this.annotations) && (access & 0x40) != 0) {
                                ClassMethods.this.context.addBridgeMethod(method);
                            }
                        }
                    };
                } else if (this.addMethodIfMatches(access, method, ImmutableSet.of()) && (access & 0x40) != 0) {
                    this.context.addBridgeMethod(method);
                }
            }
            return mv;
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            if (this.matches != null) {
                Multimap classMatches = OptimizedClassMatcher.this.newClassMatches();
                for (ClassAndMethodMatcher matcher : this.matches.values()) {
                    for (String className : matcher.getClassMatcher().getClassNames()) {
                        classMatches.put(matcher, className);
                    }
                    classMatches.put(matcher, this.cr.getClassName());
                }
                Set<Method> daMethods = this.matches.keySet();
                Match match = new Match(classMatches, daMethods, this.methodAnnotations);
                this.context.putMatch(OptimizedClassMatcher.this, match);
            }
        }

        private boolean addMethodIfMatches(int access, Method method, Set<String> annotations) {
            boolean match = false;
            Collection<ClassAndMethodMatcher> set = OptimizedClassMatcher.this.methods.get(method);
            if (set != null) {
                for (ClassAndMethodMatcher matcher : set) {
                    if (!this.isMatch(matcher.getClassMatcher(), this.loader, this.cr, this.classBeingRedefined)) continue;
                    this.getOrCreateMatches().put(method, matcher);
                    match = true;
                }
            }
            for (Map.Entry<MethodMatcher, ClassAndMethodMatcher> entry : OptimizedClassMatcher.this.methodMatchers) {
                if (!entry.getKey().matches(access, method.getName(), method.getDescriptor(), annotations) || !this.isMatch(entry.getValue().getClassMatcher(), this.loader, this.cr, this.classBeingRedefined)) continue;
                this.getOrCreateMatches().put(method, entry.getValue());
                match = true;
            }
            return match;
        }
    }

    public static final class Match {
        public static final Match NOOP_MATCH = new Match(ImmutableMultimap.of(), Collections.emptySet(), Collections.emptyMap());
        private final Map<ClassAndMethodMatcher, Collection<String>> classNames;
        private final Set<Method> methods;
        private final Map<Method, Set<String>> methodAnnotations;

        public Match(Multimap<ClassAndMethodMatcher, String> classMatches, Set<Method> methods, Map<Method, Set<String>> methodAnnotations) {
            this.classNames = ImmutableMap.copyOf(classMatches.asMap());
            this.methods = ImmutableSet.copyOf(methods);
            this.methodAnnotations = methodAnnotations == null ? ImmutableMap.of() : methodAnnotations;
        }

        public Map<ClassAndMethodMatcher, Collection<String>> getClassMatches() {
            return this.classNames;
        }

        public Set<Method> getMethods() {
            return this.methods;
        }

        public Set<String> getMethodAnnotations(Method method) {
            Set<String> set = this.methodAnnotations.get(method);
            return set == null ? ImmutableSet.of() : set;
        }

        public boolean isClassAndMethodMatch() {
            return !this.methods.isEmpty() && !this.classNames.isEmpty();
        }

        public String toString() {
            return this.classNames.toString() + " methods " + this.methods;
        }
    }
}

