/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.tracing;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.Instrumentation;
import com.newrelic.agent.bridge.PublicApi;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.bridge.Transaction;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.AdviceAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.context.TraceInformation;
import com.newrelic.agent.instrumentation.tracing.BridgeUtils;
import com.newrelic.agent.instrumentation.tracing.FlyweightTraceMethodVisitor;
import com.newrelic.agent.instrumentation.tracing.ParameterAttributeName;
import com.newrelic.agent.instrumentation.tracing.TraceDetails;
import com.newrelic.agent.instrumentation.tracing.TraceMethodVisitor;
import com.newrelic.agent.instrumentation.tracing.TransactionName;
import com.newrelic.agent.util.asm.BytecodeGenProxyBuilder;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class TraceClassVisitor
extends ClassVisitor {
    private final String className;
    private final InstrumentationContext instrumentationContext;
    private final TraceInformation traceInfo;
    private final Set<Method> noticeSqlMethods;
    private final Set<Method> tracedMethods = Sets.newHashSet();

    public TraceClassVisitor(ClassVisitor cv, String className, InstrumentationContext context, Set<Method> noticeSqlMethods) {
        super(393216, cv);
        this.className = className;
        this.instrumentationContext = context;
        this.traceInfo = context.getTraceInformation();
        this.noticeSqlMethods = noticeSqlMethods;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (!this.traceInfo.getTraceAnnotations().isEmpty()) {
            Agent.LOG.finer("Traced " + this.className + " methods " + this.tracedMethods);
            if (this.tracedMethods.size() != this.traceInfo.getTraceAnnotations().size()) {
                HashSet<Method> expected = Sets.newHashSet(this.traceInfo.getTraceAnnotations().keySet());
                expected.removeAll(this.tracedMethods);
                Agent.LOG.finer("While tracing " + this.className + " the following methods were not traced: " + expected);
            }
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 0x40) != 0) {
            return mv;
        }
        Method method = new Method(name, desc);
        if (this.traceInfo.getIgnoreTransactionMethods().contains(method)) {
            this.instrumentationContext.markAsModified();
            return new AdviceAdapter(393216, mv, access, name, desc){

                @Override
                protected void onMethodEnter() {
                    BridgeUtils.getCurrentTransaction(this);
                    BytecodeGenProxyBuilder.newBuilder(Transaction.class, this, true).build().ignore();
                }
            };
        }
        final TraceDetails trace = this.traceInfo.getTraceAnnotations().get(method);
        if (null != trace) {
            this.tracedMethods.add(method);
            PointCut pointCut = this.instrumentationContext.getOldStylePointCut(method);
            if (pointCut == null) {
                boolean custom = trace.isCustom();
                boolean noticeSql = this.noticeSqlMethods.contains(method);
                if (trace.excludeFromTransactionTrace() && trace.isLeaf()) {
                    mv = new FlyweightTraceMethodVisitor(this.className, mv, access, name, desc, trace, this.instrumentationContext.getClassBeingRedefined());
                } else {
                    mv = new TraceMethodVisitor(this.className, mv, access, name, desc, trace, custom, noticeSql, this.instrumentationContext.getClassBeingRedefined());
                    if (!trace.getParameterAttributeNames().isEmpty()) {
                        for (ParameterAttributeName attr : trace.getParameterAttributeNames()) {
                            final ParameterAttributeName param = attr;
                            if (!param.getMethodMatcher().matches(access, name, desc, null)) continue;
                            try {
                                final Type type = method.getArgumentTypes()[param.getIndex()];
                                if (type.getSort() == 9) {
                                    Agent.LOG.log(Level.FINE, "Unable to record an attribute value for {0}.{1} because it is an array", this.className, method);
                                    continue;
                                }
                                mv = new AdviceAdapter(393216, mv, access, name, desc){

                                    @Override
                                    protected void onMethodEnter() {
                                        super.getStatic(BridgeUtils.AGENT_BRIDGE_TYPE, "publicApi", BridgeUtils.PUBLIC_API_TYPE);
                                        PublicApi api = BytecodeGenProxyBuilder.newBuilder(PublicApi.class, this, false).build();
                                        this.push(param.getAttributeName());
                                        this.loadArg(param.getIndex());
                                        if (type.getSort() != 10) {
                                            this.box(type);
                                        }
                                        Label objectLabel = this.newLabel();
                                        Label skipLabel = this.newLabel();
                                        Label popStackLabel = this.newLabel();
                                        this.dup();
                                        this.ifNull(popStackLabel);
                                        this.dup();
                                        this.instanceOf(Type.getType(Number.class));
                                        this.ifZCmp(153, objectLabel);
                                        this.checkCast(Type.getType(Number.class));
                                        api.addCustomParameter("", (Number)0);
                                        this.goTo(skipLabel);
                                        this.visitLabel(objectLabel);
                                        this.invokeVirtual(Type.getType(Object.class), new Method("toString", Type.getType(String.class), new Type[0]));
                                        api.addCustomParameter("", "");
                                        this.goTo(skipLabel);
                                        this.visitLabel(popStackLabel);
                                        this.pop();
                                        this.pop();
                                        this.pop();
                                        this.visitLabel(skipLabel);
                                    }
                                };
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                Agent.LOG.log(Level.FINEST, e, e.toString());
                            }
                        }
                    }
                    if (trace.rollupMetricName().length > 0) {
                        final int cacheId = AgentBridge.instrumentation.addToObjectCache((Object)trace.rollupMetricName());
                        mv = new AdviceAdapter(393216, mv, access, name, desc){

                            @Override
                            protected void onMethodEnter() {
                                this.getStatic(BridgeUtils.TRACED_METHOD_TYPE, "CURRENT", BridgeUtils.TRACED_METHOD_TYPE);
                                super.getStatic(BridgeUtils.AGENT_BRIDGE_TYPE, "instrumentation", BridgeUtils.INSTRUMENTATION_TYPE);
                                Instrumentation instrumentation = BytecodeGenProxyBuilder.newBuilder(Instrumentation.class, this, true).build();
                                instrumentation.getCachedObject(cacheId);
                                super.checkCast(Type.getType(String[].class));
                                TracedMethod tracedMethod = BytecodeGenProxyBuilder.newBuilder(TracedMethod.class, this, false).build();
                                tracedMethod.setRollupMetricNames((String[])null);
                            }
                        };
                    }
                    if (TransactionName.isSimpleTransactionName(trace.transactionName())) {
                        mv = new AdviceAdapter(393216, mv, access, name, desc){

                            @Override
                            protected void onMethodEnter() {
                                TracedMethod tracedMethod = BytecodeGenProxyBuilder.newBuilder(TracedMethod.class, this, true).build();
                                this.getStatic(BridgeUtils.TRACED_METHOD_TYPE, "CURRENT", BridgeUtils.TRACED_METHOD_TYPE);
                                tracedMethod.nameTransaction(trace.transactionName().transactionNamePriority);
                            }
                        };
                    } else if (trace.transactionName() != null) {
                        mv = new AdviceAdapter(393216, mv, access, name, desc){

                            @Override
                            protected void onMethodEnter() {
                                BridgeUtils.getCurrentTransaction(this);
                                Transaction transaction = BytecodeGenProxyBuilder.newBuilder(Transaction.class, this, true).build();
                                TransactionName transactionName = trace.transactionName();
                                transaction.setTransactionName(transactionName.transactionNamePriority, transactionName.override, transactionName.category, new String[]{transactionName.path});
                                this.pop();
                            }
                        };
                    }
                    if (trace.isWebTransaction()) {
                        mv = new AdviceAdapter(393216, mv, access, name, desc){

                            @Override
                            protected void onMethodExit(int opcode) {
                                this.getStatic(BridgeUtils.TRANSACTION_TYPE, "CURRENT", BridgeUtils.TRANSACTION_TYPE);
                                BytecodeGenProxyBuilder.newBuilder(Transaction.class, this, true).build().convertToWebTransaction();
                            }
                        };
                    }
                    if (null != trace.metricPrefix()) {
                        mv = new AdviceAdapter(393216, mv, access, name, desc){

                            @Override
                            protected void onMethodExit(int opcode) {
                                this.invokeStatic(BridgeUtils.AGENT_BRIDGE_TYPE, new Method("getAgent", BridgeUtils.AGENT_BRIDGE_AGENT_TYPE, new Type[0]));
                                this.invokeVirtual(BridgeUtils.AGENT_BRIDGE_AGENT_TYPE, new Method("getTracedMethod", BridgeUtils.TRACED_METHOD_TYPE, new Type[0]));
                                BytecodeGenProxyBuilder.newBuilder(TracedMethod.class, this, true).build().setCustomMetricPrefix(trace.metricPrefix());
                            }
                        };
                    }
                }
                this.instrumentationContext.addTimedMethods(method);
            } else {
                Agent.LOG.warning(this.className + '.' + method + " is matched to trace, but it was already instrumented by " + pointCut.toString());
            }
        }
        if (this.traceInfo.getIgnoreApdexMethods().contains(method)) {
            this.instrumentationContext.markAsModified();
            mv = new AdviceAdapter(393216, mv, access, name, desc){

                @Override
                protected void onMethodEnter() {
                    this.invokeStatic(BridgeUtils.NEW_RELIC_API_TYPE, TraceMethodVisitor.IGNORE_APDEX_METHOD);
                }
            };
        }
        return mv;
    }
}

