/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.profile.ProfileSession;
import com.newrelic.agent.profile.ProfilerControl;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.StartProfilerCommand;
import com.newrelic.agent.profile.StopProfilerCommand;
import com.newrelic.agent.profile.XrayProfileSession;
import com.newrelic.agent.profile.v2.TransactionProfileService;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.agent.util.SafeWrappers;
import java.text.MessageFormat;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ProfilerService
extends AbstractService
implements ProfilerControl {
    private static final String V2_PROFILER_FORMAT = "v2";
    private static final String PROFILER_THREAD_NAME = "New Relic Profiler Service";
    private ProfileSession currentSession;
    private final XrayProfileSession xrayProfileSession;
    private final ScheduledExecutorService scheduledExecutor;
    private final com.newrelic.agent.profile.v2.ProfilerService newProfilerService;

    public ProfilerService() {
        super(ProfilerService.class.getSimpleName());
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(PROFILER_THREAD_NAME, true);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.xrayProfileSession = new XrayProfileSession();
        this.newProfilerService = new com.newrelic.agent.profile.v2.ProfilerService(this.scheduledExecutor);
    }

    @Override
    public boolean isEnabled() {
        return ServiceFactory.getConfigService().getDefaultAgentConfig().getThreadProfilerConfig().isEnabled();
    }

    @Override
    public synchronized void startProfiler(ProfilerParameters parameters) {
        if (V2_PROFILER_FORMAT.equals(parameters.getProfilerFormat())) {
            this.newProfilerService.startProfiler(parameters);
            return;
        }
        long samplePeriodInMillis = parameters.getSamplePeriodInMillis();
        long durationInMillis = parameters.getDurationInMillis();
        boolean enabled = ServiceFactory.getConfigService().getDefaultAgentConfig().getThreadProfilerConfig().isEnabled();
        if (!enabled || samplePeriodInMillis <= 0L || durationInMillis <= 0L || samplePeriodInMillis > durationInMillis) {
            this.getLogger().info(MessageFormat.format("Ignoring the start profiler command: enabled={0}, samplePeriodInMillis={1}, durationInMillis={2}", enabled, samplePeriodInMillis, durationInMillis));
            return;
        }
        ProfileSession oldSession = this.currentSession;
        if (oldSession != null && !oldSession.isDone()) {
            this.getLogger().info(MessageFormat.format("Ignoring the start profiler command because a session is currently active. {0}", oldSession.getProfileId()));
            return;
        }
        this.xrayProfileSession.suspend();
        ProfileSession newSession = this.createProfileSession(parameters);
        newSession.start();
        this.currentSession = newSession;
    }

    @Override
    public synchronized int stopProfiler(Long profileId, boolean shouldReport) {
        ProfileSession session = this.currentSession;
        if (session != null && profileId.equals(session.getProfileId())) {
            session.stop(shouldReport);
            return 0;
        }
        return this.newProfilerService.stopProfiler(profileId, shouldReport);
    }

    synchronized void sessionCompleted(ProfileSession session) {
        if (this.currentSession != session) {
            return;
        }
        this.currentSession = null;
    }

    protected ProfileSession createProfileSession(ProfilerParameters parameters) {
        return new ProfileSession(this, parameters);
    }

    protected ScheduledExecutorService getScheduledExecutorService() {
        return SafeWrappers.safeExecutor(this.scheduledExecutor);
    }

    @Override
    protected void doStart() {
        this.addCommands();
        if (this.isEnabled()) {
            ServiceFactory.getHarvestService().addHarvestListener(this.xrayProfileSession);
            ServiceFactory.getXRaySessionService().addListener(this.xrayProfileSession);
        }
        try {
            this.newProfilerService.start();
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, e.getMessage());
        }
    }

    protected synchronized ProfileSession getCurrentSession() {
        return this.currentSession;
    }

    private void addCommands() {
        ServiceFactory.getCommandParser().addCommands(new StartProfilerCommand(this));
        ServiceFactory.getCommandParser().addCommands(new StopProfilerCommand(this));
    }

    @Override
    protected void doStop() {
        ProfileSession session;
        try {
            this.newProfilerService.stop();
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, e.getMessage());
        }
        if (this.isEnabled()) {
            ServiceFactory.getHarvestService().removeHarvestListener(this.xrayProfileSession);
            ServiceFactory.getXRaySessionService().removeListener(this.xrayProfileSession);
        }
        if ((session = this.getCurrentSession()) != null) {
            session.stop(false);
        }
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
            try {
                if (!this.scheduledExecutor.awaitTermination(30L, TimeUnit.SECONDS)) {
                    this.getLogger().log(Level.FINE, "Profiler Service executor service did not terminate");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public TransactionProfileService getTransactionProfileService() {
        return this.newProfilerService.getTransactionProfileService();
    }
}

