/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.reinstrument;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReinstrumentResult {
    protected static final String ERROR_KEY = "errors";
    protected static final String PCS_SPECIFIED_KEY = "pointcuts_specified";
    protected static final String RETRANSFORM_INIT_KEY = "retransform_init";
    private final List<String> errorMessages = new ArrayList<String>();
    private int pointCutsSpecified = 0;
    private int pointCutsAdded = 0;
    private Set<String> retranformedInitializedClasses = new HashSet<String>();

    public Map<String, Object> getStatusMap() {
        Iterator<String> it;
        StringBuilder sb;
        HashMap<String, Object> statusMap = new HashMap<String, Object>();
        if (this.errorMessages.size() > 0) {
            sb = new StringBuilder();
            it = this.errorMessages.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            statusMap.put(ERROR_KEY, sb.toString());
        }
        statusMap.put(PCS_SPECIFIED_KEY, this.pointCutsSpecified);
        if (this.retranformedInitializedClasses.size() > 0) {
            sb = new StringBuilder();
            it = this.retranformedInitializedClasses.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            statusMap.put(RETRANSFORM_INIT_KEY, sb.toString());
        }
        return statusMap;
    }

    public void addErrorMessage(String pErrorMessages) {
        this.errorMessages.add(pErrorMessages);
    }

    public void setPointCutsSpecified(int pPointCutsSpecified) {
        this.pointCutsSpecified = pPointCutsSpecified;
    }

    public void setRetranformedInitializedClasses(Set<String> pRetranformedInitializedClasses) {
        this.retranformedInitializedClasses = pRetranformedInitializedClasses;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PCS_SPECIFIED_KEY);
        sb.append(":");
        sb.append(this.pointCutsSpecified);
        sb.append(", ");
        if (this.errorMessages != null && this.errorMessages.size() > 0) {
            sb.append(",");
            sb.append(ERROR_KEY);
            sb.append(":[");
            for (String msg : this.errorMessages) {
                sb.append(" ");
                sb.append(msg);
            }
            sb.append("]");
        }
        if (this.retranformedInitializedClasses != null && this.retranformedInitializedClasses.size() > 0) {
            sb.append(", ");
            sb.append(RETRANSFORM_INIT_KEY);
            sb.append(":[");
            for (String msg : this.retranformedInitializedClasses) {
                sb.append(" ");
                sb.append(msg);
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

