/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.Service;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.BaseInternalCustomEvent;
import com.newrelic.agent.service.analytics.DistributedSamplingPriorityQueue;
import com.newrelic.agent.stats.StatsEngine;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentHashMap;

public class InternalCustomEventService
extends AbstractService
implements Service,
HarvestListener {
    private static final int MAX_EVENTS_PER_HARVEST = 501;
    private final ConcurrentHashMap<String, DistributedSamplingPriorityQueue<BaseInternalCustomEvent>> reservoirForApp = new ConcurrentHashMap();
    private final ArrayDeque<DistributedSamplingPriorityQueue<BaseInternalCustomEvent>> pendingEvents = new ArrayDeque();

    public InternalCustomEventService(String name) {
        super(name);
    }

    public InternalCustomEventService() {
        this(InternalCustomEventService.class.getSimpleName());
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        DistributedSamplingPriorityQueue<BaseInternalCustomEvent> toSend;
        DistributedSamplingPriorityQueue current = this.reservoirForApp.put(appName, new DistributedSamplingPriorityQueue(501));
        if (current != null && current.size() > 0) {
            if (this.pendingEvents.size() < 25) {
                this.pendingEvents.add(current);
            } else {
                Agent.LOG.fine(MessageFormat.format("{0} events were discarded.", this.pendingEvents.size()));
                statsEngine.getStats("Supportability/InternalCustomEvents/Discarded").incrementCallCount(this.pendingEvents.size());
            }
        }
        int maxToSend = 5;
        for (int nSent = 0; nSent < 5 && (toSend = this.pendingEvents.poll()) != null; ++nSent) {
            try {
                ServiceFactory.getRPMService(appName).sendInternalCustomEvents(501, toSend.getNumberOfTries(), toSend.asList());
                statsEngine.getStats("Supportability/InternalCustomEvents/TotalEventsSent").incrementCallCount(toSend.size());
                statsEngine.getStats("Supportability/InternalCustomEvents/TotalEventsSeen").incrementCallCount(toSend.getNumberOfTries());
                continue;
            }
            catch (Exception e) {
                Agent.LOG.fine("Unable to send events. This operation will be retried.");
                this.pendingEvents.add(toSend);
                break;
            }
        }
    }

    @Override
    public void afterHarvest(String appName) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceFactory.getHarvestService().addHarvestListener(this);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getHarvestService().removeHarvestListener(this);
        this.reservoirForApp.clear();
    }

    public void addInternalCustomEvent(BaseInternalCustomEvent event) {
        DistributedSamplingPriorityQueue<BaseInternalCustomEvent> reservoir = this.reservoirForApp.get(event.getAppName());
        while (reservoir == null) {
            this.reservoirForApp.putIfAbsent(event.getAppName(), new DistributedSamplingPriorityQueue(501));
            reservoir = this.reservoirForApp.get(event.getAppName());
        }
        reservoir.add(event);
    }
}

