/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.sql;

import com.newrelic.agent.Agent;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.sql.BoundedConcurrentCache;
import com.newrelic.agent.sql.SlowQueryAggregator;
import com.newrelic.agent.sql.SlowQueryInfo;
import com.newrelic.agent.sql.SlowQueryListener;
import com.newrelic.agent.sql.SqlTrace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;

public class SlowQueryAggregatorImpl
implements SlowQueryAggregator {
    public static final String BACKTRACE_KEY = "backtrace";
    public static final String EXPLAIN_PLAN_KEY = "explain_plan";
    public static final int SLOW_QUERY_LIMIT_PER_REPORTING_PERIOD = 10;
    static final int MAX_SLOW_QUERY_STATEMENTS = 200;
    private final BoundedConcurrentCache<String, SlowQueryInfo> slowQueries = new BoundedConcurrentCache(200);
    private final Lock readLock;
    private final Lock writeLock;

    public SlowQueryAggregatorImpl() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    @Override
    public List<SqlTrace> getAndClearSlowQueries() {
        List<SlowQueryInfo> slowQueries = this.getAndClearSlowQueriesUnderLock();
        if (slowQueries == null || slowQueries.isEmpty()) {
            return Collections.emptyList();
        }
        return this.createSqlTraces(slowQueries);
    }

    public int getSlowQueryCount() {
        return this.slowQueries.size();
    }

    protected List<SlowQueryInfo> getSlowQueriesForTesting() {
        return this.slowQueries.asList();
    }

    private List<SqlTrace> createSqlTraces(List<SlowQueryInfo> slowQueries) {
        List<SlowQueryInfo> topSlowQueries = this.getTopSlowQueries(slowQueries);
        ArrayList<SqlTrace> results = new ArrayList<SqlTrace>(topSlowQueries.size());
        for (SlowQueryInfo slowQuery : topSlowQueries) {
            if (slowQuery.getTransactionData() == null) continue;
            results.add(slowQuery.asSqlTrace());
        }
        return results;
    }

    private List<SlowQueryInfo> getTopSlowQueries(List<SlowQueryInfo> slowQueries) {
        if (slowQueries.size() <= 10) {
            return slowQueries;
        }
        Collections.sort(slowQueries);
        return slowQueries.subList(slowQueries.size() - 10, slowQueries.size());
    }

    private List<SlowQueryInfo> getAndClearSlowQueriesUnderLock() {
        this.writeLock.lock();
        try {
            List<SlowQueryInfo> results = this.slowQueries.asList();
            this.slowQueries.clear();
            List<SlowQueryInfo> list = results;
            return list;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void addSlowQueriesFromTransaction(TransactionData td) {
        SlowQueryListener listener = td.getSlowQueryListener();
        if (listener == null) {
            Agent.LOG.finest("SlowQueryAggregator: addSlowQueriesFromTransaction: no listener");
            return;
        }
        List<SlowQueryInfo> slowQueries = listener.getSlowQueries();
        if (slowQueries.isEmpty()) {
            Agent.LOG.finest("SlowQueryAggregator: addSlowQueriesFromTransaction: no slow queries");
            return;
        }
        Agent.LOG.log(Level.FINEST, "SlowQueryAggregator: addSlowQueriesFromTransaction: slow queries: {0}", slowQueries.size());
        this.addSlowQueriesUnderLock(td, slowQueries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSlowQueriesUnderLock(TransactionData td, List<SlowQueryInfo> slowQueries) {
        this.readLock.lock();
        try {
            for (SlowQueryInfo slowQuery : slowQueries) {
                this.addSlowQuery(td, slowQuery);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addSlowQuery(TransactionData td, SlowQueryInfo slowQuery) {
        SlowQueryInfo existingInfo;
        String obfuscatedQuery = slowQuery.getObfuscatedQuery();
        if (slowQuery.getTransactionData() == null) {
            slowQuery.setTransactionData(td);
        }
        if ((existingInfo = this.slowQueries.get(obfuscatedQuery)) != null) {
            existingInfo.aggregate(slowQuery);
            this.slowQueries.putReplace(obfuscatedQuery, existingInfo);
        } else {
            this.slowQueries.putIfAbsent(obfuscatedQuery, slowQuery);
        }
    }
}

