/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent.tracing;

import com.newrelic.agent.bridge.Span;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.api.agent.DistributedTracePayload;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NewRelicSpanContext
implements com.newrelic.api.agent.NewRelicSpanContext {
    private final Span span;
    private final DistributedTracePayload payload;
    private final Map<String, String> baggage;

    public NewRelicSpanContext(Span span, NewRelicSpanContext parentSpanContext) {
        this.span = span;
        this.payload = null;
        this.baggage = parentSpanContext == null ? new ConcurrentHashMap() : parentSpanContext.getBaggage();
    }

    public NewRelicSpanContext(DistributedTracePayload payload, Map<String, String> baggage) {
        this.span = null;
        this.payload = payload;
        this.baggage = baggage;
    }

    public Span getSpan() {
        return this.span;
    }

    public DistributedTracePayload getOrCreatePayload() {
        return this.span != null ? this.span.createDistributedTracePayload() : this.payload;
    }

    public Map<String, String> getBaggage() {
        return this.baggage;
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return ImmutableSet.copyOf(this.baggage.entrySet());
    }

    public String toString() {
        return "NewRelicSpanContext{span=" + this.span + ", payload=" + this.payload + ", baggage=" + this.baggage + '}';
    }
}

