/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AnnotationNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InnerClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.VarInsnNode;
import com.newrelic.api.agent.weaver.WeaveAllConstructors;
import com.newrelic.weave.CallOriginalReplacement;
import com.newrelic.weave.GeneratedNewFieldMethod;
import com.newrelic.weave.MatchableMethod;
import com.newrelic.weave.MethodKey;
import com.newrelic.weave.MethodProcessors;
import com.newrelic.weave.utils.ClassCache;
import com.newrelic.weave.utils.ClassInformation;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.violation.WeaveViolation;
import com.newrelic.weave.violation.WeaveViolationType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassMatch {
    private static final String SERIAL_VERSION_UID_FIELD_NAME = "serialVersionUID";
    private final ClassNode original;
    private final ClassNode weave;
    private final boolean isBaseMatch;
    private final boolean isInterfaceMatch;
    private final Map<MethodKey, MatchableMethod> matchableMethods;
    private final Set<String> allOriginalInterfaces;
    private final List<WeaveViolation> violations = Lists.newArrayList();
    private final Set<String> requiredClassAnnotations;
    private final Set<String> requiredMethodAnnotations;
    private final Set<String> newFields = Sets.newHashSetWithExpectedSize(1);
    private final Set<String> matchedFields = Sets.newHashSetWithExpectedSize(3);
    private final Set<Method> newMethods = Sets.newHashSetWithExpectedSize(5);
    private final Set<Method> matchedMethods = Sets.newHashSetWithExpectedSize(5);
    private final Map<Method, GeneratedNewFieldMethod> generatedNewFieldMethods = Maps.newHashMapWithExpectedSize(1);
    private final Set<String> newInnerClasses = Sets.newHashSetWithExpectedSize(0);
    private final Set<String> matchedInnerClasses = Sets.newHashSetWithExpectedSize(0);
    private Map<String, AnnotationNode> classAnnotationMap = new HashMap<String, AnnotationNode>();
    private MethodNode extensionClassInit;
    private final Map<Method, CallOriginalReplacement> originalReplacements = Maps.newHashMap();
    private boolean weavesAllConstructors;
    private MethodNode weavesAllMethod;
    private Map<MethodNode, MethodNode> weaveAllMatchedMethods = Maps.newHashMap();
    private Set<MethodNode> classAnnotationGetters = new HashSet<MethodNode>();
    private Map<MethodKey, Map<String, AnnotationNode>> methodsToAnnotations = new HashMap<MethodKey, Map<String, AnnotationNode>>();
    private boolean fatalWeaveViolation = false;

    private ClassMatch(ClassNode original, ClassNode weave, boolean isBaseMatch, Map<MethodKey, MatchableMethod> matchableMethods, Set<String> allOriginalInterfaces, Set<String> requiredClassAnnotations, Set<String> requiredMethodAnnotations) {
        this.original = original;
        this.weave = weave;
        this.requiredClassAnnotations = requiredClassAnnotations;
        this.requiredMethodAnnotations = requiredMethodAnnotations;
        this.isBaseMatch = isBaseMatch;
        this.isInterfaceMatch = (original.access & 0x200) != 0;
        this.matchableMethods = matchableMethods;
        this.allOriginalInterfaces = allOriginalInterfaces;
    }

    public static ClassMatch match(ClassNode original, ClassNode weave, boolean isBaseMatch, Set<String> requiredClassAnnotations, Set<String> requiredMethodAnnotations, ClassCache cache) throws IOException {
        Map<MethodKey, MatchableMethod> matchableMethods = MatchableMethod.findMatchableMethods(original, cache, isBaseMatch);
        Set<String> allOriginalInterfaces = ClassInformation.fromClassNode(original).getAllInterfaces(cache);
        ClassMatch result = new ClassMatch(original, weave, isBaseMatch, matchableMethods, allOriginalInterfaces, requiredClassAnnotations, requiredMethodAnnotations);
        result.match(cache);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void match(ClassCache cache) {
        boolean bl;
        void var5_14;
        boolean isWeaveWithAnnotation;
        if ((this.weave.access & 0x200) != 0) {
            this.addViolation(WeaveViolationType.CLASS_WEAVE_IS_INTERFACE);
            this.fatalWeaveViolation = true;
            return;
        }
        if ((this.weave.access & 0x4000) != 0) {
            this.processEnumMethods();
        }
        if (this.weave.version > WeaveUtils.RUNTIME_MAX_SUPPORTED_CLASS_VERSION) {
            this.addViolation(WeaveViolationType.INCOMPATIBLE_BYTECODE_VERSION);
        }
        boolean bl2 = isWeaveWithAnnotation = !this.requiredClassAnnotations.isEmpty() || !this.requiredMethodAnnotations.isEmpty();
        if ((this.original.access & 1) != (this.weave.access & 1) && !isWeaveWithAnnotation) {
            this.addViolation(WeaveViolationType.CLASS_ACCESS_MISMATCH);
        }
        if (this.weave.interfaces.size() > 0) {
            for (String string : this.weave.interfaces) {
                if (this.allOriginalInterfaces.contains(string)) continue;
                this.addViolation(WeaveViolationType.CLASS_IMPLEMENTS_ILLEGAL_INTERFACE);
            }
        }
        if (!this.requiredClassAnnotations.isEmpty()) {
            this.processRequiredClassAnnotations(cache);
        }
        if (this.requiredClassAnnotations.isEmpty() && !this.requiredMethodAnnotations.isEmpty()) {
            this.processRequiredMethodAnnotations(cache);
        }
        if (!this.weave.superName.equals(WeaveUtils.JAVA_LANG_OBJECT_NAME) && !this.weave.superName.equals(this.original.superName)) {
            this.addViolation(WeaveViolationType.CLASS_EXTENDS_ILLEGAL_SUPERCLASS);
        }
        if (WeaveUtils.isNonstaticInnerClass(this.weave)) {
            this.addViolation(WeaveViolationType.CLASS_NESTED_NONSTATIC_UNSUPPORTED);
        }
        this.weavesAllMethod = this.findAndValidateWeaveIntoAllMethod();
        HashMap<String, InnerClassNode> originalInnerClasses = Maps.newHashMap();
        for (InnerClassNode innerClassNode : this.original.innerClasses) {
            originalInnerClasses.put(innerClassNode.name, innerClassNode);
        }
        for (InnerClassNode innerClassNode : this.weave.innerClasses) {
            String string = innerClassNode.name;
            if (this.weave.name.equals(string) || innerClassNode.outerName != null && !innerClassNode.outerName.equals(this.weave.name)) continue;
            if (WeaveUtils.isAnonymousInnerClass(innerClassNode)) {
                this.newInnerClasses.add(string);
                continue;
            }
            if (originalInnerClasses.containsKey(string)) {
                this.matchedInnerClasses.add(string);
                continue;
            }
            this.newInnerClasses.add(string);
        }
        HashMap<String, FieldNode> hashMap = Maps.newHashMap();
        for (FieldNode fieldNode : this.original.fields) {
            hashMap.put(fieldNode.name, fieldNode);
        }
        for (FieldNode fieldNode : this.weave.fields) {
            if (fieldNode.name.equals(SERIAL_VERSION_UID_FIELD_NAME)) {
                this.addViolation(WeaveViolationType.FIELD_SERIALVERSIONUID_UNSUPPORTED, fieldNode);
                continue;
            }
            FieldNode fieldNode2 = (FieldNode)hashMap.get(fieldNode.name);
            if (fieldNode2 == null) {
                this.newFields.add(fieldNode.name);
                continue;
            }
            this.validateMatchedField(fieldNode2, fieldNode);
            this.matchedFields.add(fieldNode.name);
        }
        if ((this.weave.access & 0x4000) != 0 && this.newFields.size() > 0) {
            this.addViolation(WeaveViolationType.ENUM_NEW_FIELD);
        }
        Object var5_13 = null;
        for (MethodNode methodNode : this.weave.methods) {
            if (methodNode.name.equals("<clinit>")) {
                MethodNode methodNode2 = methodNode;
                continue;
            }
            if (methodNode.name.equals("<init>")) {
                this.processInitFieldAssignment(methodNode);
            }
            if (WeaveUtils.isEmptyConstructor(methodNode) || (methodNode.access & 0x40) != 0) continue;
            if (WeaveUtils.isSyntheticAccessor(methodNode.name)) {
                if ((methodNode.access & 0x1000) != 4096) {
                    this.addViolation(WeaveViolationType.METHOD_SYNTHETIC_WEAVE_ILLEGAL, methodNode);
                    continue;
                }
                GeneratedNewFieldMethod generatedNewFieldMethod = GeneratedNewFieldMethod.isGeneratedNewFieldMethod(methodNode, this.newFields);
                if (generatedNewFieldMethod == null) continue;
                this.generatedNewFieldMethods.put(generatedNewFieldMethod.method, generatedNewFieldMethod);
                continue;
            }
            if (WeaveUtils.hasWeaveIntoAllMethodsAnnotation(methodNode)) {
                this.processWeaveIntoAllMethods(methodNode, cache);
                continue;
            }
            MatchableMethod matchedMethod = this.matchableMethods.get(new MethodKey(methodNode));
            Method asmMethod = new Method(methodNode.name, methodNode.desc);
            if (matchedMethod == null) {
                this.newMethods.add(asmMethod);
                continue;
            }
            this.validateMatchedMethod(matchedMethod, methodNode);
            this.matchedMethods.add(asmMethod);
        }
        if (null != var5_14) {
            this.extensionClassInit = this.validateClassInit((MethodNode)var5_14);
        }
        if (this.isInterfaceMatch && this.newMethods.contains(WeaveUtils.DEFAULT_CONSTRUCTOR)) {
            this.newMethods.remove(WeaveUtils.DEFAULT_CONSTRUCTOR);
            this.matchedMethods.add(WeaveUtils.DEFAULT_CONSTRUCTOR);
        }
        this.weavesAllConstructors = this.validateWeaveAllConstructors();
        boolean bl3 = false;
        for (MethodNode weaveMethod : this.weave.methods) {
            WeaveMethodInstructionScanner instructionInfo = new WeaveMethodInstructionScanner();
            weaveMethod.accept(instructionInfo);
            this.validateWeaveMethod(weaveMethod, instructionInfo);
            if (instructionInfo.isClassAnnotationGetter) {
                this.classAnnotationGetters.add(weaveMethod);
                bl = true;
            }
            if (!instructionInfo.isMethodAnnotationGetter) continue;
            if (weaveMethod.equals(this.weavesAllMethod)) {
                for (MethodNode originalMethod : this.original.methods) {
                    this.storeMethodAnnotations(originalMethod);
                }
            } else {
                MethodNode originalMethod = WeaveUtils.getMethodNode(this.original, weaveMethod.name, weaveMethod.desc);
                this.storeMethodAnnotations(originalMethod);
            }
            if (!WeaveUtils.isWeaveWithAnnotationInterfaceMatch(this.weave)) continue;
            for (String interfaceName : this.original.interfaces) {
                try {
                    ClassInformation interfaceInformation = cache.getClassInformation(interfaceName);
                    HashSet<MethodKey> weaveMethodKeys = new HashSet<MethodKey>();
                    for (MethodNode methodNode : this.weave.methods) {
                        weaveMethodKeys.add(new MethodKey(methodNode));
                    }
                    for (MethodNode methodNode : this.weaveAllMatchedMethods.keySet()) {
                        weaveMethodKeys.add(new MethodKey(methodNode));
                    }
                    for (ClassInformation.MemberInformation memberInformation : interfaceInformation.methods) {
                        MethodKey methodKey = new MethodKey(memberInformation.name, memberInformation.desc);
                        if (!weaveMethodKeys.contains(methodKey)) continue;
                        if (this.methodsToAnnotations.containsKey(methodKey)) {
                            this.methodsToAnnotations.put(methodKey, new HashMap());
                        }
                        for (AnnotationNode annotation : memberInformation.annotations) {
                            this.methodsToAnnotations.get(methodKey).put(Type.getType(annotation.desc).getClassName(), annotation);
                        }
                    }
                }
                catch (IOException interfaceInformation) {
                }
            }
        }
        if (bl) {
            List<AnnotationNode> list = WeaveUtils.getClassAnnotations(this.original);
            for (AnnotationNode classAnnotation : list) {
                this.classAnnotationMap.put(Type.getType(classAnnotation.desc).getClassName(), classAnnotation);
            }
            if (WeaveUtils.isWeaveWithAnnotationInterfaceMatch(this.weave)) {
                for (String interfaceName : this.original.interfaces) {
                    try {
                        ClassInformation interfaceInformation = cache.getClassInformation(interfaceName);
                        for (AnnotationNode annotationNode : interfaceInformation.classAnnotationNodes) {
                            this.classAnnotationMap.put(Type.getType(annotationNode.desc).getClassName(), annotationNode);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
            }
        }
    }

    private void storeMethodAnnotations(MethodNode originalMethod) {
        MethodKey key = new MethodKey(originalMethod);
        if (this.methodsToAnnotations.get(key) == null) {
            this.methodsToAnnotations.put(key, new HashMap());
        }
        for (AnnotationNode methodAnnotation : WeaveUtils.getMethodAnnotations(originalMethod)) {
            String annotationInternalName = Type.getType(methodAnnotation.desc).getClassName();
            this.methodsToAnnotations.get(key).put(annotationInternalName, methodAnnotation);
        }
    }

    private void processWeaveIntoAllMethods(MethodNode weaveMethod, ClassCache cache) {
        Set<String> methodRequiredAnnotations = WeaveUtils.getMethodRequiredAnnotations(WeaveUtils.getMethodAnnotations(weaveMethod));
        boolean requiresMethodAnnotationToMatch = !methodRequiredAnnotations.isEmpty();
        for (MethodNode originalMethod : this.original.methods) {
            boolean methodHasRequiredAnnotation;
            if (WeaveUtils.isSyntheticAccessor(originalMethod.name) || WeaveUtils.isConstructor(originalMethod.name) || WeaveUtils.isStaticInitializer(originalMethod.name) || WeaveUtils.isMethodWeNeverInstrument(originalMethod) || requiresMethodAnnotationToMatch && (!(methodHasRequiredAnnotation = WeaveUtils.hasRequiredAnnotations(originalMethod, methodRequiredAnnotations)) && !WeaveUtils.isWeaveWithAnnotationInterfaceMatch(this.weave) || !methodHasRequiredAnnotation && !this.requiredMethodAnnotationInInterface(originalMethod, methodRequiredAnnotations, cache))) continue;
            this.weaveAllMatchedMethods.put(originalMethod, weaveMethod);
        }
    }

    private boolean requiredMethodAnnotationInInterface(MethodNode originalMethod, Set<String> methodRequiredAnnotations, ClassCache cache) {
        try {
            for (String interfaceName : this.original.interfaces) {
                ClassInformation interfaceInformation = cache.getClassInformation(interfaceName);
                for (ClassInformation.MemberInformation method : interfaceInformation.methods) {
                    if (!method.name.equals(originalMethod.name) || !method.desc.equals(originalMethod.desc)) continue;
                    Set<AnnotationNode> annotations = method.annotations;
                    HashSet<String> annotationClasses = new HashSet<String>();
                    for (AnnotationNode annotation : annotations) {
                        annotationClasses.add(Type.getType(annotation.desc).getClassName());
                    }
                    if (!WeaveUtils.hasRequiredAnnotations(annotationClasses, methodRequiredAnnotations)) continue;
                    return true;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private void processRequiredClassAnnotations(ClassCache cache) {
        List<AnnotationNode> annotationsInOriginal = WeaveUtils.getClassAnnotations(this.original);
        HashSet<String> classAnnotations = Sets.newHashSetWithExpectedSize(annotationsInOriginal.size());
        for (AnnotationNode annotationNode : annotationsInOriginal) {
            classAnnotations.add(Type.getType(annotationNode.desc).getClassName());
        }
        if (this.isOneOfRequiredAnnotations(classAnnotations, this.requiredClassAnnotations)) {
            return;
        }
        if (WeaveUtils.isWeaveWithAnnotationInterfaceMatch(this.weave)) {
            try {
                for (String interfaceName : this.original.interfaces) {
                    ClassInformation interfaceInformation = cache.getClassInformation(interfaceName);
                    if (!this.isOneOfRequiredAnnotations(interfaceInformation.classAnnotationNames, this.requiredClassAnnotations)) continue;
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.addViolation(WeaveViolationType.CLASS_MISSING_REQUIRED_ANNOTATIONS);
    }

    private void processRequiredMethodAnnotations(ClassCache cache) {
        List<AnnotationNode> annotationsInOriginal = WeaveUtils.getMethodAnnotations(this.original);
        HashSet<String> methodAnnotations = Sets.newHashSetWithExpectedSize(annotationsInOriginal.size());
        for (AnnotationNode annotationNode : annotationsInOriginal) {
            methodAnnotations.add(Type.getType(annotationNode.desc).getClassName());
        }
        if (this.isOneOfRequiredAnnotations(methodAnnotations, this.requiredMethodAnnotations)) {
            return;
        }
        this.addViolation(WeaveViolationType.METHOD_MISSING_REQUIRED_ANNOTATIONS);
    }

    private boolean isOneOfRequiredAnnotations(Set<String> annotations, Set<String> requiredClassAnnotations) {
        for (String requiredAnnotation : requiredClassAnnotations) {
            if (!annotations.contains(requiredAnnotation)) continue;
            return true;
        }
        return false;
    }

    private boolean validateWeaveAllConstructors() {
        List<MethodNode> ctors = this.getConstructors();
        List<MethodNode> weaveAllConstructors = this.getWeaveAllConstructors(ctors);
        if (weaveAllConstructors.isEmpty()) {
            return false;
        }
        if (weaveAllConstructors.size() > 1) {
            this.addViolation(WeaveViolationType.INIT_WEAVE_ALL_NO_OTHER_INIT_ALLOWED);
            return false;
        }
        if (weaveAllConstructors.size() == 1 && ctors.size() > 1) {
            this.addViolation(WeaveViolationType.INIT_WEAVE_ALL_NO_OTHER_INIT_ALLOWED);
            return false;
        }
        MethodNode weaveAllCtor = weaveAllConstructors.get(0);
        if (!WeaveUtils.DEFAULT_CONSTRUCTOR.getDescriptor().equals(weaveAllCtor.desc)) {
            this.addViolation(WeaveViolationType.INIT_WEAVE_ALL_WITH_ARGS_PROHIBITED);
            return false;
        }
        return true;
    }

    private List<MethodNode> getConstructors() {
        ArrayList<MethodNode> ctors = new ArrayList<MethodNode>();
        for (MethodNode weaveMethod : this.weave.methods) {
            if (!"<init>".equals(weaveMethod.name)) continue;
            ctors.add(weaveMethod);
        }
        return ctors;
    }

    private List<MethodNode> getWeaveAllConstructors(List<MethodNode> ctors) {
        ArrayList<MethodNode> weaveAllConstructors = new ArrayList<MethodNode>();
        for (MethodNode ctor : ctors) {
            if (ctor.visibleAnnotations == null) continue;
            for (AnnotationNode annotation : ctor.visibleAnnotations) {
                if (!annotation.desc.equals(Type.getType(WeaveAllConstructors.class).getDescriptor())) continue;
                weaveAllConstructors.add(ctor);
            }
        }
        return weaveAllConstructors;
    }

    private MethodNode findAndValidateWeaveIntoAllMethod() {
        MethodNode result = null;
        for (MethodNode method : this.weave.methods) {
            List<AnnotationNode> visibleAnnotations = method.visibleAnnotations;
            if (visibleAnnotations == null) continue;
            boolean methodHasVoidReturnNoParameters = method.desc.endsWith("()V");
            for (AnnotationNode annotationNode : visibleAnnotations) {
                if (!WeaveUtils.WEAVE_ALL_METHODS_TYPE.getDescriptor().equals(annotationNode.desc)) continue;
                if (!methodHasVoidReturnNoParameters) {
                    this.addViolation(WeaveViolationType.NON_VOID_NO_PARAMETERS_WEAVE_ALL_METHODS);
                    return null;
                }
                if ((method.access & 8) != 8) {
                    this.addViolation(WeaveViolationType.NON_STATIC_WEAVE_INTO_ALL_METHODS);
                }
                if (this.weavesAllMethod != null) {
                    this.addViolation(WeaveViolationType.MULTIPLE_WEAVE_ALL_METHODS);
                    return null;
                }
                result = method;
            }
        }
        if (result != null) {
            this.weave.methods.remove(result);
            result = MethodProcessors.removeLineNumbers(result);
            result = MethodProcessors.removeJSRInstructions(result);
            result = MethodProcessors.removeReturnInstructions(result);
            this.weave.methods.add(result);
        }
        return result;
    }

    private void processEnumMethods() {
        MethodNode clinitMethod = WeaveUtils.getMethodNode(this.weave, "<clinit>", WeaveUtils.CLASS_INIT_METHOD.getDescriptor());
        this.weave.methods.remove(clinitMethod);
        MethodNode valuesMethod = WeaveUtils.getMethodNode(this.weave, "values", "()[L" + this.weave.name + ";");
        this.weave.methods.remove(valuesMethod);
        HashSet<MethodNode> constructorMethods = new HashSet<MethodNode>();
        List<MethodNode> methods = this.weave.methods;
        for (MethodNode methodNode : methods) {
            if (!methodNode.name.equals("<init>")) continue;
            constructorMethods.add(methodNode);
        }
        this.weave.methods.removeAll(constructorMethods);
    }

    private void validateMatchedField(FieldNode originalField, FieldNode weaveField) {
        if (!Type.getType(originalField.desc).equals(Type.getType(weaveField.desc))) {
            this.addViolation(WeaveViolationType.FIELD_TYPE_MISMATCH, weaveField);
        }
        if ((originalField.access & 8) != (weaveField.access & 8)) {
            this.addViolation(WeaveViolationType.FIELD_STATIC_MISMATCH, weaveField);
        }
        if ((originalField.access & 0x10) != (weaveField.access & 0x10)) {
            this.addViolation(WeaveViolationType.FIELD_FINAL_MISMATCH, weaveField);
        }
        if (this.isBaseMatch && (originalField.access & 2) != 0) {
            this.addViolation(WeaveViolationType.FIELD_PRIVATE_BASE_CLASS_MATCH, weaveField);
        }
        if ((originalField.access & 1) != (weaveField.access & 1) || (originalField.access & 4) != (weaveField.access & 4) || (originalField.access & 2) != (weaveField.access & 2)) {
            this.addViolation(WeaveViolationType.FIELD_ACCESS_MISMATCH, weaveField);
        }
    }

    private void validateMatchedMethod(MatchableMethod matchedMethod, MethodNode weaveMethod) {
        boolean isWeaveAbstract;
        Set<String> requiredMethodAnnotations;
        MethodNode originalMethod = matchedMethod.methodNode;
        if (!Type.getReturnType(originalMethod.desc).equals(Type.getReturnType(weaveMethod.desc))) {
            this.addViolation(WeaveViolationType.METHOD_RETURNTYPE_MISMATCH, weaveMethod);
        }
        if ((originalMethod.access & 0x100) != 0 || (weaveMethod.access & 0x100) != 0) {
            this.addViolation(WeaveViolationType.METHOD_NATIVE_UNSUPPORTED, weaveMethod);
        }
        if ((originalMethod.access & 8) != (weaveMethod.access & 8)) {
            this.addViolation(WeaveViolationType.METHOD_STATIC_MISMATCH, weaveMethod);
        }
        if ((originalMethod.access & 1) != (weaveMethod.access & 1) || (originalMethod.access & 4) != (weaveMethod.access & 4) || (originalMethod.access & 2) != (weaveMethod.access & 2)) {
            this.addViolation(WeaveViolationType.METHOD_ACCESS_MISMATCH, weaveMethod);
        }
        HashSet<String> originalMethodExceptions = Sets.newHashSet();
        if (originalMethod.exceptions != null) {
            originalMethodExceptions.addAll(originalMethod.exceptions);
        }
        if (!(weaveMethod.exceptions == null || weaveMethod.exceptions.size() == 1 && weaveMethod.exceptions.get(0).equals("java/lang/Exception") || originalMethodExceptions.containsAll(weaveMethod.exceptions))) {
            this.addViolation(WeaveViolationType.METHOD_THROWS_MISMATCH, weaveMethod);
        }
        if (!(requiredMethodAnnotations = WeaveUtils.getMethodRequiredAnnotations(weaveMethod.visibleAnnotations)).isEmpty()) {
            boolean foundRequiredAnnotation = false;
            List<AnnotationNode> methodAnnotations = WeaveUtils.getMethodAnnotations(originalMethod);
            for (AnnotationNode methodAnnotation : methodAnnotations) {
                if (!requiredMethodAnnotations.contains(Type.getType(methodAnnotation.desc).getClassName())) continue;
                foundRequiredAnnotation = true;
                break;
            }
            if (!foundRequiredAnnotation) {
                this.addViolation(WeaveViolationType.METHOD_MISSING_REQUIRED_ANNOTATIONS, originalMethod);
            }
        }
        boolean bl = isWeaveAbstract = (weaveMethod.access & 0x400) != 0;
        if (!matchedMethod.isWeavable && !isWeaveAbstract) {
            WeaveViolationType type;
            switch (matchedMethod.source) {
                case INTERFACE: {
                    type = WeaveViolationType.METHOD_INDIRECT_INTERFACE_WEAVE;
                    break;
                }
                case SUPERCLASS: {
                    type = WeaveViolationType.METHOD_BASE_CONCRETE_WEAVE;
                    break;
                }
                default: {
                    type = WeaveViolationType.METHOD_EXACT_ABSTRACT_WEAVE;
                }
            }
            this.addViolation(type, weaveMethod);
        }
    }

    private void validateWeaveMethod(MethodNode weaveMethod, WeaveMethodInstructionScanner instructionInfo) {
        Method methodKey;
        boolean isNewMethod;
        if (instructionInfo.callsSyntheticAccessor) {
            this.addViolation(WeaveViolationType.CLASS_NESTED_IMPLICIT_OUTER_ACCESS_UNSUPPORTED, weaveMethod);
        }
        if (!(!(isNewMethod = this.newMethods.contains(methodKey = new Method(weaveMethod.name, weaveMethod.desc))) || weaveMethod.name.equals("<init>") && this.weavesAllConstructors)) {
            if (weaveMethod.name.equals("<init>")) {
                this.addViolation(WeaveViolationType.INIT_NEW_UNSUPPORTED, weaveMethod);
            }
            if (instructionInfo.callsNewMethod) {
                this.addViolation(WeaveViolationType.METHOD_NEW_INVOKE_UNSUPPORTED, weaveMethod);
            }
            if (instructionInfo.numCallOriginalInvocations > 0) {
                this.addViolation(WeaveViolationType.METHOD_NEW_CALL_ORIGINAL_UNSUPPORTED, weaveMethod);
            }
            if ((weaveMethod.access & 0x400) != 0) {
                this.addViolation(WeaveViolationType.METHOD_NEW_ABSTRACT_UNSUPPORTED, weaveMethod);
            }
            if ((weaveMethod.access & 2) == 0) {
                this.addViolation(WeaveViolationType.METHOD_NEW_NON_PRIVATE_UNSUPPORTED, weaveMethod);
            }
        }
        if (!(isNewMethod || weaveMethod.name.equals("<clinit>") || weaveMethod.name.equals("<init>"))) {
            if (instructionInfo.numCallOriginalInvocations > 1) {
                this.addViolation(WeaveViolationType.METHOD_CALL_ORIGINAL_ALLOWED_ONLY_ONCE, weaveMethod);
            }
            if (instructionInfo.numCallOriginalInvocations == 1) {
                CallOriginalReplacement replacement = CallOriginalReplacement.replace(this.weave.name, weaveMethod);
                if (!replacement.isSuccess()) {
                    this.addViolation(WeaveViolationType.METHOD_CALL_ORIGINAL_ILLEGAL_RETURN_TYPE, weaveMethod);
                } else {
                    this.originalReplacements.put(methodKey, replacement);
                }
            }
        }
        if (weaveMethod.name.equals("<init>") && this.isInterfaceMatch && weaveMethod.name.equals("<init>") && !weaveMethod.desc.equals("()V")) {
            this.addViolation(WeaveViolationType.INIT_WITH_ARGS_INTERFACE_MATCH_UNSUPPORTED, weaveMethod);
        }
    }

    public Map<String, AnnotationNode> getClassAnnotationMap() {
        return this.classAnnotationMap;
    }

    public Map<MethodNode, MethodNode> getWeaveAllMatches() {
        return this.weaveAllMatchedMethods;
    }

    public Set<MethodNode> getClassAnnotationGetters() {
        return this.classAnnotationGetters;
    }

    public Map<MethodKey, Map<String, AnnotationNode>> getMethodAnnotationMap() {
        return this.methodsToAnnotations;
    }

    public void validateNewInnerClass(ClassNode newInnerClassNode) {
        NewInnerClassInfoCollector collector = new NewInnerClassInfoCollector();
        newInnerClassNode.accept(collector);
        if (collector.callsSyntheticAccessor) {
            this.violations.add(new WeaveViolation(WeaveViolationType.CLASS_NESTED_IMPLICIT_OUTER_ACCESS_UNSUPPORTED, newInnerClassNode.name));
        }
    }

    private void processInitFieldAssignment(MethodNode init) {
        CallOriginalInitState state = CallOriginalInitState.INIT;
        int size = init.instructions.size();
        ArrayList<AbstractInsnNode> toRemove = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            AbstractInsnNode beforeInvokeStaticInsn;
            AbstractInsnNode insn = init.instructions.get(i);
            if ((state = this.nextState(state, insn, 181)) == null) {
                this.addViolation(WeaveViolationType.INIT_ILLEGAL_CALL_ORIGINAL, init);
                return;
            }
            if (state == CallOriginalInitState.INIT) {
                boolean isFinal;
                if (insn.getType() != 4 || insn.getOpcode() != 179 && insn.getOpcode() != 181) continue;
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                if (!fieldInsn.owner.equals(this.weave.name) || this.newFields.contains(fieldInsn.name)) continue;
                FieldNode fieldNode = WeaveUtils.findRequiredMatch(this.weave.fields, fieldInsn.name);
                boolean bl = isFinal = (fieldNode.access & 0x10) == 16;
                if (!isFinal) continue;
                this.addViolation(WeaveViolationType.FIELD_FINAL_ASSIGNMENT, fieldNode);
                return;
            }
            if (state == CallOriginalInitState.INVOKESTATIC && (beforeInvokeStaticInsn = init.instructions.get(i - 1)).getOpcode() == 25 && ((VarInsnNode)beforeInvokeStaticInsn).var == 0) {
                toRemove.add(beforeInvokeStaticInsn);
            }
            toRemove.add(insn);
        }
        for (AbstractInsnNode node : toRemove) {
            init.instructions.remove(node);
        }
    }

    private MethodNode validateClassInit(MethodNode weaveClassInit) {
        weaveClassInit = MethodProcessors.removeJSRInstructions(weaveClassInit);
        MethodNode extensionClinit = WeaveUtils.newMethodNode(weaveClassInit);
        CallOriginalInitState state = CallOriginalInitState.INIT;
        int size = weaveClassInit.instructions.size();
        int numViolationsBeforeClinitValidation = this.violations.size();
        for (int i = 0; i < size; ++i) {
            AbstractInsnNode insn = weaveClassInit.instructions.get(i);
            if ((state = this.nextState(state, insn, 179)) == null) {
                this.addViolation(WeaveViolationType.INIT_ILLEGAL_CALL_ORIGINAL, weaveClassInit);
                break;
            }
            if (state != CallOriginalInitState.INIT) continue;
            if (insn.getType() == 4) {
                boolean matchedField;
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                boolean bl = matchedField = !this.newFields.contains(fieldInsn.name);
                if (insn.getOpcode() == 179 && matchedField) {
                    this.addViolation(WeaveViolationType.CLINIT_MATCHED_FIELD_MODIFICATION_UNSUPPORTED, weaveClassInit);
                }
                if (fieldInsn.owner.equals(this.weave.name) && matchedField) {
                    FieldNode fieldNode = WeaveUtils.findRequiredMatch(this.weave.fields, fieldInsn.name);
                    if ((fieldNode.access & 1) == 0) {
                        this.addViolation(WeaveViolationType.CLINIT_FIELD_ACCESS_VIOLATION, fieldNode);
                    }
                }
            } else if (insn.getType() == 5) {
                MethodNode match;
                MethodInsnNode methodInsn = (MethodInsnNode)insn;
                Method methodKey = new Method(methodInsn.name, methodInsn.desc);
                if (methodInsn.owner.equals(this.weave.name) && !this.newMethods.contains(methodKey) && (match = WeaveUtils.findMatch(this.weave.methods, methodKey)) != null && (match.access & 1) == 0) {
                    this.addViolation(WeaveViolationType.CLINIT_METHOD_ACCESS_VIOLATION, methodKey);
                }
            }
            insn.accept(extensionClinit);
        }
        return this.violations.size() > numViolationsBeforeClinitValidation ? null : extensionClinit;
    }

    private CallOriginalInitState nextState(CallOriginalInitState state, AbstractInsnNode insn, int putOpcode) {
        switch (state) {
            case INIT: {
                if (insn.getType() == 5 && insn.getOpcode() == 184) {
                    MethodInsnNode methodInsn = (MethodInsnNode)insn;
                    if (WeaveUtils.isOriginalMethodInvocation(methodInsn.owner, methodInsn.name, methodInsn.desc)) {
                        return CallOriginalInitState.INVOKESTATIC;
                    }
                }
                return state;
            }
            case INVOKESTATIC: {
                if (insn.getOpcode() == 192) {
                    return CallOriginalInitState.CHECKCAST;
                }
                if (insn.getOpcode() != putOpcode) break;
                return this.checkPut(insn);
            }
            case CHECKCAST: {
                if (insn.getOpcode() == 182) {
                    return CallOriginalInitState.INVOKEVIRTUAL;
                }
                if (insn.getOpcode() != putOpcode) break;
                return this.checkPut(insn);
            }
            case INVOKEVIRTUAL: {
                if (insn.getOpcode() != putOpcode) break;
                return this.checkPut(insn);
            }
            case PUT: {
                return CallOriginalInitState.INIT;
            }
        }
        if (insn.getType() == 8 || insn.getType() == 15) {
            return state;
        }
        return null;
    }

    private CallOriginalInitState checkPut(AbstractInsnNode insn) {
        FieldInsnNode fieldInsn = (FieldInsnNode)insn;
        if (fieldInsn.owner.equals(this.weave.name) && this.matchedFields.contains(fieldInsn.name)) {
            return CallOriginalInitState.PUT;
        }
        return null;
    }

    public ClassNode getOriginal() {
        return this.original;
    }

    public ClassNode getWeave() {
        return this.weave;
    }

    public Collection<WeaveViolation> getViolations() {
        return this.violations;
    }

    public Set<String> getNewFields() {
        return this.newFields;
    }

    public Set<String> getMatchedFields() {
        return this.matchedFields;
    }

    public Set<Method> getNewMethods() {
        return this.newMethods;
    }

    public Set<Method> getMatchedMethods() {
        return this.matchedMethods;
    }

    Map<Method, GeneratedNewFieldMethod> getGeneratedNewFieldMethods() {
        return this.generatedNewFieldMethods;
    }

    public Set<String> getNewInnerClasses() {
        return this.newInnerClasses;
    }

    public Set<String> getMatchedInnerClasses() {
        return this.matchedInnerClasses;
    }

    public boolean isInterfaceMatch() {
        return this.isInterfaceMatch;
    }

    public boolean weavesAllConstructors() {
        return this.weavesAllConstructors;
    }

    public boolean weavesAllMethods() {
        return this.weavesAllMethod != null && !this.isInterfaceMatch();
    }

    public MethodNode getWeavesAllMethod() {
        return this.weavesAllMethod;
    }

    public boolean isBaseMatch() {
        return this.isBaseMatch;
    }

    public boolean isFatalWeaveViolation() {
        return this.fatalWeaveViolation;
    }

    Map<Method, CallOriginalReplacement> getOriginalReplacements() {
        return this.originalReplacements;
    }

    MethodNode getExtensionClassInit() {
        return this.extensionClassInit;
    }

    private void addViolation(WeaveViolationType type) {
        this.violations.add(new WeaveViolation(type, this.weave.name));
    }

    private void addViolation(WeaveViolationType type, FieldNode field) {
        this.violations.add(new WeaveViolation(type, this.weave.name, field.name));
    }

    private void addViolation(WeaveViolationType type, MethodNode methodNode) {
        this.addViolation(type, new Method(methodNode.name, methodNode.desc));
    }

    private void addViolation(WeaveViolationType type, Method method) {
        this.violations.add(new WeaveViolation(type, this.weave.name, method));
    }

    private static enum CallOriginalInitState {
        INIT,
        INVOKESTATIC,
        CHECKCAST,
        INVOKEVIRTUAL,
        PUT;

    }

    private class NewInnerClassInfoCollector
    extends ClassVisitor {
        private boolean callsSyntheticAccessor;

        NewInnerClassInfoCollector() {
            super(393216);
            this.callsSyntheticAccessor = false;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MethodVisitor(393216){

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                    if (WeaveUtils.isSyntheticAccessor(name) && !ClassMatch.this.generatedNewFieldMethods.containsKey(new Method(name, desc))) {
                        NewInnerClassInfoCollector.this.callsSyntheticAccessor = true;
                    }
                }
            };
        }
    }

    private class WeaveMethodInstructionScanner
    extends MethodVisitor {
        public int numCallOriginalInvocations;
        public boolean callsNewMethod;
        public boolean callsSyntheticAccessor;
        public boolean isClassAnnotationGetter;
        public boolean isMethodAnnotationGetter;

        public WeaveMethodInstructionScanner() {
            super(393216);
            this.numCallOriginalInvocations = 0;
            this.callsNewMethod = false;
            this.callsSyntheticAccessor = false;
            this.isClassAnnotationGetter = false;
            this.isMethodAnnotationGetter = false;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (WeaveUtils.isOriginalMethodInvocation(owner, name, desc)) {
                ++this.numCallOriginalInvocations;
            }
            if (WeaveUtils.isClassAnnotationGetter(owner, name, desc)) {
                this.isClassAnnotationGetter = true;
            }
            if (WeaveUtils.isMethodAnnotationGetter(owner, name, desc)) {
                this.isMethodAnnotationGetter = true;
            }
            Method method = new Method(name, desc);
            if (owner.equals(((ClassMatch)ClassMatch.this).weave.name) && ClassMatch.this.newMethods.contains(method)) {
                this.callsNewMethod = true;
            }
            if (WeaveUtils.isSyntheticAccessor(name) && !ClassMatch.this.generatedNewFieldMethods.containsKey(method)) {
                this.callsSyntheticAccessor = true;
            }
        }
    }
}

