/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.weavepackage;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.LocalVariableNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MultiANewArrayInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.TypeInsnNode;
import com.newrelic.weave.utils.ClassCache;
import com.newrelic.weave.utils.ClassInformation;
import com.newrelic.weave.utils.SynchronizedFieldNode;
import com.newrelic.weave.utils.SynchronizedMethodNode;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.violation.ReferenceViolation;
import com.newrelic.weave.violation.WeaveViolation;
import com.newrelic.weave.violation.WeaveViolationType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Reference {
    public final String referenceOrigin;
    private int[] requiredAccess;
    private int[] illegalAccess;
    public final String className;
    private final Map<Method, MemberReference> methods = Maps.newHashMap();
    private final Map<String, MemberReference> fields = Maps.newHashMap();

    public Map<Method, MemberReference> getMethods() {
        return this.methods;
    }

    public static Set<Reference> create(ClassNode classNode) {
        HashSet<Reference> references = Sets.newHashSet();
        String referenceSource = classNode.name;
        if (null != classNode.superName) {
            references.add(Reference.createFromSupertype(referenceSource, classNode.superName));
        }
        if (null != classNode.interfaces) {
            for (String interfaceName : classNode.interfaces) {
                references.add(Reference.createFromInterface(referenceSource, interfaceName));
            }
        }
        if (null != classNode.fields) {
            for (FieldNode fieldNode : classNode.fields) {
                references.addAll(Reference.createFromField(referenceSource, classNode.name, fieldNode));
            }
        }
        if (null != classNode.methods) {
            for (MethodNode methodNode : classNode.methods) {
                references.addAll(Reference.createFromMethod(referenceSource, classNode.name, methodNode));
            }
        }
        return references;
    }

    private static Reference createFromSupertype(String referenceOrigin, String superName) {
        int[] classIllegalAccess = new int[]{512, 16};
        return new Reference(referenceOrigin, superName, new int[0], classIllegalAccess);
    }

    private static Reference createFromInterface(String referenceOrigin, String interfaceName) {
        int[] classRequiredAccess = new int[]{512};
        return new Reference(referenceOrigin, interfaceName, classRequiredAccess, new int[0]);
    }

    private static Set<Reference> createFromField(String referenceOrigin, String fieldNodeClassOwner, FieldNode fieldNode) {
        HashSet<Reference> references = Sets.newHashSet();
        Type fieldType = Reference.getReferencedType(fieldNode.desc);
        if (fieldType.getSort() == 10 && !Type.getType(fieldNode.desc).getInternalName().equals(fieldNodeClassOwner)) {
            references.add(new Reference(referenceOrigin, Reference.getReferencedType(fieldNode.desc).getInternalName(), new int[0], new int[0]));
        }
        return references;
    }

    private static Set<Reference> createFromMethod(String referenceOrigin, String methodNodeClassOwner, MethodNode methodNode) {
        HashSet<Reference> references = Sets.newHashSet();
        Type returnType = Reference.getReferencedType(Type.getReturnType(methodNode.desc).getDescriptor());
        if (returnType.getSort() == 10) {
            references.add(new Reference(referenceOrigin, returnType.getInternalName(), new int[0], new int[0]));
        }
        if (null != methodNode.localVariables) {
            for (LocalVariableNode local : methodNode.localVariables) {
                Type localType;
                if (local.name.equals("this") || (localType = Reference.getReferencedType(local.desc)).getSort() != 10) continue;
                references.add(new Reference(referenceOrigin, localType.getInternalName(), new int[0], new int[0]));
            }
        }
        if ((0x400 & methodNode.access) == 0) {
            AbstractInsnNode current = methodNode.instructions.getFirst();
            while (current != null) {
                Type ownerType;
                if (current.getType() == 5) {
                    MethodInsnNode methodInsn = (MethodInsnNode)current;
                    ownerType = Reference.getReferencedType(Type.getObjectType(methodInsn.owner).getDescriptor());
                    if (Reference.isPrimitiveType(ownerType)) {
                        current = current.getNext();
                        continue;
                    }
                    if (!ownerType.getInternalName().equals(methodNodeClassOwner)) {
                        int[] classIllegalAccess;
                        int[] classRequiredAccess;
                        if (methodInsn.itf) {
                            classRequiredAccess = new int[]{512};
                            classIllegalAccess = new int[]{};
                        } else {
                            classRequiredAccess = new int[]{};
                            classIllegalAccess = new int[]{512};
                        }
                        Reference reference = new Reference(referenceOrigin, ownerType.getInternalName(), classRequiredAccess, classIllegalAccess);
                        int[] methodIllegalAccess = new int[]{2};
                        int[] methodRequiredAccess = methodInsn.getOpcode() == 184 ? new int[]{8} : new int[]{};
                        reference.addOrMergeMethodReference(methodInsn.name, methodInsn.desc, methodRequiredAccess, methodIllegalAccess);
                        references.add(reference);
                    }
                } else if (current.getType() == 4) {
                    FieldInsnNode fieldInsn = (FieldInsnNode)current;
                    ownerType = Reference.getReferencedType(Type.getObjectType(fieldInsn.owner).getDescriptor());
                    if (Reference.isPrimitiveType(ownerType)) {
                        current = current.getNext();
                        continue;
                    }
                    if (!ownerType.getInternalName().equals(methodNodeClassOwner)) {
                        Reference reference = new Reference(referenceOrigin, ownerType.getInternalName(), new int[0], new int[0]);
                        int[] fieldIllegalAccess = new int[]{2};
                        int[] fieldRequiredAccess = fieldInsn.getOpcode() == 184 ? new int[]{8} : new int[]{};
                        reference.addOrMergeFieldReference(fieldInsn.name, fieldInsn.desc, fieldRequiredAccess, fieldIllegalAccess);
                        references.add(reference);
                    }
                } else if (current.getType() == 3) {
                    TypeInsnNode typeInsn = (TypeInsnNode)current;
                    Type castType = Reference.getReferencedType(Type.getObjectType(typeInsn.desc).getDescriptor());
                    if (castType.getSort() == 10) {
                        references.add(new Reference(referenceOrigin, castType.getInternalName(), new int[0], new int[0]));
                    }
                } else if (current.getType() == 13) {
                    MultiANewArrayInsnNode arrayNode = (MultiANewArrayInsnNode)current;
                    Type arrayType = Reference.getReferencedType(arrayNode.desc);
                    if (arrayType.getSort() == 10) {
                        references.add(new Reference(referenceOrigin, arrayType.getInternalName(), new int[0], new int[0]));
                    }
                }
                current = current.getNext();
            }
        }
        return references;
    }

    private static Type getReferencedType(String desc) {
        Type type = Type.getType(desc);
        if (type.getSort() == 9) {
            type = type.getElementType();
        }
        return type;
    }

    private static boolean isPrimitiveType(Type type) {
        return type.getSort() < 9;
    }

    public Reference(String referenceOrigin, String className, int[] requiredAccess, int[] illegalAccess) {
        this.referenceOrigin = referenceOrigin;
        this.className = className;
        this.requiredAccess = requiredAccess;
        this.illegalAccess = illegalAccess;
    }

    private boolean addOrMergeMethodReference(String name, String desc, int[] requiredAccess, int[] illegalAccess) {
        Method method = new Method(name, desc);
        if (this.methods.containsKey(method)) {
            return this.methods.get(method).merge(new MemberReference(name, desc, requiredAccess, illegalAccess));
        }
        this.methods.put(method, new MemberReference(name, desc, requiredAccess, illegalAccess));
        return true;
    }

    private boolean addOrMergeFieldReference(String name, String desc, int[] requiredAccess, int[] illegalAccess) {
        if (this.fields.containsKey(name)) {
            return this.fields.get(name).merge(new MemberReference(name, desc, requiredAccess, illegalAccess));
        }
        this.fields.put(name, new MemberReference(name, desc, requiredAccess, illegalAccess));
        return true;
    }

    public boolean merge(Reference otherReference) {
        boolean merged = this.className.equals(otherReference.className);
        this.requiredAccess = Reference.mergeFlags(this.requiredAccess, otherReference.requiredAccess);
        this.illegalAccess = Reference.mergeFlags(this.illegalAccess, otherReference.illegalAccess);
        if (Reference.accessFlagsOverlap(this.requiredAccess, this.illegalAccess)) {
            merged = false;
        }
        for (MemberReference otherField : otherReference.fields.values()) {
            if (this.fields.containsKey(otherField.name)) {
                merged = merged && this.fields.get(otherField.name).merge(otherField);
                continue;
            }
            this.fields.put(otherField.name, otherField);
        }
        for (MemberReference otherMethodReference : otherReference.methods.values()) {
            Method otherMethod = new Method(otherMethodReference.name, otherMethodReference.desc);
            if (this.methods.containsKey(otherMethod)) {
                merged = merged && this.methods.get(otherMethod).merge(otherMethodReference);
                continue;
            }
            this.methods.put(otherMethod, otherMethodReference);
        }
        return merged;
    }

    List<WeaveViolation> validateClassNode(ClassCache classCache, ClassNode classNode) throws IOException {
        ArrayList<WeaveViolation> violations = Lists.newArrayList();
        if (!this.className.equals(classNode.name)) {
            violations.add(new ReferenceViolation(WeaveViolationType.INVALID_REFERENCE, this.referenceOrigin, classNode.name, "class name mismatch"));
        }
        if (this.requiredAccess.length > 0) {
            int total = 0;
            for (int requiredAcces : this.requiredAccess) {
                total += requiredAcces;
            }
            if (!WeaveUtils.flagsMatch(total, classNode.access, this.requiredAccess)) {
                violations.add(new ReferenceViolation(WeaveViolationType.INVALID_REFERENCE, this.referenceOrigin, classNode.name, "required class access mismatch. weave expects: " + WeaveUtils.humanReadableAccessFlags(total) + " original has: " + WeaveUtils.humanReadableAccessFlags(classNode.access)));
            }
        }
        if (this.illegalAccess.length > 0 && !WeaveUtils.flagsMatch(0, classNode.access, this.illegalAccess)) {
            violations.add(new ReferenceViolation(WeaveViolationType.INVALID_REFERENCE, this.referenceOrigin, classNode.name, "illegal class access mismatch. Original has: " + WeaveUtils.humanReadableAccessFlags(classNode.access)));
        }
        ArrayList<MethodNode> originalMethods = Lists.newArrayList();
        ArrayList<FieldNode> originalFields = Lists.newArrayList();
        Reference.addMethodsAndFields(classCache, classNode, originalMethods, originalFields);
        violations.addAll(this.validateFieldsAndMethods(classNode.name, originalMethods, originalFields));
        return violations;
    }

    private List<WeaveViolation> validateFieldsAndMethods(String originalName, List<MethodNode> originalMethods, List<FieldNode> originalFields) {
        ArrayList<WeaveViolation> violations = Lists.newArrayList();
        for (MemberReference method : this.methods.values()) {
            MethodNode methodNode = WeaveUtils.findMatch(originalMethods, method.name, method.desc);
            if (null == methodNode) {
                violations.add(new ReferenceViolation(WeaveViolationType.INVALID_REFERENCE, this.referenceOrigin, originalName, "missing method. weave code expects method: " + method.name + method.desc));
                continue;
            }
            if (method.matches(methodNode.name, methodNode.desc, methodNode.access)) continue;
            violations.add(new ReferenceViolation(WeaveViolationType.INVALID_REFERENCE, this.referenceOrigin, originalName, "weave and origin method method mismatch. weave code expects method: " + method.name + method.desc + WeaveUtils.humanReadableAccessFlags(method.requiredAccess) + "original has " + methodNode.name + methodNode.desc + WeaveUtils.humanReadableAccessFlags(methodNode.access)));
        }
        for (MemberReference field : this.fields.values()) {
            FieldNode fieldNode = WeaveUtils.findMatch(originalFields, field.name);
            if (null == fieldNode) {
                violations.add(new ReferenceViolation(WeaveViolationType.INVALID_REFERENCE, this.referenceOrigin, originalName, "missing field. weave code expects field: " + field.name + field.desc + WeaveUtils.humanReadableAccessFlags(field.requiredAccess)));
                continue;
            }
            if (field.matches(fieldNode.name, fieldNode.desc, fieldNode.access)) continue;
            violations.add(new ReferenceViolation(WeaveViolationType.INVALID_REFERENCE, this.referenceOrigin, originalName, "missing field. weave code expects field: " + field.name + field.desc + WeaveUtils.humanReadableAccessFlags(field.requiredAccess) + " original has: " + fieldNode.name + fieldNode.desc + WeaveUtils.humanReadableAccessFlags(fieldNode.access)));
        }
        return violations;
    }

    private static int[] mergeFlags(int[] access1, int[] access2) {
        ArrayList<Integer> merged = new ArrayList<Integer>(access1.length + access2.length);
        for (int anAccess1 : access1) {
            merged.add(anAccess1);
        }
        for (int anAccess2 : access2) {
            if (merged.contains(anAccess2)) continue;
            merged.add(anAccess2);
        }
        int[] mergedArray = new int[merged.size()];
        for (int i = 0; i < mergedArray.length; ++i) {
            mergedArray[i] = (Integer)merged.get(i);
        }
        return mergedArray;
    }

    private static boolean accessFlagsOverlap(int[] access1, int[] access2) {
        int total1 = 0;
        for (int anAccess1 : access1) {
            total1 += anAccess1;
        }
        int total2 = 0;
        for (int anAccess2 : access2) {
            total2 += anAccess2;
        }
        return (total1 & total2) != 0;
    }

    private static void addMethodsAndFields(ClassCache classCache, ClassNode classNode, List<MethodNode> methods, List<FieldNode> fields) throws IOException {
        ClassInformation classInfo = classCache.getClassInformation(classNode.name);
        for (ClassInformation.MemberInformation methodInfo : classInfo.getAllMethods(classCache)) {
            SynchronizedMethodNode methodNode = new SynchronizedMethodNode();
            methodNode.name = methodInfo.name;
            methodNode.desc = methodInfo.desc;
            methodNode.access = methodInfo.access;
            methods.add(methodNode);
        }
        for (ClassInformation.MemberInformation fieldInfo : classInfo.getAllFields(classCache)) {
            fields.add(new SynchronizedFieldNode(393216, fieldInfo.access, fieldInfo.name, fieldInfo.desc, null, null));
        }
    }

    private class MemberReference {
        public final String name;
        public final String desc;
        int[] requiredAccess;
        int[] illegalAccess;

        private MemberReference(String name, String desc, int[] requiredAccess, int[] illegalAccess) {
            this.name = name;
            this.desc = desc;
            this.requiredAccess = requiredAccess;
            this.illegalAccess = illegalAccess;
        }

        public boolean merge(MemberReference otherMember) {
            boolean merged = this.name.equals(otherMember.name);
            this.requiredAccess = Reference.mergeFlags(this.requiredAccess, otherMember.requiredAccess);
            this.illegalAccess = Reference.mergeFlags(this.illegalAccess, otherMember.illegalAccess);
            if (Reference.accessFlagsOverlap(this.requiredAccess, this.illegalAccess)) {
                merged = false;
            }
            merged = merged && this.requiredAccess == otherMember.requiredAccess;
            merged = merged && this.desc.equals(otherMember.desc);
            return merged;
        }

        public boolean matches(String name, String desc, int access) {
            boolean match;
            boolean bl = match = this.name.equals(name) && this.desc.equals(desc);
            if (this.requiredAccess.length > 0) {
                int total = 0;
                for (int requiredAcces : this.requiredAccess) {
                    total += requiredAcces;
                }
                boolean bl2 = match = match && WeaveUtils.flagsMatch(total, access, this.requiredAccess);
            }
            if (this.illegalAccess.length > 0) {
                match = match && WeaveUtils.flagsMatch(0, access, this.illegalAccess);
            }
            return match;
        }
    }
}

