package com.newrelic.api.agent;

/**
 * Payload used to connect two services in a distributed system.
 *
 * Use {@link com.newrelic.api.agent.Transaction#createDistributedTracePayload() createDistributedTracePayload()}
 * to create a payload, and {@link com.newrelic.api.agent.Transaction#acceptDistributedTracePayload(DistributedTracePayload)} acceptDistributedTracePayload()} to accept the payload on the second service.
 *
 */
public interface DistributedTracePayload {

    /**
     * Get the distributed trace payload in JSON String format
     *
     * @return a JSON String representation of the payload
     */
    String text();

    /**
     * Get the distributed trace payload in base64 encoded JSON String format
     *
     * @return a base64 encoded JSON String representation of the payload
     */
    String httpSafe();

}
