/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.CrossProcessTransactionState;
import com.newrelic.agent.HeadersUtil;
import com.newrelic.agent.LazyMapImpl;
import com.newrelic.agent.MetricNames;
import com.newrelic.agent.OutboundHeadersMap;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.DistributedTracingConfig;
import com.newrelic.agent.deps.com.google.common.collect.MapMaker;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONValue;
import com.newrelic.agent.dispatchers.Dispatcher;
import com.newrelic.agent.service.ServiceUtils;
import com.newrelic.agent.tracers.CrossProcessNameFormat;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.util.Obfuscator;
import com.newrelic.api.agent.DistributedTracePayload;
import com.newrelic.api.agent.ExtendedResponse;
import com.newrelic.api.agent.HeaderType;
import com.newrelic.api.agent.InboundHeaders;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.api.agent.OutboundHeaders;
import com.newrelic.api.agent.Response;
import com.newrelic.api.agent.tracing.SpanProxy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class CrossProcessTransactionStateImpl
implements CrossProcessTransactionState {
    private static final boolean OPTIMISTIC_TRACING = false;
    private static final int ALTERNATE_PATH_HASH_MAX_COUNT = 10;
    private static final String UNKNOWN_HOST = "Unknown";
    private static final Set<String> UNOBFUSCATED_HEADERS = Sets.newHashSet("newrelic", "newrelic");
    private final Transaction tx;
    private final Object lock;
    private volatile String tripId;
    private volatile boolean isCatOriginator = false;
    private final Set<String> alternatePathHashes;
    private volatile boolean processOutboundResponseDone = false;

    private CrossProcessTransactionStateImpl(Transaction tx) {
        this.tx = tx;
        this.lock = tx.getLock();
        MapMaker factory = new MapMaker().initialCapacity(8).concurrencyLevel(4);
        this.alternatePathHashes = Sets.newSetFromMap(new LazyMapImpl(factory));
    }

    @Override
    public void writeResponseHeaders() {
        if (this.tx.isIgnore()) {
            return;
        }
        Dispatcher dispatcher = this.tx.getDispatcher();
        if (dispatcher == null) {
            return;
        }
        try {
            Response response = dispatcher.getResponse();
            long contentLength = -1L;
            contentLength = response instanceof ExtendedResponse ? ((ExtendedResponse)response).getContentLength() : this.tx.getInboundHeaderState().getRequestContentLength();
            this.processOutboundResponseHeaders((OutboundHeaders)response, contentLength);
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINEST, e, "Error attempting to write response headers in transaction: {0}", this.tx);
        }
    }

    public void processOutboundResponseHeaders(OutboundHeaders outboundHeaders, long contentLength) {
        if (outboundHeaders != null) {
            this.tx.getTransactionActivity().markAsResponseSender();
            OutboundHeadersMap metadata = new OutboundHeadersMap(outboundHeaders.getHeaderType());
            boolean populated = this.populateResponseMetadata(metadata, contentLength);
            if (populated && this.obfuscateMetadata(metadata)) {
                for (Map.Entry entry : metadata.entrySet()) {
                    outboundHeaders.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }

    private boolean obfuscateMetadata(Map<String, String> metadata) {
        if (metadata == null || metadata.isEmpty()) {
            return false;
        }
        String encodingKey = this.tx.getCrossProcessConfig().getEncodingKey();
        if (encodingKey == null) {
            Agent.LOG.log(Level.FINER, "Metadata obfuscation failed. Encoding key is null");
            return false;
        }
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            try {
                if (UNOBFUSCATED_HEADERS.contains(entry.getKey())) continue;
                String obfuscatedValue = Obfuscator.obfuscateNameUsingKey(entry.getValue(), encodingKey);
                entry.setValue(obfuscatedValue);
            }
            catch (UnsupportedEncodingException e) {
                Agent.LOG.log(Level.FINEST, "Metadata obfuscation failed. {0}", e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean populateResponseMetadata(OutboundHeaders headers, long contentLength) {
        if (this.tx.getAgentConfig().getDistributedTracingConfig().isEnabled()) {
            Agent.LOG.log(Level.FINEST, "Distributed tracing enabled. Not adding response metadata");
            return false;
        }
        if (this.tx.getCrossProcessConfig().isCrossApplicationTracing()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.processOutboundResponseDone) {
                    return false;
                }
                if (this.tx.isIgnore()) {
                    Agent.LOG.log(Level.FINEST, "Not adding response headers in transaction {0}. Transaction is ignored", this.tx);
                    return false;
                }
                if (!this.tx.getInboundHeaderState().isTrustedCatRequest()) {
                    Agent.LOG.log(Level.FINEST, "Not adding response headers in transaction {0}. Not a trusted CAT request", this.tx);
                    return false;
                }
                this.tx.freezeTransactionName();
                long durationInNanos = this.tx.getRunningDurationInNanos();
                this.recordClientApplicationMetric(durationInNanos);
                this.writeCrossProcessAppDataResponseHeader(headers, durationInNanos, contentLength);
                this.processOutboundResponseDone = true;
            }
            return true;
        }
        Agent.LOG.log(Level.FINEST, "Not adding response headers in transaction {0}. Neither distributed tracing nor CAT are enabled", this.tx);
        return false;
    }

    public void processOutboundRequestHeaders(OutboundHeaders outboundHeaders) {
        com.newrelic.api.agent.TracedMethod lastTracer = NewRelic.getAgent().getTracedMethod();
        this.processOutboundRequestHeaders(outboundHeaders, lastTracer);
    }

    public void processOutboundRequestHeaders(OutboundHeaders outboundHeaders, com.newrelic.api.agent.TracedMethod tracedMethod) {
        block4: {
            if (outboundHeaders == null) break block4;
            OutboundHeadersMap metadata = new OutboundHeadersMap(outboundHeaders.getHeaderType());
            this.populateRequestMetadata(metadata, tracedMethod);
            if (this.obfuscateMetadata(metadata)) {
                for (Map.Entry entry : metadata.entrySet()) {
                    outboundHeaders.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
            } else {
                for (Map.Entry entry : metadata.entrySet()) {
                    if (!UNOBFUSCATED_HEADERS.contains(entry.getKey())) continue;
                    outboundHeaders.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateRequestMetadata(OutboundHeaders headers, com.newrelic.api.agent.TracedMethod tracedMethod) {
        String synHeader;
        if (this.tx.getInboundHeaderState().isTrustedSyntheticsRequest() && this.tx.isInProgress() && !this.tx.isIgnore() && (synHeader = this.tx.getInboundHeaderState().getUnparsedSyntheticsHeader()) != null) {
            HeadersUtil.setSyntheticsHeader(headers, synHeader);
        }
        if (this.tx.getAgentConfig().getDistributedTracingConfig().isEnabled()) {
            String spanGuid;
            if (tracedMethod instanceof DefaultTracer && this.tx.getAgentConfig().getSpanEventsConfig().isEnabled() && this.tx.sampled()) {
                DefaultTracer dt = (DefaultTracer)tracedMethod;
                spanGuid = dt.getGuid();
            } else {
                spanGuid = null;
            }
            SpanProxy spanProxy = this.tx.getSpanProxy();
            String traceId = spanProxy != null && spanProxy.getInboundDistributedTracePayload() != null ? spanProxy.getInboundDistributedTracePayload().traceId : this.tx.getGuid();
            DistributedTracePayload payload = this.tx.createDistributedTracePayload(traceId, spanGuid);
            if (payload != null) {
                Agent.LOG.log(Level.FINER, "Sending distributed trace header in transaction {0}", this.tx);
                this.isCatOriginator = true;
                HeadersUtil.setTraceHeader(headers, payload.httpSafe());
            }
        } else if (this.tx.getCrossProcessConfig().isCrossApplicationTracing()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.tx.getDispatcher() == null) {
                    Agent.LOG.log(Level.FINEST, "Dispatcher not set. Not setting CAT request headers in transaction {0}", this.tx);
                }
                if (this.tx.isIgnore()) {
                    Agent.LOG.log(Level.FINEST, "Transaction ignored. Not setting CAT request headers in transaction {0}", this.tx);
                    return;
                }
                String crossProcessId = this.tx.getCrossProcessConfig().getEncodedCrossProcessId();
                if (crossProcessId != null) {
                    Agent.LOG.log(Level.FINER, "Sending ID header: {0} in transaction {1}", crossProcessId, this.tx);
                    this.isCatOriginator = true;
                    HeadersUtil.setIdHeader(headers, this.tx.getCrossProcessConfig().getCrossProcessId());
                    String transactionHeaderValue = this.getTransactionHeaderValue();
                    HeadersUtil.setTransactionHeader(headers, transactionHeaderValue);
                } else {
                    Agent.LOG.log(Level.FINEST, "Encoded cross process id is null. Not setting CAT request headers in transaction {0}", this.tx);
                }
            }
        }
    }

    private void doProcessInboundResponseHeaders(TracedMethod tracer, CrossProcessNameFormat crossProcessFormat, String host, boolean addRollupMetrics) {
        if (crossProcessFormat != null) {
            if (tracer instanceof DefaultTracer) {
                DefaultTracer dt = (DefaultTracer)tracer;
                String transactionId = crossProcessFormat.getTransactionId();
                if (transactionId != null && transactionId.length() > 0) {
                    dt.setAttribute("transaction_guid", transactionId);
                }
                dt.setMetricNameFormat(crossProcessFormat);
                if (Agent.LOG.isFinestEnabled()) {
                    Agent.LOG.log(Level.FINEST, "Received APP_DATA cross process response header for external call: {0} in transaction {1}", crossProcessFormat.toString(), this.tx);
                }
            }
            if (addRollupMetrics && !UNKNOWN_HOST.equals(host)) {
                tracer.addRollupMetricName(new String[]{crossProcessFormat.getHostCrossProcessIdRollupMetricName()});
            }
        }
        if (addRollupMetrics) {
            this.recordExternalMetrics(tracer, host);
        }
    }

    private void recordExternalMetrics(TracedMethod tracer, String host) {
        tracer.addRollupMetricName(new String[]{"External", host, "all"});
        tracer.addRollupMetricName(new String[]{"External/all"});
        if (this.tx != null) {
            if (this.tx.getDispatcher().isWebTransaction()) {
                tracer.addRollupMetricName(new String[]{"External/allWeb"});
            } else {
                tracer.addRollupMetricName(new String[]{"External/allOther"});
            }
        }
    }

    public void processInboundResponseHeaders(InboundHeaders inboundHeaders, TracedMethod tracer, String host, String uri, boolean addRollupMetrics) {
        if (this.tx.getAgentConfig().getDistributedTracingConfig().isEnabled()) {
            if (addRollupMetrics) {
                this.recordExternalMetrics(tracer, host);
            }
        } else if (this.tx.getCrossProcessConfig().isCrossApplicationTracing()) {
            String encodingKey;
            if (inboundHeaders == null || tracer == null) {
                return;
            }
            String encodedAppData = HeadersUtil.getAppDataHeader(inboundHeaders);
            CrossProcessNameFormat crossProcessFormat = CrossProcessNameFormat.create(host, uri, encodedAppData, encodingKey = this.tx.getCrossProcessConfig().getEncodingKey());
            if (crossProcessFormat == null) {
                Agent.LOG.log(Level.FINER, "Unable to decode Application Data in transaction {0}", this.tx);
            }
            this.doProcessInboundResponseHeaders(tracer, crossProcessFormat, host, addRollupMetrics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized String getTransactionHeaderValue() {
        Object object = this.lock;
        synchronized (object) {
            String json = this.getTransactionHeaderJson(this.tx.getGuid(), this.getForceTransactionTrace(), this.getTripId(), this.generatePathHash());
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.log(Level.FINER, "Sending TRANSACTION header: {0}", json);
            }
            return json;
        }
    }

    private String getTransactionHeaderJson(String guid, boolean forceTransactionTrace, String trip, int pathHash) {
        List<Serializable> args = Arrays.asList(guid, forceTransactionTrace, trip, ServiceUtils.intToHexString(pathHash));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            JSONArray.writeJSONString(args, writer);
            ((Writer)writer).close();
            return out.toString("UTF-8");
        }
        catch (IOException e) {
            Agent.LOG.error(MessageFormat.format("Error getting JSON: {0}", e));
            return null;
        }
    }

    private void writeCrossProcessAppDataResponseHeader(OutboundHeaders headers, long durationInNanos, long contentLength) {
        String json = this.getCrossProcessAppDataJson(durationInNanos, contentLength);
        if (json == null) {
            return;
        }
        Agent.LOG.log(Level.FINEST, "Setting APP_DATA response header in transaction {0} to: {1}", this.tx, json);
        HeadersUtil.setAppDataHeader(headers, json);
    }

    private String getCrossProcessAppDataJson(long durationInNanos, long contentLength) {
        String crossProcessId = this.tx.getCrossProcessConfig().getCrossProcessId();
        String transactionName = this.tx.getPriorityTransactionName().getName();
        Float queueTimeInSeconds = Float.valueOf((float)this.tx.getExternalTime() / 1000.0f);
        Float durationInSeconds = Float.valueOf((float)durationInNanos / 1.0E9f);
        List<Serializable> args = Arrays.asList(crossProcessId, transactionName, queueTimeInSeconds, durationInSeconds, contentLength, this.tx.getGuid(), Boolean.FALSE);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            JSONArray.writeJSONString(args, writer);
            ((Writer)writer).close();
            return out.toString();
        }
        catch (IOException e) {
            Agent.LOG.error(MessageFormat.format("Error getting JSON {0} in transaction {1}", e, this.tx));
            return null;
        }
    }

    private void recordClientApplicationMetric(long durationInNanos) {
        if (this.tx.getInboundHeaderState().isTrustedCatRequest()) {
            String metricName = MessageFormat.format("ClientApplication/{0}/all", this.tx.getInboundHeaderState().getClientCrossProcessId());
            this.tx.getTransactionActivity().getTransactionStats().getUnscopedStats().getResponseTimeStats(metricName).recordResponseTime(durationInNanos, TimeUnit.NANOSECONDS);
            Agent.LOG.log(Level.FINEST, "Recorded ClientApplication metric in transaction {0}", this.tx);
        }
    }

    private boolean getForceTransactionTrace() {
        return false;
    }

    @Override
    public String getTripId() {
        AgentConfig agentConfig = this.tx.getAgentConfig();
        DistributedTracingConfig config = agentConfig.getDistributedTracingConfig();
        if (!config.isEnabled() && !this.tx.getCrossProcessConfig().isCrossApplicationTracing()) {
            return null;
        }
        if (this.tripId == null) {
            this.tripId = this.tx.getInboundHeaderState().getInboundTripId();
        }
        if (this.tripId == null && (this.isCatOriginator || this.tx.getAgentConfig().getDistributedTracingConfig().isEnabled())) {
            this.tripId = this.tx.getGuid();
        }
        return this.tripId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generatePathHash() {
        Object object = this.lock;
        synchronized (object) {
            int pathHash = ServiceUtils.calculatePathHash(this.tx.getApplicationName(), this.tx.getPriorityTransactionName().getName(), this.tx.getInboundHeaderState().getReferringPathHash());
            if (this.alternatePathHashes.size() < 10) {
                this.alternatePathHashes.add(ServiceUtils.intToHexString(pathHash));
            }
            return pathHash;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAlternatePathHashes() {
        if (!this.tx.getCrossProcessConfig().isCrossApplicationTracing()) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            TreeSet<String> hashes = new TreeSet<String>(this.alternatePathHashes);
            hashes.remove(ServiceUtils.intToHexString(this.generatePathHash()));
            StringBuilder result = new StringBuilder();
            for (String alternatePathHash : hashes) {
                result.append(alternatePathHash);
                result.append(",");
            }
            return result.length() > 0 ? result.substring(0, result.length() - 1) : null;
        }
    }

    public static CrossProcessTransactionStateImpl create(Transaction tx) {
        return tx == null ? null : new CrossProcessTransactionStateImpl(tx);
    }

    public String getRequestMetadata() {
        if (this.tx.getAgentConfig().getDistributedTracingConfig().isEnabled()) {
            Agent.LOG.log(Level.FINEST, "Distributed tracing is enabled. Ignoring getRequestMetadata call.");
            return null;
        }
        OutboundHeadersMap metadata = new OutboundHeadersMap(HeaderType.MESSAGE);
        this.populateRequestMetadata(metadata, (com.newrelic.api.agent.TracedMethod)this.tx.getTransactionActivity().getLastTracer());
        if (metadata.isEmpty()) {
            return null;
        }
        String serializedMetadata = JSONValue.toJSONString(metadata);
        String encodingKey = this.tx.getCrossProcessConfig().getEncodingKey();
        try {
            return Obfuscator.obfuscateNameUsingKey(serializedMetadata, encodingKey);
        }
        catch (UnsupportedEncodingException e) {
            Agent.LOG.log(Level.FINEST, "Error encoding metadata {0} using key {1}: {2} in transaction {3}", serializedMetadata, encodingKey, e, this.tx);
            return null;
        }
    }

    public void processRequestMetadata(String requestMetadata) {
        if (this.tx.getAgentConfig().getDistributedTracingConfig().isEnabled()) {
            Agent.LOG.log(Level.FINEST, "Distributed tracing is enabled. Ignoring processRequestMetadata call.");
            return;
        }
        InboundHeaders headers = this.decodeMetadata(requestMetadata);
        Transaction currentTxn = Transaction.getTransaction(false);
        if (currentTxn != null) {
            currentTxn.provideRawHeaders(headers);
        }
        MetricNames.recordApiSupportabilityMetric("ProcessRequestMetadata");
    }

    public String getResponseMetadata() {
        if (this.tx.getAgentConfig().getDistributedTracingConfig().isEnabled()) {
            Agent.LOG.log(Level.FINEST, "Distributed tracing is enabled. Ignoring getResponseMetadata call.");
            return null;
        }
        OutboundHeadersMap metadata = new OutboundHeadersMap(HeaderType.MESSAGE);
        this.populateResponseMetadata(metadata, -1L);
        if (metadata.isEmpty()) {
            return null;
        }
        String serializedMetadata = JSONValue.toJSONString(metadata);
        String encodingKey = this.tx.getCrossProcessConfig().getEncodingKey();
        try {
            return Obfuscator.obfuscateNameUsingKey(serializedMetadata, encodingKey);
        }
        catch (UnsupportedEncodingException e) {
            Agent.LOG.log(Level.SEVERE, "Error encoding metadata {0} using key {1}: {2}", serializedMetadata, encodingKey, e);
            return null;
        }
    }

    public void processResponseMetadata(String responseMetadata, URI uri) {
        if (this.tx.getAgentConfig().getDistributedTracingConfig().isEnabled()) {
            Agent.LOG.log(Level.FINEST, "Distributed tracing is enabled. Ignoring processResponseMetadata call.");
            return;
        }
        if (!this.tx.getCrossProcessConfig().isCrossApplicationTracing()) {
            return;
        }
        if (responseMetadata == null) {
            return;
        }
        Tracer lastTracer = this.tx.getTransactionActivity().getLastTracer();
        if (lastTracer == null) {
            return;
        }
        InboundHeaders NRHeaders = this.decodeMetadata(responseMetadata);
        if (NRHeaders != null) {
            String host = uri == null || uri.getHost() == null ? UNKNOWN_HOST : uri.getHost();
            String uriString = uri == null ? null : uri.toString();
            String decodedAppData = HeadersUtil.getAppDataHeader(NRHeaders);
            CrossProcessNameFormat crossProcessFormat = CrossProcessNameFormat.create(host, uriString, decodedAppData);
            this.doProcessInboundResponseHeaders((TracedMethod)lastTracer, crossProcessFormat, host, true);
            MetricNames.recordApiSupportabilityMetric("ProcessResponseMetadata");
        }
    }

    private InboundHeaders decodeMetadata(String metadata) {
        String deobfuscatedMetadata;
        try {
            String encodingKey = this.tx.getCrossProcessConfig().getEncodingKey();
            if (encodingKey == null) {
                return null;
            }
            deobfuscatedMetadata = Obfuscator.deobfuscateNameUsingKey(metadata, encodingKey);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        Object obj = JSONValue.parse(deobfuscatedMetadata);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Map)) {
            return null;
        }
        final Map delegate = (Map)obj;
        return new InboundHeaders(){

            public HeaderType getHeaderType() {
                return HeaderType.MESSAGE;
            }

            public String getHeader(String name) {
                if (delegate.containsKey(name)) {
                    return delegate.get(name).toString();
                }
                return null;
            }
        };
    }
}

