/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.DistributedTracePayload;
import com.newrelic.agent.deps.com.google.common.base.Charsets;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracing.DistributedTraceService;
import com.newrelic.agent.tracing.DistributedTraceUtil;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.org.apache.axis.encoding.Base64;
import java.util.logging.Level;

public class DistributedTracePayloadImpl
implements DistributedTracePayload {
    public final long timestamp;
    public final String parentType;
    public final String accountId;
    public final String trustKey;
    public final String applicationId;
    public final String guid;
    public final String traceId;
    public final Float priority;
    public final Boolean sampled;
    public final String txnId;

    public static DistributedTracePayloadImpl createDistributedTracePayload(DistributedTracePayloadImpl inboundPayload, String traceId, String guid, String txnId, float priority) {
        DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
        String accountId = distributedTraceService.getAccountId();
        if (accountId == null) {
            AgentBridge.getAgent().getLogger().log(Level.FINER, "Not creating distributed trace payload due to null accountId. Make sure the agent has connected to New Relic.");
            return null;
        }
        String trustKey = distributedTraceService.getTrustKey();
        String applicationId = distributedTraceService.getApplicationId();
        long timestamp = System.currentTimeMillis();
        String parentType = "App";
        boolean sampled = DistributedTraceUtil.isSampledPriority(priority);
        return new DistributedTracePayloadImpl(timestamp, parentType, accountId, trustKey, applicationId, guid, traceId, txnId, Float.valueOf(priority), sampled);
    }

    private DistributedTracePayloadImpl(long timestamp, String parentType, String accountId, String trustKey, String applicationId, String guid, String traceId, String txnId, Float priority, Boolean sampled) {
        this.timestamp = timestamp;
        this.parentType = parentType;
        this.accountId = accountId;
        this.trustKey = trustKey;
        this.applicationId = applicationId;
        this.guid = guid;
        this.txnId = txnId;
        this.traceId = traceId;
        this.priority = priority;
        this.sampled = sampled;
    }

    public String text() {
        DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
        JSONObject payload = new JSONObject();
        JSONArray catVersion = new JSONArray();
        catVersion.add(distributedTraceService.getMajorSupportedCatVersion());
        catVersion.add(distributedTraceService.getMinorSupportedCatVersion());
        payload.put("v", catVersion);
        JSONObject data = new JSONObject();
        data.put("ti", this.timestamp);
        data.put("ty", this.parentType);
        data.put("ac", this.accountId);
        if (!this.accountId.equals(this.trustKey)) {
            data.put("tk", this.trustKey);
        }
        data.put("ap", this.applicationId);
        if (this.guid != null) {
            data.put("id", this.guid);
        }
        data.put("tr", this.traceId);
        data.put("pr", this.priority);
        data.put("sa", this.sampled);
        if (this.txnId != null) {
            data.put("tx", this.txnId);
        }
        payload.put("d", data);
        return payload.toJSONString();
    }

    public String httpSafe() {
        return Base64.encode(this.text().getBytes(Charsets.UTF_8));
    }

    public static DistributedTracePayloadImpl parseDistributedTracePayload(DistributedTracePayloadImpl outboundPayloadData, String payload) {
        char firstChar;
        if (payload == null) {
            AgentBridge.getAgent().getLogger().log(Level.FINER, "Incoming distributed trace payload is null.");
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/Ignored/Null");
            return null;
        }
        if (outboundPayloadData != null) {
            Agent.LOG.log(Level.WARNING, "Error: createDistributedTracePayload was called before acceptDistributedTracePayload. Ignoring Call");
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/Ignored/CreateBeforeAccept");
            return null;
        }
        if (!payload.trim().isEmpty() && (firstChar = (payload = payload.trim()).charAt(0)) != '{' && firstChar != '[') {
            payload = new String(Base64.decode(payload), Charsets.UTF_8);
        }
        DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
        JSONParser parser = new JSONParser();
        try {
            JSONObject object = (JSONObject)parser.parse(payload);
            JSONArray version = (JSONArray)object.get("v");
            Long majorVersion = (Long)version.get(0);
            int majorSupportedVersion = distributedTraceService.getMajorSupportedCatVersion();
            if (majorVersion > (long)majorSupportedVersion) {
                AgentBridge.getAgent().getLogger().log(Level.FINER, "Incoming distributed trace payload major version: {0} is newer than supported agent version: {1}. Ignoring payload.", (Object)majorVersion, (Object)majorSupportedVersion);
                NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/Ignored/MajorVersion");
                return null;
            }
            JSONObject data = (JSONObject)object.get("d");
            String payloadAccountId = (String)data.get("ac");
            String payloadTrustKey = (String)data.get("tk");
            String trustKey = distributedTraceService.getTrustKey();
            if (payloadAccountId == null) {
                AgentBridge.getAgent().getLogger().log(Level.FINER, "Invalid payload {0}. Payload missing accountId.", (Object)data);
                NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/ParseException");
                return null;
            }
            String applicationId = (String)data.get("ap");
            if (applicationId == null) {
                AgentBridge.getAgent().getLogger().log(Level.FINER, "Incoming distributed trace payload is missing application id");
                NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/ParseException");
                return null;
            }
            boolean isTrustedAccountKey = trustKey.equals(payloadTrustKey == null ? payloadAccountId : payloadTrustKey);
            if (!isTrustedAccountKey) {
                AgentBridge.getAgent().getLogger().log(Level.FINER, "Incoming distributed trace payload trustKey: {0} does not match trusted account key: {1}. Ignoring payload.", (Object)payloadTrustKey, (Object)trustKey);
                NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/Ignored/UntrustedAccount");
                return null;
            }
            long timestamp = (Long)data.get("ti");
            if (timestamp <= 0L) {
                AgentBridge.getAgent().getLogger().log(Level.FINER, "Invalid payload {0}. Payload missing keys.", (Object)data);
                NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/ParseException");
                return null;
            }
            String parentType = (String)data.get("ty");
            if (parentType == null) {
                AgentBridge.getAgent().getLogger().log(Level.FINER, "Incoming distributed trace payload is missing type");
                NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/ParseException");
                return null;
            }
            String traceId = (String)data.get("tr");
            if (traceId == null) {
                AgentBridge.getAgent().getLogger().log(Level.FINER, "Incoming distributed trace payload is missing traceId");
                NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/ParseException");
                return null;
            }
            String guid = (String)data.get("id");
            String txnId = (String)data.get("tx");
            if (guid == null && txnId == null) {
                AgentBridge.getAgent().getLogger().log(Level.FINER, "Incoming distributed trace payload is missing traceId");
                NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/ParseException");
                return null;
            }
            Number priorityNumber = (Number)data.get("pr");
            Float priority = priorityNumber != null ? Float.valueOf(priorityNumber.floatValue()) : null;
            Boolean sampled = (Boolean)data.get("sa");
            DistributedTracePayloadImpl distributedTracePayload = new DistributedTracePayloadImpl(timestamp, parentType, payloadAccountId, payloadTrustKey, applicationId, guid, traceId, txnId, priority, sampled);
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.log(Level.FINEST, "Parsed distributed trace payload: {0}", distributedTracePayload);
            }
            return distributedTracePayload;
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, "Failed to parse distributed trace payload");
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/ParseException");
            return null;
        }
    }

    public String toString() {
        return "DistributedTracePayloadImpl{timestamp=" + this.timestamp + ", parentType='" + this.parentType + '\'' + ", accountId='" + this.accountId + '\'' + ", trustKey='" + this.trustKey + '\'' + ", applicationId='" + this.applicationId + '\'' + ", guid='" + this.guid + '\'' + ", traceId='" + this.traceId + '\'' + ", txnId='" + this.txnId + '\'' + ", sampled=" + this.sampled + ", priority=" + this.priority + '}';
    }
}

