/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AttributesConfig;
import com.newrelic.agent.config.AttributesConfigImpl;
import com.newrelic.agent.config.AuditModeConfig;
import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.BrowserMonitoringConfig;
import com.newrelic.agent.config.BrowserMonitoringConfigImpl;
import com.newrelic.agent.config.CircuitBreakerConfig;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.config.ClassTransformerConfigImpl;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.config.CrossProcessConfig;
import com.newrelic.agent.config.CrossProcessConfigImpl;
import com.newrelic.agent.config.DatastoreConfig;
import com.newrelic.agent.config.DatastoreConfigImpl;
import com.newrelic.agent.config.DistributedTracingConfig;
import com.newrelic.agent.config.ErrorCollectorConfig;
import com.newrelic.agent.config.ErrorCollectorConfigImpl;
import com.newrelic.agent.config.ExternalTracerConfig;
import com.newrelic.agent.config.ExternalTracerConfigImpl;
import com.newrelic.agent.config.IBMUtils;
import com.newrelic.agent.config.InsightsConfig;
import com.newrelic.agent.config.InsightsConfigImpl;
import com.newrelic.agent.config.JarCollectorConfig;
import com.newrelic.agent.config.JarCollectorConfigImpl;
import com.newrelic.agent.config.JmxConfig;
import com.newrelic.agent.config.JmxConfigImpl;
import com.newrelic.agent.config.KeyTransactionConfig;
import com.newrelic.agent.config.KeyTransactionConfigImpl;
import com.newrelic.agent.config.LabelsConfig;
import com.newrelic.agent.config.LabelsConfigImpl;
import com.newrelic.agent.config.OpenTracingConfig;
import com.newrelic.agent.config.ReinstrumentConfig;
import com.newrelic.agent.config.ReinstrumentConfigImpl;
import com.newrelic.agent.config.ServerProp;
import com.newrelic.agent.config.SpanEventsConfig;
import com.newrelic.agent.config.SqlTraceConfig;
import com.newrelic.agent.config.SqlTraceConfigImpl;
import com.newrelic.agent.config.StripExceptionConfig;
import com.newrelic.agent.config.StripExceptionConfigImpl;
import com.newrelic.agent.config.SystemPropertyFactory;
import com.newrelic.agent.config.ThreadProfilerConfig;
import com.newrelic.agent.config.ThreadProfilerConfigImpl;
import com.newrelic.agent.config.TransactionEventsConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.config.TransactionTracerConfigImpl;
import com.newrelic.agent.config.UtilizationDataConfig;
import com.newrelic.agent.transaction.TransactionNamingScheme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class AgentConfigImpl
extends BaseConfig
implements AgentConfig {
    public static final String APDEX_T = "apdex_t";
    public static final String API_HOST = "api_host";
    public static final String API_PORT = "api_port";
    public static final String APP_NAME = "app_name";
    public static final String BROWSER_MONITORING = "browser_monitoring";
    public static final String ATTRIBUTES = "attributes";
    public static final String CLASS_TRANSFORMER = "class_transformer";
    public static final String CPU_SAMPLING_ENABLED = "cpu_sampling_enabled";
    public static final String CROSS_APPLICATION_TRACER = "cross_application_tracer";
    public static final String DEBUG = "newrelic.debug";
    public static final String DISTRIBUTED_TRACING = "distributed_tracing";
    public static final String AGENT_ENABLED = "agent_enabled";
    public static final String ENABLED = "enabled";
    public static final String ENABLE_AUTO_APP_NAMING = "enable_auto_app_naming";
    public static final String ENABLE_AUTO_TRANSACTION_NAMING = "enable_auto_transaction_naming";
    public static final String ENABLE_BOOTSTRAP_CLASS_INSTRUMENTATION = "enable_bootstrap_class_instrumentation";
    public static final String ENABLE_CLASS_RETRANSFORMATION = "enable_class_retransformation";
    public static final String ENABLE_CUSTOM_TRACING = "enable_custom_tracing";
    public static final String ENABLE_SESSION_COUNT_TRACKING = "enable_session_count_tracking";
    public static final String ERROR_COLLECTOR = "error_collector";
    public static final String HIGH_SECURITY = "high_security";
    public static final String LASP_TOKEN = "security_policies_token";
    public static final String JMX = "jmx";
    public static final String JAR_COLLECTOR = "jar_collector";
    public static final String INSIGHTS = "custom_insights_events";
    public static final String ASYNC_TIMEOUT = "async_timeout";
    public static final String TRANSACTION_EVENTS = "transaction_events";
    public static final String CUSTOM_INSIGHT_EVENTS = "custom_insights_events";
    public static final String SPAN_EVENTS = "span_events";
    public static final String TRANSACTION_SEGMENTS = "transaction_segments";
    public static final String USE_PRIVATE_SSL = "use_private_ssl";
    public static final String CA_BUNDLE_PATH = "ca_bundle_path";
    public static final String REINSTRUMENT = "reinstrument";
    public static final String PLATFORM_INFORMATION_ENABLED = "platform_information_enabled";
    public static final String IBM = "ibm";
    public static final String TRANSACTION_NAMING_SCHEME = "transaction_naming_scheme";
    public static final String EXT_CONFIG_DIR = "extensions.dir";
    public static final String HOST = "host";
    public static final String IGNORE_JARS = "ignore_jars";
    public static final String IS_SSL = "ssl";
    public static final String LABELS = "labels";
    public static final String LANGUAGE = "language";
    public static final String LICENSE_KEY = "license_key";
    public static final String LOG_FILE_COUNT = "log_file_count";
    public static final String LOG_FILE_NAME = "log_file_name";
    public static final String LOG_FILE_PATH = "log_file_path";
    public static final String LOG_LEVEL = "log_level";
    public static final String LOG_LIMIT = "log_limit_in_kbytes";
    public static final String LOG_DAILY = "log_daily";
    public static final int MAX_USER_PARAMETERS = 64;
    public static final int MAX_USER_PARAMETER_SIZE = 255;
    public static final String KEY_TRANSACTIONS = "web_transactions_apdex";
    public static final String PORT = "port";
    public static final String PROXY_HOST = "proxy_host";
    public static final String PROXY_PORT = "proxy_port";
    public static final String PROXY_SCHEME = "proxy_scheme";
    public static final String PROXY_USER = "proxy_user";
    public static final String PROXY_PASS = "proxy_password";
    public static final String MAX_STACK_TRACE_LINES = "max_stack_trace_lines";
    public static final String REPORT_SQL_PARSER_ERRORS = "report_sql_parser_errors";
    public static final String SEND_DATA_ON_EXIT = "send_data_on_exit";
    public static final String SEND_DATA_ON_EXIT_THRESHOLD = "send_data_on_exit_threshold";
    public static final String SEND_ENVIRONMENT_INFO = "send_environment_info";
    public static final String SEND_JVM_PROPERY = "send_jvm_props";
    public static final String SIMPLE_COMPRESSION_PROPERTY = "simple_compression";
    public static final String PUT_FOR_DATA_SEND_PROPERTY = "put_for_data_send";
    public static final String SLOW_SQL = "slow_sql";
    public static final String STARTUP_LOG_LEVEL = "startup_log_level";
    public static final String STDOUT = "STDOUT";
    public static final String SYNC_STARTUP = "sync_startup";
    public static final String STARTUP_TIMING = "startup_timing";
    public static final String STRIP_EXCEPTION_MESSAGES = "strip_exception_messages";
    public static final String THREAD_PROFILER = "thread_profiler";
    public static final String TRANSACTION_SIZE_LIMIT = "transaction_size_limit";
    public static final String TRANSACTION_TRACER = "transaction_tracer";
    public static final String LITE_MODE = "lite_mode";
    public static final String THREAD_CPU_TIME_ENABLED = "thread_cpu_time_enabled";
    public static final String THREAD_PROFILER_ENABLED = "enabled";
    public static final String TRACE_DATA_CALLS = "trace_data_calls";
    public static final String TRIM_STATS = "trim_stats";
    public static final String UTILIZATION = "utilization";
    public static final String DATASTORE = "datastore_tracer";
    public static final String WAIT_FOR_RPM_CONNECT = "wait_for_rpm_connect";
    public static final String COMPRESSED_CONTENT_ENCODING_PROPERTY = "compressed_content_encoding";
    public static final String DEFAULT_COMPRESSED_CONTENT_ENCODING = "gzip";
    public static final String DEFAULT_SECURITY_POLICIES_TOKEN = "";
    public static final double DEFAULT_APDEX_T = 1.0;
    public static final String DEFAULT_API_HOST = "rpm.newrelic.com";
    public static final boolean DEFAULT_CPU_SAMPLING_ENABLED = true;
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_ENABLE_AUTO_APP_NAMING = false;
    public static final boolean DEFAULT_ENABLE_AUTO_TRANSACTION_NAMING = true;
    public static final boolean DEFAULT_ENABLE_CUSTOM_TRACING = true;
    public static final boolean DEFAULT_ENABLE_SESSION_COUNT_TRACKING = false;
    public static final boolean DEFAULT_HIGH_SECURITY = false;
    public static final boolean DEFAULT_PLATFORM_INFORMATION_ENABLED = true;
    public static final boolean DEFAULT_SIMPLE_COMPRESSION_ENABLED = false;
    public static final boolean DEFAULT_PUT_FOR_DATA_SEND_ENABLED = false;
    public static final String DEFAULT_HOST = "collector.newrelic.com";
    public static final boolean DEFAULT_IS_SSL = true;
    public static final String DEFAULT_LANGUAGE = "java";
    public static final int DEFAULT_LOG_FILE_COUNT = 1;
    public static final String DEFAULT_LOG_FILE_NAME = "newrelic_agent.log";
    public static final String DEFAULT_LOG_LEVEL = "info";
    public static final int DEFAULT_LOG_LIMIT = 0;
    public static final boolean DEFAULT_LOG_DAILY = false;
    public static final int DEFAULT_PORT = 80;
    public static final String DEFAULT_PROXY_HOST = null;
    public static final int DEFAULT_PROXY_PORT = 8080;
    public static final String DEFAULT_PROXY_SCHEME = null;
    public static final boolean DEFAULT_REPORT_SQL_PARSER_ERRORS = false;
    public static final boolean DEFAULT_SEND_DATA_ON_EXIT = false;
    public static final int DEFAULT_SEND_DATA_ON_EXIT_THRESHOLD = 60;
    public static final boolean DEFAULT_SEND_ENVIRONMENT_INFO = true;
    public static final int DEFAULT_SSL_PORT = 443;
    public static final boolean DEFAULT_SYNC_STARTUP = false;
    public static final boolean DEFAULT_STARTUP_TIMING = true;
    public static final boolean DEFAULT_TRACE_DATA_CALLS = false;
    public static final int DEFAULT_TRANSACTION_SIZE_LIMIT = 2000;
    public static final boolean DEFAULT_TRIM_STATS = true;
    public static final boolean DEFAULT_WAIT_FOR_RPM_CONNECT = true;
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.";
    public static final boolean DEFAULT_USE_PRIVATE_SSL = false;
    public static final String DEFAULT_CA_BUNDLE_PATH = null;
    public static final String IBM_WORKAROUND = "ibm_iv25688_workaround";
    public static final boolean IBM_WORKAROUND_DEFAULT = IBMUtils.getIbmWorkaroundDefault();
    public static final String OPEN_TRACING = "open_tracing";
    public static final String WAIT_FOR_TRANSACTIONS = "wait_for_transactions";
    public static final int DEFAULT_WAIT_FOR_TRANSACTIONS = 0;
    public static final int DEFAULT_MAX_STACK_TRACE_LINES = 30;
    public static final String GENERIC_JDBC_SUPPORT = "generic";
    public static final String MYSQL_JDBC_SUPPORT = "mysql";
    public static final Pattern REGION_AWARE = Pattern.compile("^.+?x");
    private final boolean highSecurity = this.getProperty("high_security", false);
    private final long apdexTInMillis;
    private final boolean enabled;
    private final boolean debug;
    private final String licenseKey;
    private final String host;
    private final int port;
    private final Integer proxyPort;
    private final String proxyScheme;
    private final boolean isSSL;
    private final List<String> ignoreJars;
    private final String appName;
    private final List<String> appNames;
    private final boolean cpuSamplingEnabled;
    private final boolean autoAppNamingEnabled;
    private final boolean autoTransactionNamingEnabled;
    private final String logLevel;
    private final boolean logDaily;
    private final String proxyHost;
    private final String proxyUser;
    private final String proxyPass;
    private final boolean sessionCountTrackingEnabled;
    private final int transactionSizeLimit;
    private final boolean reportSqlParserErrors;
    private final boolean waitForRPMConnect;
    private final boolean startupTimingEnabled;
    private final boolean customInstrumentationEditorAllowed;
    private final boolean customParameters;
    private final boolean isApdexTSet;
    private final boolean litemode;
    private final boolean sendJvmProps;
    private final boolean usePrivateSSL;
    private final String caBundlePath;
    private final boolean trimStats;
    private final boolean platformInformationEnabled;
    private final Map<String, Object> flattenedProperties;
    private final HashSet<String> jdbcSupport;
    private final boolean genericJdbcSupportEnabled;
    private final int maxStackTraceLines;
    private final boolean ibmWorkaroundEnabled;
    private final Config instrumentationConfig;
    private final TransactionNamingScheme transactionNamingMode;
    private final boolean simpleCompression;
    private final String compressedContentEncoding;
    private final boolean putForDataSend;
    private final int segmentTimeoutInSec;
    private final int tokenTimeoutInSec;
    private final int waitForTransactionsInMillis;
    private final String securityPoliciesToken = this.getProperty("security_policies_token", "");
    private final TransactionTracerConfigImpl transactionTracerConfig;
    private final ErrorCollectorConfig errorCollectorConfig;
    private final SqlTraceConfig sqlTraceConfig;
    private final ThreadProfilerConfig threadProfilerConfig;
    private final TransactionTracerConfigImpl requestTransactionTracerConfig;
    private final TransactionTracerConfigImpl backgroundTransactionTracerConfig;
    private final AuditModeConfig auditModeConfig;
    private final BrowserMonitoringConfig browserMonitoringConfig;
    private final ClassTransformerConfig classTransformerConfig;
    private final DistributedTracingConfig distributedTracingConfig;
    private final OpenTracingConfig openTracingConfig;
    private final KeyTransactionConfig keyTransactionConfig;
    private final JmxConfig jmxConfig;
    private final JarCollectorConfig jarCollectorConfig;
    private final InsightsConfig insightsConfig;
    private final AttributesConfig attributesConfig;
    private final ReinstrumentConfig reinstrumentConfig;
    private final CrossProcessConfig crossProcessConfig;
    private final LabelsConfig labelsConfig;
    private final CircuitBreakerConfig circuitBreakerConfig;
    private final UtilizationDataConfig utilizationConfig;
    private final DatastoreConfig datastoreConfig;
    private final ExternalTracerConfig externalTracerConfig;
    private final SpanEventsConfig spanEventsConfig;
    private final StripExceptionConfig stripExceptionConfig;
    private final TransactionEventsConfig transactionEventsConfig;

    private AgentConfigImpl(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
        this.simpleCompression = this.getProperty(SIMPLE_COMPRESSION_PROPERTY, false);
        this.compressedContentEncoding = this.initCompressedContentEncoding();
        this.putForDataSend = this.getProperty(PUT_FOR_DATA_SEND_PROPERTY, false);
        this.isApdexTSet = this.getProperty(APDEX_T) != null;
        this.apdexTInMillis = (long)(this.getDoubleProperty(APDEX_T, 1.0) * 1000.0);
        this.debug = Boolean.getBoolean(DEBUG);
        this.enabled = this.getProperty("enabled", true) != false && this.getProperty(AGENT_ENABLED, true) != false;
        this.licenseKey = (String)this.getProperty(LICENSE_KEY);
        this.host = this.parseHost(this.licenseKey, this.getProperty(HOST, DEFAULT_HOST));
        this.isSSL = this.initSsl(props);
        this.ignoreJars = new ArrayList<String>(this.getUniqueStrings(IGNORE_JARS, ","));
        this.logLevel = this.initLogLevel();
        this.logDaily = this.getProperty(LOG_DAILY, false);
        this.port = this.getIntProperty(PORT, this.isSSL ? 443 : 80);
        this.proxyHost = this.getProperty(PROXY_HOST, DEFAULT_PROXY_HOST);
        this.proxyPort = this.getIntProperty(PROXY_PORT, 8080);
        this.proxyScheme = this.getProperty(PROXY_SCHEME, DEFAULT_PROXY_SCHEME);
        this.proxyUser = this.getStringPropertyOrNull(PROXY_USER);
        this.proxyPass = this.getStringPropertyOrNull(PROXY_PASS);
        this.appNames = new ArrayList<String>(this.getUniqueStrings(APP_NAME, ";"));
        this.appName = this.getFirstString(APP_NAME, ";");
        this.cpuSamplingEnabled = this.getProperty(CPU_SAMPLING_ENABLED, true);
        this.autoAppNamingEnabled = this.getProperty(ENABLE_AUTO_APP_NAMING, false);
        this.autoTransactionNamingEnabled = this.getProperty(ENABLE_AUTO_TRANSACTION_NAMING, true);
        this.transactionSizeLimit = this.getIntProperty(TRANSACTION_SIZE_LIMIT, 2000) * 1024;
        this.sessionCountTrackingEnabled = this.getProperty(ENABLE_SESSION_COUNT_TRACKING, false);
        this.reportSqlParserErrors = this.getProperty(REPORT_SQL_PARSER_ERRORS, false);
        this.waitForRPMConnect = this.getProperty(WAIT_FOR_RPM_CONNECT, true);
        this.startupTimingEnabled = this.getProperty(STARTUP_TIMING, true);
        this.transactionTracerConfig = this.initTransactionTracerConfig(this.apdexTInMillis, this.highSecurity);
        this.requestTransactionTracerConfig = this.transactionTracerConfig.createRequestTransactionTracerConfig(this.apdexTInMillis, this.highSecurity);
        this.backgroundTransactionTracerConfig = this.transactionTracerConfig.createBackgroundTransactionTracerConfig(this.apdexTInMillis, this.highSecurity);
        this.errorCollectorConfig = this.initErrorCollectorConfig();
        this.threadProfilerConfig = this.initThreadProfilerConfig();
        this.keyTransactionConfig = this.initKeyTransactionConfig(this.apdexTInMillis);
        this.sqlTraceConfig = this.initSqlTraceConfig();
        this.auditModeConfig = this.initAuditModeConfig();
        this.browserMonitoringConfig = this.initBrowserMonitoringConfig();
        this.litemode = this.getProperty(LITE_MODE, false);
        this.classTransformerConfig = this.initClassTransformerConfig(this.litemode);
        this.crossProcessConfig = this.initCrossProcessConfig();
        this.stripExceptionConfig = this.initStripExceptionConfig(this.highSecurity);
        this.labelsConfig = new LabelsConfigImpl(this.getProperty(LABELS));
        this.utilizationConfig = this.initUtilizationConfig();
        this.datastoreConfig = this.initDatastoreConfig();
        this.externalTracerConfig = this.initExternalTracerConfig();
        this.jmxConfig = this.initJmxConfig();
        this.jarCollectorConfig = this.initJarCollectorConfig();
        this.insightsConfig = this.initInsightsConfig();
        this.attributesConfig = this.initAttributesConfig();
        this.reinstrumentConfig = this.initReinstrumentConfig();
        this.circuitBreakerConfig = this.initCircuitBreakerConfig();
        this.sendJvmProps = this.getProperty(SEND_JVM_PROPERY, true);
        this.usePrivateSSL = this.getProperty(USE_PRIVATE_SSL, false);
        this.caBundlePath = this.getProperty(CA_BUNDLE_PATH, DEFAULT_CA_BUNDLE_PATH);
        this.trimStats = this.getProperty(TRIM_STATS, true);
        this.platformInformationEnabled = this.getProperty(PLATFORM_INFORMATION_ENABLED, true);
        this.ibmWorkaroundEnabled = this.getProperty(IBM_WORKAROUND, IBM_WORKAROUND_DEFAULT);
        this.transactionNamingMode = this.parseTransactionNamingMode();
        this.instrumentationConfig = new BaseConfig(this.nestedProps("instrumentation"), "newrelic.config.instrumentation");
        this.maxStackTraceLines = this.getProperty(MAX_STACK_TRACE_LINES, 30);
        String[] jdbcSupport = this.getProperty("jdbc_support", GENERIC_JDBC_SUPPORT).split(",");
        this.jdbcSupport = new HashSet<String>(Arrays.asList(jdbcSupport));
        this.genericJdbcSupportEnabled = this.jdbcSupport.contains(GENERIC_JDBC_SUPPORT);
        this.segmentTimeoutInSec = this.initSegmentTimeout();
        this.tokenTimeoutInSec = this.initTokenTimeout();
        this.openTracingConfig = this.initOpenTracingConfig();
        this.distributedTracingConfig = this.initDistributedTracing();
        this.spanEventsConfig = this.initSpanEventsConfig(this.distributedTracingConfig.isEnabled());
        this.transactionEventsConfig = this.initTransactionEvents();
        HashMap<String, Object> flattenedProps = new HashMap<String, Object>();
        this.flatten(DEFAULT_SECURITY_POLICIES_TOKEN, props, flattenedProps);
        HashMap<String, Object> propsWithSystemProps = new HashMap<String, Object>();
        propsWithSystemProps.putAll(SystemPropertyFactory.getSystemPropertyProvider().getNewRelicPropertiesWithoutPrefix());
        propsWithSystemProps.putAll(SystemPropertyFactory.getSystemPropertyProvider().getNewRelicEnvVarsWithoutPrefix());
        this.flatten(DEFAULT_SECURITY_POLICIES_TOKEN, propsWithSystemProps, flattenedProps);
        this.checkHighSecurityPropsInFlattened(flattenedProps);
        this.flattenedProperties = Collections.unmodifiableMap(flattenedProps);
        this.waitForTransactionsInMillis = this.getProperty(WAIT_FOR_TRANSACTIONS, 0);
        this.customInstrumentationEditorAllowed = this.getProperty("custom_instrumentation_editor", !this.highSecurity);
        this.customParameters = this.getProperty("custom_parameters", !this.highSecurity);
    }

    private String parseRegion(String licenseKey) {
        if (licenseKey != null && REGION_AWARE.matcher(licenseKey = licenseKey.toLowerCase()).find()) {
            return licenseKey.substring(0, licenseKey.indexOf("x"));
        }
        return DEFAULT_SECURITY_POLICIES_TOKEN;
    }

    private String parseHost(String licenseKey, String host) {
        if (!host.equals(DEFAULT_HOST) || this.getPropertyFromSystemEnvironment(HOST, null) != null) {
            Agent.LOG.log(Level.INFO, "Using configured collector host: {0}", host);
        } else {
            String region = this.parseRegion(licenseKey);
            if (region.isEmpty()) {
                Agent.LOG.log(Level.INFO, "Using default collector host: {0}", host);
            } else {
                host = "collector." + region + ".nr-data.net";
                Agent.LOG.log(Level.INFO, "Using region aware collector host: {0}", host);
            }
        }
        return host;
    }

    private OpenTracingConfig initOpenTracingConfig() {
        Map<String, Object> openTracing = this.nestedProps(OPEN_TRACING);
        return new OpenTracingConfig(openTracing);
    }

    private DistributedTracingConfig initDistributedTracing() {
        Map<String, Object> distributedTracing = this.nestedProps(DISTRIBUTED_TRACING);
        return new DistributedTracingConfig(distributedTracing);
    }

    private SpanEventsConfig initSpanEventsConfig(boolean dtEnabled) {
        Map<String, Object> spanEvents = this.nestedProps(SPAN_EVENTS);
        return new SpanEventsConfig(spanEvents, dtEnabled);
    }

    private int initTokenTimeout() {
        if (this.getProperty(ASYNC_TIMEOUT) != null) {
            Agent.LOG.log(Level.INFO, "The property async_timeout is deprecated. Change to token_timeout");
            return this.getProperty(ASYNC_TIMEOUT, 180);
        }
        return this.getProperty("token_timeout", 180);
    }

    private int initSegmentTimeout() {
        if (this.getProperty("traced_activity_timeout") != null) {
            Agent.LOG.log(Level.INFO, "The property traced_activity_timeout is deprecated. Change to segment_timeout");
            return this.getProperty("traced_activity_timeout", 600);
        }
        return this.getProperty("segment_timeout", 600);
    }

    private TransactionNamingScheme parseTransactionNamingMode() {
        TransactionNamingScheme mode = TransactionNamingScheme.LEGACY;
        String mode_name = this.getProperty(TRANSACTION_NAMING_SCHEME, "legacy");
        if (mode_name.equals("resource_based")) {
            mode = TransactionNamingScheme.RESOURCE_BASED;
        }
        return mode;
    }

    private void checkHighSecurityPropsInFlattened(Map<String, Object> flattenedProps) {
        if (this.highSecurity && !flattenedProps.isEmpty()) {
            flattenedProps.put(IS_SSL, this.isSSL);
            flattenedProps.put("transaction_tracer.record_sql", this.transactionTracerConfig.getRecordSql());
        }
    }

    private boolean initSsl(Map<String, Object> props) {
        if (!this.getProperty(IS_SSL, true).booleanValue()) {
            Agent.LOG.log(Level.INFO, "Agent versions 4.0.0+ must connect with SSL. Agent is ignoring yml config and enabling SSL.");
            props.put(IS_SSL, true);
        }
        return true;
    }

    private void flatten(String prefix, Map<String, Object> source, Map<String, Object> dest) {
        for (Map.Entry<String, Object> e : source.entrySet()) {
            if (e.getValue() instanceof Map) {
                this.flatten(prefix + e.getKey() + '.', (Map)e.getValue(), dest);
                continue;
            }
            Object destinationValue = dest.get(prefix + e.getKey());
            if (destinationValue instanceof ServerProp) continue;
            dest.put(prefix + e.getKey(), e.getValue());
        }
    }

    public <T> T getValue(String path) {
        return this.getValue(path, null);
    }

    public <T> T getValue(String path, T defaultValue) {
        Object value = this.flattenedProperties.get(path.replaceAll("[.-]", "_"));
        if (value == null) {
            value = this.flattenedProperties.get(path);
        }
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof ServerProp) {
            value = ((ServerProp)value).getValue();
            return this.castValue(path, value, defaultValue);
        }
        if (value instanceof String && defaultValue instanceof Boolean) {
            value = Boolean.valueOf((String)value);
            return (T)value;
        }
        if (value instanceof String && defaultValue instanceof Integer) {
            value = Integer.valueOf((String)value);
            return (T)value;
        }
        try {
            return (T)value;
        }
        catch (ClassCastException ccx) {
            Agent.LOG.log(Level.FINE, "Using default value \"{0}\" for \"{1}\"", defaultValue, path);
            return defaultValue;
        }
    }

    private String initLogLevel() {
        String val = this.getProperty(LOG_LEVEL, DEFAULT_LOG_LEVEL);
        if (val instanceof Boolean) {
            return "off";
        }
        return this.getProperty(LOG_LEVEL, DEFAULT_LOG_LEVEL).toLowerCase();
    }

    private CrossProcessConfig initCrossProcessConfig() {
        Boolean prop = (Boolean)this.getProperty("cross_application_tracing");
        Map<String, Object> props = this.nestedProps(CROSS_APPLICATION_TRACER);
        if (prop != null) {
            if (props == null) {
                props = this.createMap();
            }
            props.put("cross_application_tracing", prop);
        }
        return CrossProcessConfigImpl.createCrossProcessConfig(props);
    }

    private StripExceptionConfig initStripExceptionConfig(boolean highSecurity) {
        Map<String, Object> props = this.nestedProps(STRIP_EXCEPTION_MESSAGES);
        return StripExceptionConfigImpl.createStripExceptionConfig(props, highSecurity);
    }

    private ThreadProfilerConfig initThreadProfilerConfig() {
        Map<String, Object> props = this.nestedProps(THREAD_PROFILER);
        return ThreadProfilerConfigImpl.createThreadProfilerConfig(props);
    }

    private KeyTransactionConfig initKeyTransactionConfig(long apdexTInMillis) {
        Map<String, Object> props = this.nestedProps(KEY_TRANSACTIONS);
        return KeyTransactionConfigImpl.createKeyTransactionConfig(props, apdexTInMillis);
    }

    private TransactionTracerConfigImpl initTransactionTracerConfig(long apdexTInMillis, boolean highSecurity) {
        Map<String, Object> props = this.nestedProps(TRANSACTION_TRACER);
        return TransactionTracerConfigImpl.createTransactionTracerConfig(props, apdexTInMillis, highSecurity);
    }

    private ErrorCollectorConfig initErrorCollectorConfig() {
        Map<String, Object> props = this.nestedProps(ERROR_COLLECTOR);
        return ErrorCollectorConfigImpl.createErrorCollectorConfig(props);
    }

    private SqlTraceConfig initSqlTraceConfig() {
        Map<String, Object> props = this.nestedProps(SLOW_SQL);
        SqlTraceConfig sqlTraceConfig = SqlTraceConfigImpl.createSqlTraceConfig(props);
        if (sqlTraceConfig.isUsingLongerSqlId()) {
            Agent.LOG.info("Agent is configured to use longer sql id for sql traces");
        }
        return sqlTraceConfig;
    }

    private JmxConfig initJmxConfig() {
        Map<String, Object> props = this.nestedProps(JMX);
        return JmxConfigImpl.createJmxConfig(props);
    }

    private JarCollectorConfig initJarCollectorConfig() {
        Map<String, Object> props = this.nestedProps(JAR_COLLECTOR);
        return JarCollectorConfigImpl.createJarCollectorConfig(props);
    }

    private InsightsConfig initInsightsConfig() {
        Map<String, Object> props = this.nestedProps("custom_insights_events");
        return InsightsConfigImpl.createInsightsConfig(props, this.highSecurity);
    }

    private AttributesConfig initAttributesConfig() {
        Map<String, Object> props = this.nestedProps(ATTRIBUTES);
        return AttributesConfigImpl.createAttributesConfig(props);
    }

    private ReinstrumentConfig initReinstrumentConfig() {
        Map<String, Object> props = this.nestedProps(REINSTRUMENT);
        return ReinstrumentConfigImpl.createReinstrumentConfig(props);
    }

    private AuditModeConfig initAuditModeConfig() {
        Object auditMode = this.getProperty("audit_mode");
        if (auditMode != null && auditMode instanceof Map) {
            Map<String, Object> props = this.nestedProps("audit_mode");
            return new AuditModeConfig(props);
        }
        boolean auditModeEnabled = this.getProperty("audit_mode", false);
        boolean traceDataCalls = this.getProperty(TRACE_DATA_CALLS, false);
        return new AuditModeConfig(auditModeEnabled, traceDataCalls);
    }

    private BrowserMonitoringConfig initBrowserMonitoringConfig() {
        Map<String, Object> props = this.nestedProps(BROWSER_MONITORING);
        return BrowserMonitoringConfigImpl.createBrowserMonitoringConfig(props);
    }

    private ClassTransformerConfig initClassTransformerConfig(boolean liteMode) {
        boolean customTracingEnabled = this.getProperty(ENABLE_CUSTOM_TRACING, true);
        Map<String, Object> props = this.nestedProps(CLASS_TRANSFORMER);
        return ClassTransformerConfigImpl.createClassTransformerConfig(props, customTracingEnabled, liteMode);
    }

    private CircuitBreakerConfig initCircuitBreakerConfig() {
        Map<String, Object> props = this.nestedProps("circuitbreaker");
        return new CircuitBreakerConfig(props);
    }

    private UtilizationDataConfig initUtilizationConfig() {
        Map<String, Object> props = this.nestedProps(UTILIZATION);
        return new UtilizationDataConfig(props);
    }

    private DatastoreConfig initDatastoreConfig() {
        Map<String, Object> props = this.nestedProps(DATASTORE);
        return new DatastoreConfigImpl(props);
    }

    private ExternalTracerConfig initExternalTracerConfig() {
        Map<String, Object> props = this.nestedProps("external_tracer");
        return new ExternalTracerConfigImpl(props);
    }

    private TransactionEventsConfig initTransactionEvents() {
        Map<String, Object> transactionEvents = this.nestedProps(TRANSACTION_EVENTS);
        return new TransactionEventsConfig(transactionEvents);
    }

    private String initCompressedContentEncoding() {
        if ("deflate".equals(this.getProperty(COMPRESSED_CONTENT_ENCODING_PROPERTY))) {
            return "deflate";
        }
        return DEFAULT_COMPRESSED_CONTENT_ENCODING;
    }

    @Override
    public long getApdexTInMillis() {
        return this.apdexTInMillis;
    }

    @Override
    public long getApdexTInMillis(String transactionName) {
        return this.keyTransactionConfig.getApdexTInMillis(transactionName);
    }

    @Override
    public boolean isApdexTSet() {
        return this.isApdexTSet;
    }

    @Override
    public boolean isApdexTSet(String transactionName) {
        return this.keyTransactionConfig.isApdexTSet(transactionName);
    }

    @Override
    public boolean isAgentEnabled() {
        return this.enabled;
    }

    @Override
    public String getLicenseKey() {
        return this.licenseKey;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Override
    public String getProxyScheme() {
        return this.proxyScheme;
    }

    @Override
    public String getProxyUser() {
        return this.proxyUser;
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPass;
    }

    @Override
    public String getApiHost() {
        return this.getProperty(API_HOST, DEFAULT_API_HOST);
    }

    @Override
    public int getApiPort() {
        return this.getProperty(API_PORT, this.isSSL ? 443 : 80);
    }

    @Override
    public boolean isSSL() {
        return this.isSSL;
    }

    @Override
    public String getApplicationName() {
        return this.appName;
    }

    @Override
    public List<String> getApplicationNames() {
        return this.appNames;
    }

    @Override
    public boolean isCpuSamplingEnabled() {
        return this.cpuSamplingEnabled;
    }

    @Override
    public boolean isAutoAppNamingEnabled() {
        return this.autoAppNamingEnabled;
    }

    @Override
    public boolean isAutoTransactionNamingEnabled() {
        return this.autoTransactionNamingEnabled;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debug;
    }

    @Override
    public boolean isDebugEnabled(String key) {
        return this.getProperty(key + "_debug", false);
    }

    @Override
    public boolean isSessionCountTrackingEnabled() {
        return this.sessionCountTrackingEnabled;
    }

    @Override
    public String getLanguage() {
        return this.getProperty(LANGUAGE, DEFAULT_LANGUAGE);
    }

    @Override
    public boolean isSendDataOnExit() {
        return this.getProperty(SEND_DATA_ON_EXIT, false);
    }

    @Override
    public long getSendDataOnExitThresholdInMillis() {
        int valueInSecs = this.getIntProperty(SEND_DATA_ON_EXIT_THRESHOLD, 60);
        return TimeUnit.MILLISECONDS.convert(valueInSecs, TimeUnit.SECONDS);
    }

    @Override
    public boolean isAuditMode() {
        return this.auditModeConfig.isEnabled();
    }

    @Override
    public AuditModeConfig getAuditModeConfig() {
        return this.auditModeConfig;
    }

    @Override
    public boolean liteMode() {
        return this.litemode;
    }

    @Override
    public int getSegmentTimeoutInSec() {
        return this.segmentTimeoutInSec;
    }

    @Override
    public int getTokenTimeoutInSec() {
        return this.tokenTimeoutInSec;
    }

    @Override
    public int waitForTransactionsInMillis() {
        return this.waitForTransactionsInMillis;
    }

    @Override
    public boolean laspEnabled() {
        return !this.securityPoliciesToken.isEmpty();
    }

    @Override
    public String securityPoliciesToken() {
        return this.securityPoliciesToken;
    }

    @Override
    public boolean isCustomInstrumentationEditorAllowed() {
        return this.customInstrumentationEditorAllowed;
    }

    @Override
    public boolean isCustomParametersAllowed() {
        return this.customParameters;
    }

    @Override
    public DistributedTracingConfig getDistributedTracingConfig() {
        return this.distributedTracingConfig;
    }

    @Override
    public SpanEventsConfig getSpanEventsConfig() {
        return this.spanEventsConfig;
    }

    @Override
    public boolean isReportSqlParserErrors() {
        return this.reportSqlParserErrors;
    }

    @Override
    public int getTransactionSizeLimit() {
        return this.transactionSizeLimit;
    }

    @Override
    public boolean waitForRPMConnect() {
        return this.waitForRPMConnect;
    }

    @Override
    public boolean isSyncStartup() {
        return this.getProperty(SYNC_STARTUP, false);
    }

    @Override
    public boolean isSendEnvironmentInfo() {
        return this.getProperty(SEND_ENVIRONMENT_INFO, true);
    }

    @Override
    public boolean isLoggingToStdOut() {
        String logFileName = this.getLogFileName();
        return STDOUT.equalsIgnoreCase(logFileName);
    }

    @Override
    public int getLogFileCount() {
        return this.getIntProperty(LOG_FILE_COUNT, 1);
    }

    @Override
    public String getLogFileName() {
        return this.getProperty(LOG_FILE_NAME, DEFAULT_LOG_FILE_NAME);
    }

    @Override
    public String getLogFilePath() {
        return (String)this.getProperty(LOG_FILE_PATH);
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public int getLogLimit() {
        return this.getIntProperty(LOG_LIMIT, 0);
    }

    @Override
    public TransactionTracerConfig getTransactionTracerConfig() {
        return this.transactionTracerConfig;
    }

    @Override
    public TransactionTracerConfig getBackgroundTransactionTracerConfig() {
        return this.backgroundTransactionTracerConfig;
    }

    @Override
    public TransactionTracerConfig getRequestTransactionTracerConfig() {
        return this.requestTransactionTracerConfig;
    }

    @Override
    public ErrorCollectorConfig getErrorCollectorConfig() {
        return this.errorCollectorConfig;
    }

    @Override
    public SqlTraceConfig getSqlTraceConfig() {
        return this.sqlTraceConfig;
    }

    @Override
    public CrossProcessConfig getCrossProcessConfig() {
        return this.crossProcessConfig;
    }

    @Override
    public ThreadProfilerConfig getThreadProfilerConfig() {
        return this.threadProfilerConfig;
    }

    @Override
    public JmxConfig getJmxConfig() {
        return this.jmxConfig;
    }

    @Override
    public JarCollectorConfig getJarCollectorConfig() {
        return this.jarCollectorConfig;
    }

    @Override
    public InsightsConfig getInsightsConfig() {
        return this.insightsConfig;
    }

    @Override
    public AttributesConfig getAttributesConfig() {
        return this.attributesConfig;
    }

    @Override
    public ReinstrumentConfig getReinstrumentConfig() {
        return this.reinstrumentConfig;
    }

    @Override
    public BrowserMonitoringConfig getBrowserMonitoringConfig() {
        return this.browserMonitoringConfig;
    }

    @Override
    public ClassTransformerConfig getClassTransformerConfig() {
        return this.classTransformerConfig;
    }

    @Override
    public List<String> getIgnoreJars() {
        return this.ignoreJars;
    }

    @Override
    public boolean isSendJvmProps() {
        return this.sendJvmProps;
    }

    @Override
    public boolean isUsePrivateSSL() {
        return this.usePrivateSSL;
    }

    @Override
    public String getCaBundlePath() {
        return this.caBundlePath;
    }

    @Override
    public boolean isLogDaily() {
        return this.logDaily;
    }

    @Override
    public boolean isTrimStats() {
        return this.trimStats;
    }

    public static AgentConfig createAgentConfig(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new AgentConfigImpl(settings);
    }

    @Override
    public boolean isPlatformInformationEnabled() {
        return this.platformInformationEnabled;
    }

    @Override
    public Set<String> getJDBCSupport() {
        return this.jdbcSupport;
    }

    @Override
    public boolean isGenericJDBCSupportEnabled() {
        return this.genericJdbcSupportEnabled;
    }

    @Override
    public int getMaxStackTraceLines() {
        return this.maxStackTraceLines;
    }

    @Override
    public Config getInstrumentationConfig() {
        return this.instrumentationConfig;
    }

    @Override
    public int getMaxUserParameters() {
        return 64;
    }

    @Override
    public int getMaxUserParameterSize() {
        return 255;
    }

    @Override
    public boolean isHighSecurity() {
        return this.highSecurity;
    }

    @Override
    public boolean isSimpleCompression() {
        return this.simpleCompression;
    }

    @Override
    public String getCompressedContentEncoding() {
        return this.compressedContentEncoding;
    }

    @Override
    public boolean isPutForDataSend() {
        return this.putForDataSend;
    }

    @Override
    public boolean getIbmWorkaroundEnabled() {
        return this.ibmWorkaroundEnabled;
    }

    @Override
    public LabelsConfig getLabelsConfig() {
        return this.labelsConfig;
    }

    @Override
    public boolean isStartupTimingEnabled() {
        return this.startupTimingEnabled;
    }

    @Override
    public CircuitBreakerConfig getCircuitBreakerConfig() {
        return this.circuitBreakerConfig;
    }

    @Override
    public StripExceptionConfig getStripExceptionConfig() {
        return this.stripExceptionConfig;
    }

    @Override
    public TransactionNamingScheme getTransactionNamingScheme() {
        return this.transactionNamingMode;
    }

    @Override
    public UtilizationDataConfig getUtilizationDataConfig() {
        return this.utilizationConfig;
    }

    @Override
    public DatastoreConfig getDatastoreConfig() {
        return this.datastoreConfig;
    }

    @Override
    public ExternalTracerConfig getExternalTracerConfig() {
        return this.externalTracerConfig;
    }

    @Override
    public boolean openTracingEnabled() {
        return this.openTracingConfig.isEnabled();
    }

    @Override
    public TransactionEventsConfig getTransactionEventsConfig() {
        return this.transactionEventsConfig;
    }
}

