/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension;

import com.newrelic.agent.Agent;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.config.ConfigFileHelper;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.com.google.common.base.Predicate;
import com.newrelic.agent.deps.com.google.common.collect.Collections2;
import com.newrelic.agent.extension.ConfigurationConstruct;
import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.extension.ExtensionFileTypes;
import com.newrelic.agent.extension.ExtensionParsers;
import com.newrelic.agent.extension.JarExtension;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.context.InstrumentationContextManager;
import com.newrelic.agent.instrumentation.custom.ClassRetransformer;
import com.newrelic.agent.instrumentation.custom.ExtensionClassAndMethodMatcher;
import com.newrelic.agent.jmx.JmxService;
import com.newrelic.agent.reinstrument.ReinstrumentResult;
import com.newrelic.agent.reinstrument.ReinstrumentUtils;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.Service;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ExtensionService
extends AbstractService
implements HarvestListener {
    private ExtensionParsers extensionParsers;
    private final Map<String, Extension> internalExtensions = new HashMap<String, Extension>();
    private volatile Set<Extension> extensions = Collections.emptySet();
    private final List<ExtensionClassAndMethodMatcher> pointCuts = new ArrayList<ExtensionClassAndMethodMatcher>();
    private final Map<File, Long> weaveExtensions = new HashMap<File, Long>();
    private final List<Service> services = new ArrayList<Service>();
    private final List<ConfigurationConstruct> constructs = new ArrayList<ConfigurationConstruct>();
    private long lastReloaded = 0L;
    private int elementCount = -1;

    public ExtensionService() {
        super(ExtensionService.class.getSimpleName());
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() {
        if (this.isEnabled()) {
            this.extensionParsers = new ExtensionParsers(this.constructs);
            try {
                this.initializeBuiltInExtensions();
                this.loadExtensionJars();
                this.reloadCustomExtensionsIfModified();
                this.reloadWeaveInstrumentationIfModified();
            }
            catch (NoSuchMethodError e) {
                Agent.LOG.error("Unable to initialize agent extensions.  The likely cause is duplicate copies of javax.xml libraries.");
                Agent.LOG.log(Level.FINE, e.toString(), e);
            }
            catch (NoClassDefFoundError e) {
                Agent.LOG.error("Unable to initialize agent extensions. The likely cause is an incorrectly configured javax.xml.");
                Agent.LOG.log(Level.FINE, e, "");
            }
        }
    }

    @Override
    protected void doStop() {
        this.internalExtensions.clear();
        this.pointCuts.clear();
        this.weaveExtensions.clear();
        for (Service service : this.services) {
            try {
                service.stop();
            }
            catch (Exception e) {
                String msg = MessageFormat.format("Unable to stop extension service \"{0}\" - {1}", service.getName(), e.toString());
                Agent.LOG.severe(msg);
                this.getLogger().log(Level.FINE, msg, e);
            }
        }
        this.services.clear();
    }

    @Override
    public void beforeHarvest(String pAppName, StatsEngine pStatsEngine) {
    }

    @Override
    public void afterHarvest(String pAppName) {
        if (!ServiceFactory.getConfigService().getDefaultAgentConfig().getApplicationName().equals(pAppName)) {
            return;
        }
        if (ServiceFactory.getCoreService().getInstrumentation().isRetransformClassesSupported()) {
            this.reloadCustomExtensionsIfModified();
            this.reloadWeaveInstrumentationIfModified();
        } else {
            Agent.LOG.log(Level.FINEST, "Retransformation is not supported - not reloading extensions.");
        }
    }

    protected void addInternalExtensionForTesting(Extension ext) {
        this.internalExtensions.put(ext.getName(), ext);
    }

    private void initializeBuiltInExtensions() {
        ClassTransformerConfig classTransformerConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getClassTransformerConfig();
        String jarFileName = AgentJarHelper.getAgentJarFileName();
        if (jarFileName == null) {
            this.getLogger().log(Level.SEVERE, "Unable to find the agent jar file");
            return;
        }
        boolean defaultInstrumentationDisabled = !classTransformerConfig.isDefaultInstrumentationEnabled();
        boolean builtinExtensionsDisabled = !classTransformerConfig.isBuiltinExtensionEnabled();
        boolean builtinExtensionsExplicitlyEnabled = classTransformerConfig.isBuiltinExtensionEnabled();
        if (defaultInstrumentationDisabled && !builtinExtensionsExplicitlyEnabled) {
            this.getLogger().log(Level.FINEST, "Instrumentation is disabled by default. Not loading builtin extensions");
        } else if (builtinExtensionsDisabled) {
            this.getLogger().log(Level.INFO, "Builtin extensions are disabled");
        } else {
            try {
                JarExtension jarExtension = JarExtension.create(this.getLogger(), this.extensionParsers, jarFileName);
                this.addJarExtensions(jarExtension);
            }
            catch (IOException e) {
                this.getLogger().severe(MessageFormat.format("Unable to read extensions from the agent jar : {0}", e.toString()));
                this.getLogger().log(Level.FINER, "Extensions error", e);
            }
        }
    }

    private void loadExtensionJars() {
        Collection<JarExtension> jarExtensions = this.loadJarExtensions(this.getExtensionDirectory());
        for (JarExtension extension : jarExtensions) {
            if (extension.isWeaveInstrumentation()) continue;
            try {
                for (Class<?> clazz : extension.getClasses()) {
                    this.noticeExtensionClass(clazz);
                }
                this.addJarExtensions(extension);
            }
            catch (Throwable t) {
                Agent.LOG.log(Level.INFO, "An error occurred adding extension {0} : {1}", extension.getFile(), t.getMessage());
                Agent.LOG.log(Level.FINEST, t, t.getMessage());
            }
        }
    }

    private void addJarExtensions(JarExtension jarExtension) {
        for (Extension extension : jarExtension.getExtensions().values()) {
            Extension validateExtension = this.validateExtension(extension, this.internalExtensions);
            if (validateExtension == null) continue;
            this.internalExtensions.put(extension.getName(), extension);
        }
    }

    private void reloadCustomExtensionsIfModified() {
        File[] ymlFiles;
        boolean fileModified;
        File[] xmlFiles = this.getExtensionFiles(ExtensionFileTypes.XML.getFilter());
        boolean bl = fileModified = xmlFiles.length + (ymlFiles = this.getExtensionFiles(ExtensionFileTypes.YML.getFilter())).length != this.elementCount;
        if (!fileModified) {
            for (File file : xmlFiles) {
                fileModified |= file.lastModified() <= System.currentTimeMillis() && this.lastReloaded < file.lastModified();
            }
            for (File file : ymlFiles) {
                fileModified |= file.lastModified() <= System.currentTimeMillis() && this.lastReloaded < file.lastModified();
            }
        }
        if (fileModified) {
            this.lastReloaded = System.currentTimeMillis();
            this.elementCount = xmlFiles.length + ymlFiles.length;
            this.pointCuts.clear();
            HashMap<String, Extension> allExtensions = new HashMap<String, Extension>(this.internalExtensions);
            this.loadValidExtensions(xmlFiles, this.extensionParsers.getXmlParser(), allExtensions);
            this.loadValidExtensions(ymlFiles, this.extensionParsers.getYamlParser(), allExtensions);
            HashSet<Extension> externalExtensions = new HashSet<Extension>(allExtensions.values());
            externalExtensions.removeAll(this.internalExtensions.values());
            Set<Extension> oldExtensions = this.extensions;
            this.extensions = Collections.unmodifiableSet(externalExtensions);
            JmxService jmxService = ServiceFactory.getJmxService();
            if (jmxService != null) {
                jmxService.reloadExtensions(oldExtensions, this.extensions);
            }
            for (Extension extension : allExtensions.values()) {
                this.pointCuts.addAll(extension.getInstrumentationMatchers());
            }
            ClassRetransformer retransformer = ServiceFactory.getClassTransformerService().getLocalRetransformer();
            if (retransformer != null) {
                Class[] allLoadedClasses = ServiceFactory.getCoreService().getInstrumentation().getAllLoadedClasses();
                retransformer.setClassMethodMatchers(this.pointCuts);
                Set<Class<?>> classesToRetransform = InstrumentationContext.getMatchingClasses(retransformer.getMatchers(), allLoadedClasses);
                ReinstrumentUtils.checkClassExistsAndRetransformClasses(new ReinstrumentResult(), Collections.emptyList(), null, classesToRetransform);
            }
        }
    }

    private void reloadWeaveInstrumentationIfModified() {
        File[] jarFiles = this.getExtensionFiles(ExtensionFileTypes.JAR.getFilter());
        Collection<File> weaveFiles = Collections2.filter(Arrays.asList(jarFiles), new Predicate<File>(){

            @Override
            public boolean apply(File extension) {
                boolean isWeave = JarExtension.isWeaveInstrumentation(extension);
                return isWeave;
            }
        });
        HashSet<File> newWeaveFiles = new HashSet<File>();
        HashSet<File> removedWeaveFiles = new HashSet<File>();
        for (File file : weaveFiles) {
            Long timestamp = this.weaveExtensions.get(file);
            if (timestamp != null && (timestamp > System.currentTimeMillis() || timestamp.longValue() == file.lastModified())) continue;
            newWeaveFiles.add(file);
        }
        for (File file : this.weaveExtensions.keySet()) {
            if (weaveFiles.contains(file)) continue;
            removedWeaveFiles.add(file);
        }
        if (newWeaveFiles.size() > 0 || removedWeaveFiles.size() > 0) {
            this.weaveExtensions.clear();
            for (File file : weaveFiles) {
                this.weaveExtensions.put(file, file.lastModified());
            }
            InstrumentationContextManager contextManager = ServiceFactory.getClassTransformerService().getContextManager();
            if (contextManager != null) {
                contextManager.getClassWeaverService().reloadExternalWeavePackages(newWeaveFiles, removedWeaveFiles).run();
            }
            Agent.LOG.finer("Weave extension jars: " + this.weaveExtensions);
        }
    }

    private File[] getExtensionFiles(FileFilter filter) {
        File directory = this.getExtensionDirectory();
        if (directory == null) {
            return new File[0];
        }
        return directory.listFiles(filter);
    }

    private File getExtensionDirectory() {
        File configDir;
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        String configDirName = (String)agentConfig.getProperty("extensions.dir");
        if (configDirName == null) {
            configDirName = ConfigFileHelper.getNewRelicDirectory() + File.separator + "extensions";
        }
        if (!(configDir = new File(configDirName)).exists()) {
            Agent.LOG.log(Level.FINE, "The extension directory " + configDir.getAbsolutePath() + " does not exist.");
            configDir = null;
        } else if (!configDir.isDirectory()) {
            Agent.LOG.log(Level.WARNING, "The extension directory " + configDir.getAbsolutePath() + " is not a directory.");
            configDir = null;
        } else if (!configDir.canRead()) {
            Agent.LOG.log(Level.WARNING, "The extension directory " + configDir.getAbsolutePath() + " is not readable.");
            configDir = null;
        }
        return configDir;
    }

    private void loadValidExtensions(File[] files, ExtensionParsers.ExtensionParser parser, HashMap<String, Extension> extensions) {
        if (files != null) {
            for (File file : files) {
                this.getLogger().log(Level.FINER, MessageFormat.format("Reading custom extension file {0}", file.getAbsolutePath()));
                try {
                    Extension currentExt = this.readExtension(parser, file);
                    currentExt = this.validateExtension(currentExt, extensions);
                    if (currentExt != null) {
                        extensions.put(currentExt.getName(), currentExt);
                        continue;
                    }
                    this.getLogger().log(Level.WARNING, "Extension in file " + file.getAbsolutePath() + " could not be read in.");
                }
                catch (Exception ex) {
                    this.getLogger().severe("Unable to parse extension. Check permissions on " + file.getAbsolutePath() + ".  " + ex.toString());
                    this.getLogger().log(Level.FINE, ex.toString(), ex);
                }
            }
        }
    }

    private Extension readExtension(ExtensionParsers.ExtensionParser parser, File file) throws Exception {
        try (FileInputStream iStream = new FileInputStream(file);){
            Extension extension = parser.parse(AgentBridge.getAgent().getClass().getClassLoader(), iStream, true);
            return extension;
        }
    }

    protected Extension validateExtension(Extension extension, Map<String, Extension> existingExtensions) {
        String name = extension.getName();
        if (name != null && name.length() != 0) {
            double version = extension.getVersionNumber();
            Extension existing = existingExtensions.get(name);
            if (existing == null) {
                this.getLogger().log(Level.FINER, MessageFormat.format("Adding extension with name {0} and version {1}", name, Double.valueOf(version).toString()));
                return extension;
            }
            if (version > existing.getVersionNumber()) {
                this.getLogger().log(Level.FINER, MessageFormat.format("Updating extension with name {0} to version {1}", name, Double.valueOf(version).toString()));
                return extension;
            }
            this.getLogger().log(Level.FINER, MessageFormat.format("Additional extension with name {0} and version {1} being ignored. Another file with name and version already read in.", name, Double.valueOf(version).toString()));
        }
        return null;
    }

    private void noticeExtensionClass(Class<?> clazz) {
        this.getLogger().finest(MessageFormat.format("Noticed extension class {0}", clazz.getName()));
        if (Service.class.isAssignableFrom(clazz)) {
            try {
                this.addService((Service)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception ex) {
                this.getLogger().severe(MessageFormat.format("Unable to instantiate extension service \"{0}\"", clazz.getName()));
                this.getLogger().log(Level.FINE, "Unable to instantiate service", ex);
            }
        }
    }

    private void addService(Service service) {
        String msg = MessageFormat.format("Noticed extension service \"{0}\"", service.getName());
        this.getLogger().finest(msg);
        if (!service.isEnabled()) {
            return;
        }
        this.services.add(service);
        msg = MessageFormat.format("Starting extension service \"{0}\"", service.getName());
        this.getLogger().finest(msg);
        try {
            service.start();
        }
        catch (Exception e) {
            msg = MessageFormat.format("Unable to start extension service \"{0}\" - {1}", service.getName(), e.toString());
            this.getLogger().severe(msg);
            this.getLogger().log(Level.FINE, msg, e);
        }
    }

    private Collection<JarExtension> loadJarExtensions(File jarDirectory) {
        if (jarDirectory == null || !jarDirectory.exists()) {
            return Collections.emptyList();
        }
        if (jarDirectory.isDirectory()) {
            return this.loadJars(jarDirectory.listFiles(ExtensionFileTypes.JAR.getFilter()));
        }
        if (jarDirectory.exists()) {
            return this.loadJars(new File[]{jarDirectory});
        }
        return Collections.emptyList();
    }

    private Collection<JarExtension> loadJars(File[] jarFiles) {
        ArrayList<JarExtension> extensions = new ArrayList<JarExtension>();
        for (File file : jarFiles) {
            try {
                JarExtension ext = JarExtension.create(this.getLogger(), this.extensionParsers, file);
                extensions.add(ext);
            }
            catch (Throwable ex) {
                Agent.LOG.severe("Unable to load extension " + file.getName());
                Agent.LOG.log(Level.FINER, ex.toString(), ex);
            }
        }
        return Collections.unmodifiableCollection(extensions);
    }

    public final List<ExtensionClassAndMethodMatcher> getEnabledPointCuts() {
        return this.pointCuts;
    }

    public void addConstruct(ConfigurationConstruct construct) {
        this.constructs.add(construct);
    }

    public final Map<String, Extension> getInternalExtensions() {
        return Collections.unmodifiableMap(this.internalExtensions);
    }

    public final Set<Extension> getExtensions() {
        return this.extensions;
    }

    public Collection<File> getWeaveExtensions() {
        return this.weaveExtensions.keySet();
    }

    @VisibleForTesting
    long getLastReloaded() {
        return this.lastReloaded;
    }
}

