/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.weaver;

import com.newrelic.agent.Agent;
import com.newrelic.agent.instrumentation.weaver.ClassWeaverService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.api.agent.weaver.MatchType;
import com.newrelic.weave.weavepackage.PackageValidationResult;
import com.newrelic.weave.weavepackage.WeavePackage;
import com.newrelic.weave.weavepackage.WeavePackageLifetimeListener;
import java.io.Closeable;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public class AgentWeaverListener
implements WeavePackageLifetimeListener {
    private final ConcurrentMap<WeavePackage, List<Closeable>> closeables = new ConcurrentHashMap<WeavePackage, List<Closeable>>();

    @Override
    public void registered(WeavePackage weavepackage) {
        Agent.LOG.log(Level.FINE, "registered weave package: {0}", weavepackage.getName());
        this.closeables.put(weavepackage, new ArrayList());
    }

    @Override
    public void deregistered(WeavePackage weavepackage) {
        Agent.LOG.log(Level.FINE, "deregistered weave package: {0}", weavepackage.getName());
        List closers = (List)this.closeables.remove(weavepackage);
        Agent.LOG.log(Level.FINER, "{0}: closing {1} closeables", weavepackage.getName(), closers.size());
        for (Closeable closer : closers) {
            try {
                Agent.LOG.log(Level.FINER, "\t{0}", closer);
                closer.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void validated(PackageValidationResult packageResult, ClassLoader classloader) {
        String weavePackageName = packageResult.getWeavePackage().getName();
        float weavePackageVersion = packageResult.getWeavePackage().getVersion();
        if (packageResult.succeeded()) {
            String supportabilityLoadedMetric = packageResult.getWeavePackage().getConfig().isCustom() ? "Supportability/WeaveInstrumentation/Loaded/Custom/{0}/{1}" : "Supportability/WeaveInstrumentation/Loaded/{0}/{1}";
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork(MessageFormat.format(supportabilityLoadedMetric, weavePackageName, Float.valueOf(weavePackageVersion)), 1.0f));
            Agent.LOG.log(Level.FINE, "{0} - validated classloader {1}", weavePackageName, classloader);
        } else {
            Level weaveViolationLevel;
            String supportabilitySkippedMetric;
            WeavePackage weavePackage = packageResult.getWeavePackage();
            if (Agent.LOG.isFinestEnabled() && weavePackage.weavesBootstrap()) {
                Map<String, MatchType> matchTypes = weavePackage.getMatchTypes();
                for (Map.Entry<String, MatchType> entry : matchTypes.entrySet()) {
                    if (entry.getValue() == null) continue;
                    Agent.LOG.log(Level.FINEST, "Bootstrap class {0} : {1}", entry.getKey(), weavePackage.isBootstrapClassName(Collections.singleton(entry.getKey())));
                }
            }
            if (weavePackage.getConfig().isCustom()) {
                supportabilitySkippedMetric = "Supportability/WeaveInstrumentation/Skipped/Custom/{0}/{1}";
                weaveViolationLevel = Level.INFO;
            } else {
                supportabilitySkippedMetric = "Supportability/WeaveInstrumentation/Skipped/{0}/{1}";
                weaveViolationLevel = Level.FINE;
            }
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork(MessageFormat.format(supportabilitySkippedMetric, weavePackageName, Float.valueOf(weavePackageVersion)), 1.0f));
            ClassWeaverService.logWeaveViolations(packageResult, weaveViolationLevel, classloader);
        }
    }

    public void registerInstrumentationCloseable(String weavePackageName, WeavePackage weavePackage, Closeable closeable) {
        if (null != weavePackage && this.closeables.containsKey(weavePackage)) {
            ((List)this.closeables.get(weavePackage)).add(closeable);
        } else {
            Agent.LOG.log(Level.FINER, "Asked to register closeable for weave package {0} but no such package exists. Closing {1}. This should rarely happen.", weavePackageName, closeable);
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

