/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.method;

import com.newrelic.agent.instrumentation.InstrumentationType;
import com.newrelic.agent.instrumentation.InstrumentedMethod;
import com.newrelic.agent.util.StringMap;
import com.newrelic.agent.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MethodInfo {
    public abstract List<Map<String, Object>> getJsonMethodMaps(StringMap var1);

    @Deprecated
    public final List<Map<String, Object>> getJsonMethodMaps() {
        return this.getJsonMethodMaps(Strings.getPassthroughStringMap());
    }

    private static void addOneMethodInstrumentedInfo(Map<String, Object> toAdd, InstrumentedMethod instrumentedMethod) {
        if (instrumentedMethod != null) {
            HashMap<String, Object> inst = new HashMap<String, Object>();
            inst.put("dispatcher", instrumentedMethod.dispatcher());
            MethodInfo.addInstrumentationInfo(inst, instrumentedMethod);
            toAdd.put("traced_instrumentation", inst);
        }
    }

    private static void addInstrumentationInfo(Map<String, Object> inst, InstrumentedMethod instrumentedMethod) {
        MethodInfo.addInstrumentationInfo(inst, instrumentedMethod, Strings.getPassthroughStringMap());
    }

    private static void addInstrumentationInfo(Map<String, Object> inst, InstrumentedMethod instrumentedMethod, StringMap stringMap) {
        InstrumentationType[] inputTypes = instrumentedMethod.instrumentationTypes();
        String[] inputNames = instrumentedMethod.instrumentationNames();
        if (inputTypes != null && inputNames != null && inputTypes.length > 0 && inputTypes.length == inputNames.length) {
            HashMap<String, ArrayList<Object>> instrumentedTypes = new HashMap<String, ArrayList<Object>>();
            for (int i = 0; i < inputTypes.length; ++i) {
                if (!MethodInfo.isTimedInstrumentation(inputTypes[i])) continue;
                ArrayList<Object> names = (ArrayList<Object>)instrumentedTypes.get(inputTypes[i].toString());
                if (names == null) {
                    names = new ArrayList<Object>();
                    names.add(stringMap.addString(inputNames[i]));
                    instrumentedTypes.put(inputTypes[i].toString(), names);
                    continue;
                }
                names.add(stringMap.addString(inputNames[i]));
            }
            if (instrumentedTypes.size() > 0) {
                inst.put("types", instrumentedTypes);
            }
        }
    }

    static Map<String, Object> getMethodMap(StringMap stringMap, List<String> arguments, InstrumentedMethod annotation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        MethodInfo.addOneMethodArgs(stringMap, map, arguments);
        MethodInfo.addOneMethodInstrumentedInfo(map, annotation);
        return map;
    }

    private static boolean isTimedInstrumentation(InstrumentationType type) {
        return type != InstrumentationType.WeaveInstrumentation;
    }

    private static void addOneMethodArgs(StringMap stringMap, Map<String, Object> toAdd, List<String> arguments) {
        ArrayList<Object> tokens = new ArrayList<Object>(arguments.size());
        for (String arg : arguments) {
            tokens.add(stringMap.addString(arg));
        }
        toAdd.put("args", tokens);
    }
}

