/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.JarResource;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.reflections.Reflections;
import com.newrelic.agent.deps.org.reflections.util.ConfigurationBuilder;
import com.newrelic.agent.instrumentation.pointcuts.InterfaceMapper;
import com.newrelic.agent.instrumentation.pointcuts.InterfaceMixin;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.jmx.metrics.JmxInit;
import com.newrelic.agent.util.EncodingAwareJsonSerializer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class Annotations {
    private static Reflections loaded;

    public Collection<Class<?>> getInterfaceMapperClasses() {
        return Annotations.getAnnotationClassesFromManifest(InterfaceMapper.class, "com/newrelic/agent/instrumentation/pointcuts");
    }

    public Collection<Class<?>> getInterfaceMixinClasses() {
        return Annotations.getAnnotationClassesFromManifest(InterfaceMixin.class, "com/newrelic/agent/instrumentation/pointcuts");
    }

    public Collection<Class<?>> getPointCutAnnotatedClasses() {
        return Annotations.getAnnotationClassesFromManifest(PointCut.class, "com/newrelic/agent/instrumentation/pointcuts");
    }

    public Collection<Class<?>> getJmxInitClasses() {
        return Annotations.getAnnotationClassesFromManifest(JmxInit.class, "com/newrelic/agent/jmx/values");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Class<?>> getAnnotationClassesFromManifest(Class<? extends Annotation> annotationClass, String packageSearchPath) {
        if (loaded == null) {
            JarResource agentJarFile = AgentJarHelper.getAgentJarResource();
            try {
                ConfigurationBuilder builder = new ConfigurationBuilder().setSerializer(new EncodingAwareJsonSerializer());
                builder.setClassLoaders(new ClassLoader[]{AgentBridge.getAgent().getClass().getClassLoader()});
                Reflections loader = new Reflections(builder);
                loaded = loader.collect(agentJarFile.getInputStream("newrelic-manifest.json"));
            }
            catch (Exception e) {
                Set<Class<?>> set = Collections.emptySet();
                return set;
            }
            finally {
                try {
                    agentJarFile.close();
                }
                catch (IOException e) {
                    Agent.LOG.log(Level.FINEST, e, e.toString());
                }
            }
        }
        Set<Class<?>> annotationClasses = loaded.getTypesAnnotatedWith(annotationClass);
        packageSearchPath = packageSearchPath.replaceAll("/", ".");
        HashSet<Class<?>> filteredAnnotationClasses = Sets.newHashSetWithExpectedSize(annotationClasses.size());
        for (Class<?> annotationClassValue : annotationClasses) {
            if (!annotationClassValue.getName().startsWith(packageSearchPath)) continue;
            filteredAnnotationClasses.add(annotationClassValue);
        }
        return filteredAnnotationClasses;
    }
}

