/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.attributes;

import com.newrelic.agent.Agent;
import com.newrelic.agent.MetricNames;
import com.newrelic.agent.attributes.AttributeValidator;
import java.util.Map;
import java.util.logging.Level;

public abstract class AttributeSender {
    private final AttributeValidator attributeValidator;

    public AttributeSender(AttributeValidator attributeValidator) {
        this.attributeValidator = attributeValidator;
    }

    protected abstract String getAttributeType();

    protected abstract Map<String, Object> getAttributeMap();

    protected void addCustomAttributeImpl(String key, Object value, String methodName) {
        block5: {
            Object filteredValue = this.attributeValidator.verifyParameterAndReturnValue(key, value, methodName);
            if (filteredValue == null) {
                return;
            }
            try {
                Map<String, Object> attributeMap = this.getAttributeMap();
                if (attributeMap != null) {
                    attributeMap.put(key, filteredValue);
                    Agent.LOG.log(Level.FINER, "Added {0} attribute \"{1}\": {2}", this.getAttributeType(), key, filteredValue);
                    MetricNames.recordApiSupportabilityMetric("AddCustomParameter");
                }
            }
            catch (Throwable t) {
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, "Exception adding attribute for key: \"{0}\": {1}", key, t);
                }
                if (!Agent.LOG.isLoggable(Level.FINER)) break block5;
                Agent.LOG.log(Level.FINER, "Exception adding attribute for key: \"{0}\": {1}", key);
            }
        }
    }

    protected void addCustomAttributesImpl(Map<String, Object> params, String methodName) {
        block5: {
            Map<String, Object> filteredValues = this.attributeValidator.verifyParametersAndReturnValues(params, methodName);
            if (filteredValues == null || filteredValues.isEmpty()) {
                return;
            }
            try {
                Map<String, Object> attributeMap = this.getAttributeMap();
                if (attributeMap != null) {
                    attributeMap.putAll(filteredValues);
                    Agent.LOG.log(Level.FINER, "Added {0} attributes \"{1}\"", this.getAttributeType(), filteredValues);
                    MetricNames.recordApiSupportabilityMetric("AddCustomParameter");
                }
            }
            catch (Throwable t) {
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, "Exception adding attributes for keys: \"{0}\": {1}", filteredValues.keySet(), t);
                }
                if (!Agent.LOG.isLoggable(Level.FINER)) break block5;
                Agent.LOG.log(Level.FINER, "Exception adding attributes for keys: \"{0}\": {1}", filteredValues.keySet());
            }
        }
    }

    public void addAttribute(String key, String value, String methodName) {
        this.addCustomAttributeImpl(key, value, methodName);
    }

    public void addAttribute(String key, Number value, String methodName) {
        this.addCustomAttributeImpl(key, value, methodName);
    }

    public void addAttribute(String key, Boolean value, String methodName) {
        this.addCustomAttributeImpl(key, value, methodName);
    }

    public void addAttribute(String key, Map<String, String> values, String methodName) {
        this.addCustomAttributeImpl(key, values, methodName);
    }

    public void addAttributes(Map<String, Object> params, String methodName) {
        this.addCustomAttributesImpl(params, methodName);
    }

    public <T> T verifyParameterAndReturnValue(String key, T value, String methodCalled) {
        return this.attributeValidator.verifyParameterAndReturnValue(key, value, methodCalled);
    }

    protected Map<String, Object> verifyParametersAndReturnValues(Map<String, Object> params, String methodCalled) {
        return this.attributeValidator.verifyParametersAndReturnValues(params, methodCalled);
    }

    protected void setTransactional(boolean newSetting) {
        this.attributeValidator.setTransactional(newSetting);
    }
}

