/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.attributes;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.deps.com.google.common.collect.MapDifference;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public class AttributeValidator {
    private final String attributeType;
    private boolean isTransactional = true;
    private static final Collection<String> sendParametersOutsideOfTxn = Arrays.asList("noticeError", "Span.addCustomParameter", "Span.addCustomParameters", "TracedMethod.addCustomAttributes");

    private String getAttributeType() {
        return this.attributeType;
    }

    public AttributeValidator(String attributeType) {
        this.attributeType = attributeType;
    }

    protected void setTransactional(boolean isTransactional) {
        this.isTransactional = isTransactional;
    }

    public <T> T verifyParameterAndReturnValue(String key, T value, String methodCalled) {
        if (key == null) {
            Agent.LOG.log(Level.FINER, "Unable to add {0} attribute because {1} was invoked with a null key", this.getAttributeType(), methodCalled);
            return null;
        }
        if (value == null) {
            Agent.LOG.log(Level.FINER, "Unable to add {0} attribute because {1} was invoked with a null value for key \"{2}\"", this.getAttributeType(), methodCalled, key);
            return null;
        }
        if (!this.isAcceptableValueType(value)) {
            return null;
        }
        if (!this.validateAndLogKeyLength(key, methodCalled)) {
            return null;
        }
        if (value instanceof String) {
            value = this.truncateValue(key, (String)value, methodCalled);
        }
        if (value instanceof Number || value instanceof Boolean || value instanceof AtomicBoolean) {
            value = this.verifyValue(value);
        }
        if (sendParametersOutsideOfTxn.contains(methodCalled)) {
            return value;
        }
        Transaction tx = Transaction.getTransaction(false);
        if (this.isTransactional && (tx == null || !tx.isInProgress())) {
            Agent.LOG.log(Level.FINER, "Unable to add {0} attribute with key \"{1}\" because {2} was invoked outside a New Relic transaction.", this.getAttributeType(), key, methodCalled);
            return null;
        }
        return value;
    }

    protected Map<String, Object> verifyParametersAndReturnValues(Map<String, Object> params, String methodCalled) {
        LinkedHashMap<String, Object> verifiedParams = new LinkedHashMap<String, Object>();
        if (params == null || params.isEmpty()) {
            Agent.LOG.log(Level.FINER, "Unable to add {0} attributes because {1} was invoked with a null or empty map", this.getAttributeType(), methodCalled);
            return Collections.emptyMap();
        }
        for (Map.Entry<String, Object> current : params.entrySet()) {
            Object currentValue;
            int remainingParamCapacity = 64 - verifiedParams.size();
            if (remainingParamCapacity == 0) {
                this.logParametersToDrop(verifiedParams, params);
                return verifiedParams;
            }
            String currentKey = current.getKey();
            Object verifiedValue = this.verifyParameterAndReturnValue(currentKey, currentValue = current.getValue(), methodCalled);
            if (verifiedValue == null) continue;
            verifiedParams.put(currentKey, verifiedValue);
        }
        return verifiedParams;
    }

    private boolean isAcceptableValueType(Object value) {
        return value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof AtomicBoolean;
    }

    private boolean validateAndLogKeyLength(String key, String methodCalled) {
        try {
            if (key.getBytes(StandardCharsets.UTF_8).length > 255) {
                Agent.LOG.log(Level.FINER, "Unable to add {0} attribute because {1} was invoked with a key longer than {2} bytes. Key is \"{3}\".", this.getAttributeType(), methodCalled, 255, key);
                return false;
            }
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, "Exception while verifying attribute", t);
            return false;
        }
        return true;
    }

    private String truncateValue(String key, String value, String methodCalled) {
        String truncatedVal = AttributeValidator.truncateString(value, 255);
        if (!value.equals(truncatedVal)) {
            Agent.LOG.log(Level.FINER, "{0} was invoked with a value longer than {2} bytes for key \"{3}\". The value will be shortened to the first {4} characters.", methodCalled, value, 255, key, truncatedVal.length());
        }
        return truncatedVal;
    }

    public static String truncateString(String s, int maxBytes) {
        int truncatedSize = 0;
        for (int i = 0; i < s.length(); ++i) {
            int characterSize;
            char c = s.charAt(i);
            if (c <= '\u007f') {
                characterSize = 1;
            } else if (c <= '\u07ff') {
                characterSize = 2;
            } else if (c <= '\ud7ff') {
                characterSize = 3;
            } else if (c <= '\udfff') {
                characterSize = 4;
                ++i;
            } else {
                characterSize = 3;
            }
            if (truncatedSize + characterSize > maxBytes) {
                return s.substring(0, i);
            }
            truncatedSize += characterSize;
        }
        return s;
    }

    private <T> Object verifyValue(T value) {
        if (value instanceof Double && (((Double)value).isInfinite() || ((Double)value).isNaN())) {
            return null;
        }
        if (value instanceof Float && (((Float)value).isInfinite() || ((Float)value).isNaN())) {
            return null;
        }
        if (value instanceof Double || value instanceof Float || value instanceof Long || value instanceof Integer || value instanceof Boolean || value instanceof BigInteger || value instanceof BigDecimal) {
            return value;
        }
        if (value instanceof AtomicInteger) {
            return ((AtomicInteger)value).intValue();
        }
        if (value instanceof AtomicLong) {
            return ((AtomicLong)value).longValue();
        }
        if (value instanceof AtomicBoolean) {
            return ((AtomicBoolean)value).get();
        }
        return null;
    }

    private void logParametersToDrop(Map<String, Object> verified, Map<String, Object> allParams) {
        MapDifference<String, Object> diff = Maps.difference(verified, allParams);
        Agent.LOG.log(Level.FINER, "Unable to add attributes for keys \"{0}\" because the limit on {1} attributes has been reached.", diff.entriesOnlyOnRight().keySet(), this.getAttributeType());
    }
}

