/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.attributes;

import com.newrelic.agent.attributes.DestinationFilter;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AttributesConfigImpl;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.logging.Level;

public class AttributesFilter {
    private final boolean captureRequestParameters;
    private final boolean captureMessageParameters;
    private final DestinationFilter rootFilter;
    private final DestinationFilter errorEventFilter;
    private final DestinationFilter transactionEventFilter;
    private final DestinationFilter transactionTraceFilter;
    private final DestinationFilter spanEventFilter;
    private final DestinationFilter transactionSegmentFilter;
    private final DestinationFilter browserFilter;
    private final Map<String, DestinationFilter> destinationFilterMap;

    public AttributesFilter(AgentConfig config) {
        this(config, AttributesConfigImpl.DEFAULT_BROWSER_EXCLUDES, AttributesConfigImpl.DEFAULT_ERROR_EVENTS_EXCLUDES, AttributesConfigImpl.DEFAULT_TRANSACTION_EVENTS_EXCLUDES, AttributesConfigImpl.DEFAULT_TRANSACTION_TRACES_EXCLUDES, AttributesConfigImpl.DEFAULT_SPAN_EVENTS_EXCLUDES, AttributesConfigImpl.DEFAULT_TRANSACTION_SEGMENTS_EXCLUDES);
    }

    public AttributesFilter(AgentConfig config, String[] defaultExcludeBrowser, String[] defaultExcludeErrorEvents, String[] defaultExcludeTransactionEvents, String[] defaultExcludeTransactionTraces, String[] defaultExcludeSpanEvents, String[] defaultExcludeTransactionSegments) {
        this.rootFilter = new DestinationFilter("attributes", true, config, defaultExcludeErrorEvents, "attributes");
        this.errorEventFilter = new DestinationFilter("error_collector", true, config, defaultExcludeErrorEvents, "error_collector");
        this.transactionEventFilter = new DestinationFilter("transaction_events", true, config, defaultExcludeTransactionEvents, "transaction_events");
        this.transactionTraceFilter = new DestinationFilter("transaction_tracer", true, config, defaultExcludeTransactionTraces, "transaction_tracer");
        this.browserFilter = new DestinationFilter("browser_monitoring", false, config, defaultExcludeBrowser, "browser_monitoring");
        this.spanEventFilter = new DestinationFilter("span_events", true, config, defaultExcludeSpanEvents, "span_events");
        this.transactionSegmentFilter = new DestinationFilter("transaction_segments", true, config, defaultExcludeTransactionSegments, "transaction_segments");
        this.destinationFilterMap = ImmutableMap.builder().put("attributes", this.rootFilter).put("error_collector", this.errorEventFilter).put("transaction_events", this.transactionEventFilter).put("transaction_tracer", this.transactionTraceFilter).put("browser_monitoring", this.browserFilter).put("span_events", this.spanEventFilter).put("transaction_segments", this.transactionSegmentFilter).build();
        boolean enabled = this.errorEventFilter.isEnabled() || this.transactionEventFilter.isEnabled() || this.transactionTraceFilter.isEnabled() || this.spanEventFilter.isEnabled() || this.transactionSegmentFilter.isEnabled();
        this.captureRequestParameters = this.captureAllParams(enabled, config.isHighSecurity(), "request.parameters.");
        this.captureMessageParameters = this.captureAllParams(enabled, config.isHighSecurity(), "message.parameters.");
    }

    private boolean captureAllParams(boolean enabled, boolean highSecurity, String paramStart) {
        if (!enabled || highSecurity) {
            return false;
        }
        return this.errorEventFilter.isPotentialConfigMatch(paramStart) || this.transactionEventFilter.isPotentialConfigMatch(paramStart) || this.transactionTraceFilter.isPotentialConfigMatch(paramStart) || this.browserFilter.isPotentialConfigMatch(paramStart) || this.spanEventFilter.isPotentialConfigMatch(paramStart) || this.transactionSegmentFilter.isPotentialConfigMatch(paramStart);
    }

    public boolean captureRequestParams() {
        return this.captureRequestParameters;
    }

    public boolean captureMessageParams() {
        return this.captureMessageParameters;
    }

    public boolean isAttributesEnabledForErrorEvents() {
        return this.errorEventFilter.isEnabled();
    }

    public boolean isAttributesEnabledForTransactionEvents() {
        return this.transactionEventFilter.isEnabled();
    }

    public boolean isAttributesEnabledForTransactionTraces() {
        return this.transactionTraceFilter.isEnabled();
    }

    public boolean isAttributesEnabledForBrowser() {
        return this.browserFilter.isEnabled();
    }

    public boolean isAttributesEnabledForSpanEvents() {
        return this.spanEventFilter.isEnabled();
    }

    public boolean isAttributesEnabledForTransactionSegments() {
        return this.transactionSegmentFilter.isEnabled();
    }

    public Map<String, ?> filterErrorEventAttributes(Map<String, ?> values) {
        return this.errorEventFilter.filterAttributes(values);
    }

    public Map<String, ?> filterTransactionEventAttributes(Map<String, ?> values) {
        return this.transactionEventFilter.filterAttributes(values);
    }

    public Map<String, ?> filterTransactionTraceAttributes(Map<String, Object> values) {
        return this.transactionTraceFilter.filterAttributes(values);
    }

    public Map<String, ?> filterBrowserAttributes(Map<String, Object> values) {
        return this.browserFilter.filterAttributes(values);
    }

    public Map<String, ?> filterSpanEventAttributes(Map<String, ?> values) {
        return this.spanEventFilter.filterAttributes(values);
    }

    public Map<String, ?> filterTransactionSegmentAttributes(Map<String, Object> values) {
        return this.transactionSegmentFilter.filterAttributes(values);
    }

    public Map<String, ?> filterAttributes(Map<String, Object> values) {
        return this.rootFilter.filterAttributes(values);
    }

    public Map<String, ?> filterAttributesForDestination(Map<String, Object> values, String destination) {
        DestinationFilter destinationFilter = this.destinationFilterMap.get(destination);
        if (destinationFilter == null) {
            AgentBridge.getAgent().getLogger().log(Level.SEVERE, "Invalid destination for attribute filter {0}. Attributes are not filtered.", (Object)destination);
            return values;
        }
        return destinationFilter.filterAttributes(values);
    }

    public boolean shouldIncludeSpanAttribute(String attributeName) {
        return this.spanEventFilter.shouldIncludeAttribute(attributeName);
    }

    public boolean shouldIncludeErrorAttribute(String attributeName) {
        return this.errorEventFilter.shouldIncludeAttribute(attributeName);
    }
}

