/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.core;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.PrivateApiImpl;
import com.newrelic.agent.TransactionService;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.core.CoreService;
import com.newrelic.agent.logging.AgentLogManager;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.api.agent.NewRelicApiImplementation;
import java.lang.instrument.Instrumentation;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;

public class CoreServiceImpl
extends AbstractService
implements CoreService {
    private volatile boolean enabled = true;
    private final Instrumentation instrumentation;
    private volatile InstrumentationProxy instrumentationProxy;

    public CoreServiceImpl(Instrumentation instrumentation) {
        super(CoreService.class.getName());
        this.instrumentation = instrumentation;
    }

    @Override
    protected void doStart() {
        ConfigService configService = ServiceFactory.getConfigService();
        AgentConfig config = configService.getDefaultAgentConfig();
        AgentLogManager.configureLogger(config);
        this.logHostIp();
        Agent.LOG.info(MessageFormat.format("New Relic Agent v{0} is initializing...", Agent.getVersion()));
        this.enabled = config.isAgentEnabled();
        if (!this.enabled) {
            Agent.LOG.info("New Relic agent is disabled.");
        }
        if (config.liteMode()) {
            Agent.LOG.info("New Relic agent is running in lite mode. All instrumentation modules are disabled");
            StatsService statsService = ServiceFactory.getServiceManager().getStatsService();
            statsService.getMetricAggregator().incrementCounter("Supportability/litemode");
        }
        this.instrumentationProxy = InstrumentationProxy.getInstrumentationProxy(this.instrumentation);
        this.initializeBridgeApis();
        final long startTime = System.currentTimeMillis();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CoreServiceImpl.this.jvmShutdown(startTime);
            }
        };
        Thread shutdownThread = new Thread(runnable, "New Relic JVM Shutdown");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    private void initializeBridgeApis() {
        NewRelicApiImplementation.initialize();
        PrivateApiImpl.initialize(Agent.LOG);
    }

    private void logHostIp() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            Agent.LOG.info("Agent Host: " + address.getHostName() + " IP: " + address.getHostAddress());
        }
        catch (UnknownHostException e) {
            Agent.LOG.info("New Relic could not identify host/ip.");
        }
    }

    @Override
    protected void doStop() {
    }

    @Override
    public void shutdownAsync() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CoreServiceImpl.this.shutdown();
            }
        };
        Thread shutdownThread = new Thread(runnable, "New Relic Shutdown");
        shutdownThread.start();
    }

    private void jvmShutdown(long startTime) {
        this.getLogger().fine("Agent JVM shutdown hook: enter.");
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        if (config.waitForTransactionsInMillis() > 0) {
            this.getLogger().fine("Agent JVM shutdown hook: waiting for transactions to finish");
            long finishTime = System.currentTimeMillis() + (long)config.waitForTransactionsInMillis();
            TransactionService txService = ServiceFactory.getTransactionService();
            while (txService.getTransactionsInProgress() > 0 && System.currentTimeMillis() < finishTime) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.getLogger().fine("Agent JVM shutdown hook: transactions finished");
        }
        if (config.isSendDataOnExit() && System.currentTimeMillis() - startTime >= config.getSendDataOnExitThresholdInMillis()) {
            List<IRPMService> rpmServices = ServiceFactory.getRPMServiceManager().getRPMServices();
            for (IRPMService rpmService : rpmServices) {
                rpmService.harvestNow();
            }
        }
        this.getLogger().info("JVM is shutting down");
        this.shutdown();
        this.getLogger().fine("Agent JVM shutdown hook: done.");
    }

    private synchronized void shutdown() {
        try {
            ServiceFactory.getServiceManager().stop();
            this.getLogger().info("New Relic Agent has shutdown");
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.SEVERE, t, "Error shutting down New Relic Agent");
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public InstrumentationProxy getInstrumentation() {
        return this.instrumentationProxy;
    }
}

