/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.AdviceAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.AbstractTracingMethodAdapter;
import com.newrelic.agent.instrumentation.InvocationHandlerTracingMethodAdapter;
import com.newrelic.agent.instrumentation.MethodBuilder;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.ReflectionStyleClassMethodAdapter;
import com.newrelic.agent.instrumentation.StopProcessingException;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.PointCutInvocationHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;

public class GenericClassAdapter
extends ClassVisitor {
    private static final String CLINIT_METHOD_NAME = "<clinit>";
    private static final String NO_ARG_VOID_DESC = "()V";
    private static final String INIT_CLASS_METHOD_NAME = "__nr__initClass";
    protected final String className;
    private final ClassLoader classLoader;
    final Class<?> classBeingRedefined;
    private final List<AbstractTracingMethodAdapter> instrumentedMethods = new ArrayList<AbstractTracingMethodAdapter>();
    private final List<PointCut> pointcutsApplied = new ArrayList<PointCut>();
    private int version;
    private boolean processedClassInitMethod;
    private final Collection<PointCut> matches;
    private final InstrumentationContext context;

    public GenericClassAdapter(ClassVisitor cv, ClassLoader classLoader, String className, Class<?> classBeingRedefined, Collection<PointCut> strongMatches, InstrumentationContext context) {
        super(458752, cv);
        this.context = context;
        this.matches = strongMatches;
        this.classLoader = classLoader;
        this.className = className;
        this.classBeingRedefined = classBeingRedefined;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        boolean isInterface;
        boolean bl = isInterface = (access & 0x200) != 0;
        if (isInterface) {
            throw new StopProcessingException(name + " is an interface");
        }
        super.visit(version, access, name, signature, superName, interfaces);
        this.version = version;
    }

    boolean canModifyClassStructure() {
        return PointCutClassTransformer.canModifyClassStructure(this.classLoader, this.classBeingRedefined);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.canModifyClassStructure() && CLINIT_METHOD_NAME.equals(name)) {
            mv = new InitMethodAdapter(mv, access, name, desc);
            this.processedClassInitMethod = true;
            return mv;
        }
        if ((access & 0x400) != 0) {
            return mv;
        }
        PointCut pointCut = this.getMatch(access, name, desc);
        if (pointCut == null) {
            return mv;
        }
        Method method = new Method(name, desc);
        this.context.addTimedMethods(method);
        if (this.canModifyClassStructure()) {
            this.context.addOldInvokerStyleInstrumentationMethod(method, pointCut);
            mv = new InvocationHandlerTracingMethodAdapter(this, mv, access, method);
            this.pointcutsApplied.add(pointCut);
        } else {
            PointCutInvocationHandler pointCutInvocationHandler = pointCut.getPointCutInvocationHandler();
            int id = ServiceFactory.getTracerService().getInvocationHandlerId(pointCutInvocationHandler);
            if (id == -1) {
                Agent.LOG.log(Level.FINE, "Unable to find invocation handler for method: {0} in class: {1}. Skipping instrumentation.", name, this.className);
            } else {
                this.context.addOldReflectionStyleInstrumentationMethod(method, pointCut);
                mv = new ReflectionStyleClassMethodAdapter(this, mv, access, method, id);
                this.pointcutsApplied.add(pointCut);
            }
        }
        return mv;
    }

    private PointCut getMatch(int access, String name, String desc) {
        for (PointCut pc : this.matches) {
            if (!pc.getMethodMatcher().matches(-1, name, desc, MethodMatcher.UNSPECIFIED_ANNOTATIONS)) continue;
            return pc;
        }
        return null;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.canModifyClassStructure() && (this.processedClassInitMethod || this.instrumentedMethods.size() > 0) || this.mustAddNRClassInit()) {
            this.createNRClassInitMethod();
        }
        if (this.instrumentedMethods.size() > 0) {
            if (this.canModifyClassStructure() || this.mustAddField()) {
                this.createInvocationHandlerField();
            }
            if ((this.canModifyClassStructure() || this.mustAddNRClassInit()) && !this.processedClassInitMethod) {
                this.createClassInitMethod();
            }
        }
    }

    private boolean mustAddNRClassInit() {
        if (this.classBeingRedefined == null) {
            return false;
        }
        try {
            this.classBeingRedefined.getDeclaredMethod(INIT_CLASS_METHOD_NAME, new Class[0]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean mustAddField() {
        if (this.classBeingRedefined == null) {
            return false;
        }
        try {
            this.classBeingRedefined.getDeclaredField("__nr__InvocationHandlers");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void createClassInitMethod() {
        MethodVisitor mv = this.cv.visitMethod(8, CLINIT_METHOD_NAME, NO_ARG_VOID_DESC, null, null);
        mv = new InitMethodAdapter(mv, 8, CLINIT_METHOD_NAME, NO_ARG_VOID_DESC);
        mv.visitCode();
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createNRClassInitMethod() {
        MethodVisitor mv = this.cv.visitMethod(8, INIT_CLASS_METHOD_NAME, NO_ARG_VOID_DESC, null, null);
        mv = new InitMethod(mv, 8, INIT_CLASS_METHOD_NAME, NO_ARG_VOID_DESC);
        mv.visitCode();
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createInvocationHandlerField() {
        this.cv.visitField(10, "__nr__InvocationHandlers", MethodBuilder.INVOCATION_HANDLER_ARRAY_TYPE.getDescriptor(), null, null);
    }

    int addInstrumentedMethod(AbstractTracingMethodAdapter methodAdapter) {
        int index = this.instrumentedMethods.size();
        this.instrumentedMethods.add(methodAdapter);
        return index;
    }

    public Collection<AbstractTracingMethodAdapter> getInstrumentedMethods() {
        return this.instrumentedMethods;
    }

    public List<PointCut> getAppliedPointCuts() {
        return this.pointcutsApplied;
    }

    private class InitMethod
    extends AdviceAdapter {
        private InitMethod(MethodVisitor mv, int access, String name, String desc) {
            super(458752, mv, access, name, desc);
        }

        private int getAgentWrapper() {
            new MethodBuilder(this, this.methodAccess).loadInvocationHandlerFromProxy();
            int invocationHandlerVar = this.newLocal(MethodBuilder.INVOCATION_HANDLER_TYPE);
            this.mv.visitVarInsn(58, invocationHandlerVar);
            return invocationHandlerVar;
        }

        @Override
        protected void onMethodEnter() {
            if (GenericClassAdapter.this.classBeingRedefined != null) {
                return;
            }
            int invocationHandlerVar = this.getAgentWrapper();
            this.visitLdcInsn(Type.getObjectType(GenericClassAdapter.this.className));
            int classVar = this.newLocal(Type.getType(Object.class));
            this.mv.visitVarInsn(58, classVar);
            if (GenericClassAdapter.this.canModifyClassStructure()) {
                this.push(GenericClassAdapter.this.instrumentedMethods.size());
                this.newArray(MethodBuilder.INVOCATION_HANDLER_TYPE);
                this.putStatic(Type.getObjectType(GenericClassAdapter.this.className), "__nr__InvocationHandlers", MethodBuilder.INVOCATION_HANDLER_ARRAY_TYPE);
                for (AbstractTracingMethodAdapter methodAdapter : GenericClassAdapter.this.instrumentedMethods) {
                    if (methodAdapter.getInvocationHandlerIndex() < 0) continue;
                    this.initMethod(classVar, invocationHandlerVar, methodAdapter);
                }
            }
        }

        private void initMethod(int classVar, int invocationHandlerVar, AbstractTracingMethodAdapter methodAdapter) {
            this.getStatic(Type.getObjectType(GenericClassAdapter.this.className), "__nr__InvocationHandlers", MethodBuilder.INVOCATION_HANDLER_ARRAY_TYPE);
            this.push(methodAdapter.getInvocationHandlerIndex());
            this.mv.visitVarInsn(25, invocationHandlerVar);
            this.mv.visitVarInsn(25, classVar);
            this.visitInsn(1);
            ArrayList<Object> arguments = new ArrayList<Object>(Arrays.asList(GenericClassAdapter.this.className, methodAdapter.methodName, methodAdapter.getMethodDescriptor(), false, false));
            new MethodBuilder(this, this.methodAccess).loadArray(Object.class, arguments.toArray(new Object[arguments.size()])).invokeInvocationHandlerInterface(false);
            this.checkCast(MethodBuilder.INVOCATION_HANDLER_TYPE);
            this.arrayStore(MethodBuilder.INVOCATION_HANDLER_TYPE);
        }
    }

    private class InitMethodAdapter
    extends AdviceAdapter {
        protected InitMethodAdapter(MethodVisitor mv, int access, String name, String desc) {
            super(458752, mv, access, name, desc);
        }

        @Override
        protected void onMethodEnter() {
            this.mv.visitMethodInsn(184, GenericClassAdapter.this.className, GenericClassAdapter.INIT_CLASS_METHOD_NAME, GenericClassAdapter.NO_ARG_VOID_DESC, false);
        }
    }
}

