/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.classmatchers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.base.Supplier;
import com.newrelic.agent.deps.com.google.common.collect.Multimaps;
import com.newrelic.agent.deps.com.google.common.collect.SetMultimap;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.classmatchers.ClassAndMethodMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.methodmatchers.AnnotationMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class OptimizedClassMatcherBuilder {
    private static final Supplier<Set<ClassAndMethodMatcher>> CLASS_AND_METHOD_MATCHER_SET_SUPPLIER = new Supplier<Set<ClassAndMethodMatcher>>(){

        @Override
        public Set<ClassAndMethodMatcher> get() {
            return Collections.newSetFromMap(new HashMap());
        }
    };
    private final SetMultimap<MethodMatcher, ClassAndMethodMatcher> methodMatchers = Multimaps.newSetMultimap(new HashMap(), CLASS_AND_METHOD_MATCHER_SET_SUPPLIER);
    private final SetMultimap<Method, ClassAndMethodMatcher> methods = Multimaps.newSetMultimap(new HashMap(), CLASS_AND_METHOD_MATCHER_SET_SUPPLIER);
    private final Set<String> methodAnnotationMatchers = new HashSet<String>();
    private final Set<String> exactClassNames = new HashSet<String>();
    private boolean exactClassMatch = true;

    private OptimizedClassMatcherBuilder() {
    }

    public static OptimizedClassMatcherBuilder newBuilder() {
        return new OptimizedClassMatcherBuilder();
    }

    public OptimizedClassMatcherBuilder addClassMethodMatcher(ClassAndMethodMatcher ... matchers) {
        for (ClassAndMethodMatcher matcher : matchers) {
            Method[] exactMethods;
            if (this.exactClassMatch && !matcher.getClassMatcher().isExactClassMatcher()) {
                this.exactClassMatch = false;
            } else {
                this.exactClassNames.addAll(matcher.getClassMatcher().getClassNames());
            }
            if (matcher.getMethodMatcher() instanceof AnnotationMethodMatcher) {
                this.methodAnnotationMatchers.add(((AnnotationMethodMatcher)matcher.getMethodMatcher()).getAnnotationType().getDescriptor());
            }
            if ((exactMethods = matcher.getMethodMatcher().getExactMethods()) == null || exactMethods.length == 0) {
                this.methodMatchers.put(matcher.getMethodMatcher(), matcher);
                continue;
            }
            for (Method m : exactMethods) {
                if (OptimizedClassMatcher.METHODS_WE_NEVER_INSTRUMENT.contains(m)) {
                    Agent.LOG.severe("Skipping method matcher for method " + m);
                    Agent.LOG.fine("Skipping matcher for class matcher " + matcher.getClassMatcher());
                    continue;
                }
                if (OptimizedClassMatcher.DEFAULT_CONSTRUCTOR.equals(m)) {
                    Agent.LOG.severe("Instrumentation is matching a default constructor.  This may result in slow class loading times.");
                    Agent.LOG.debug("No arg constructor matcher: " + matcher.getClassMatcher());
                }
                this.methods.put(m, matcher);
            }
        }
        return this;
    }

    public ClassMatchVisitorFactory build() {
        if (this.methodMatchers.isEmpty() && this.methods.isEmpty() && this.methodAnnotationMatchers.isEmpty()) {
            Agent.LOG.finest("Creating an empty class/method matcher");
            return OptimizedClassMatcher.EMPTY_MATCHER;
        }
        Set<String> exactClassNames = null;
        if (this.exactClassMatch) {
            exactClassNames = this.exactClassNames;
        }
        return new OptimizedClassMatcher(this.methodAnnotationMatchers, this.methods, this.methodMatchers, exactClassNames);
    }
}

