/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.v2;

import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.cache.CacheLoader;
import com.newrelic.agent.deps.com.google.common.cache.LoadingCache;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.metric.MetricName;
import com.newrelic.agent.profile.v2.DiscoveryProfile;
import com.newrelic.agent.profile.v2.Profile;
import com.newrelic.agent.profile.v2.ProfileTree;
import com.newrelic.agent.profile.v2.TransactionActivityTree;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.threads.BasicThreadInfo;
import com.newrelic.agent.threads.ThreadNameNormalizer;
import com.newrelic.agent.tracers.Tracer;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

class TransactionProfile
implements JSONStreamAware {
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final LoadingCache<String, ProfileTree> threadProfiles;
    private final LoadingCache<String, TransactionActivityTree> threadActivityProfiles;
    private final ThreadNameNormalizer threadNameNormalizer;

    public TransactionProfile(final Profile profile, ThreadNameNormalizer threadNameNormalizer) {
        this.threadNameNormalizer = threadNameNormalizer;
        this.threadProfiles = CacheBuilder.newBuilder().build(profile.createCacheLoader(false));
        this.threadActivityProfiles = CacheBuilder.newBuilder().build(new CacheLoader<String, TransactionActivityTree>(){

            @Override
            public TransactionActivityTree load(String threadName) throws Exception {
                return new TransactionActivityTree(profile);
            }
        });
    }

    public void addStackTrace(List<StackTraceElement> stackTraceList) {
        String threadName = this.threadNameNormalizer.getNormalizedThreadName(new BasicThreadInfo(Thread.currentThread()));
        ((ProfileTree)this.threadProfiles.getIfPresent(threadName)).addStackTrace(stackTraceList, true);
    }

    public void transactionFinished(TransactionData transactionData) {
        final ArrayList<MetricNameTime> cpuTimes = new ArrayList<MetricNameTime>();
        for (TransactionActivity activity : transactionData.getTransactionActivities()) {
            long cpuTime;
            ThreadInfo threadInfo = this.threadMXBean.getThreadInfo(activity.getThreadId(), 0);
            if (null == threadInfo) continue;
            ArrayList<List<StackTraceElement>> backtraces = new ArrayList<List<StackTraceElement>>();
            Map<Tracer, Collection<Tracer>> tracerTree = TransactionProfile.buildChildren(activity.getTracers(), backtraces);
            String threadName = this.threadNameNormalizer.getNormalizedThreadName(new BasicThreadInfo(threadInfo));
            this.threadActivityProfiles.getUnchecked(threadName).add(activity, tracerTree);
            if (!backtraces.isEmpty()) {
                ProfileTree tree = this.threadProfiles.getUnchecked(threadName);
                for (List<StackTraceElement> stack : backtraces) {
                    stack = DiscoveryProfile.getScrubbedStackTrace((Collection<StackTraceElement>)stack);
                    Collections.reverse(stack);
                    tree.addStackTrace(stack, true);
                }
            }
            if ((cpuTime = activity.getTotalCpuTime()) <= 0L) continue;
            MetricName name = MetricName.create(transactionData.getBlameMetricName(), threadName);
            cpuTimes.add(new MetricNameTime(name, cpuTime));
        }
        if (!cpuTimes.isEmpty()) {
            ServiceFactory.getStatsService().doStatsWork(new StatsWork(){

                @Override
                public void doWork(StatsEngine statsEngine) {
                    for (MetricNameTime time : cpuTimes) {
                        statsEngine.getResponseTimeStats(time.name).recordResponseTime(time.cpuTime, TimeUnit.NANOSECONDS);
                    }
                }

                @Override
                public String getAppName() {
                    return null;
                }
            });
        }
    }

    public static Map<Tracer, Collection<Tracer>> buildChildren(Collection<Tracer> tracers, List<List<StackTraceElement>> backtraces) {
        if (tracers == null || tracers.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Tracer, Collection<Tracer>> children = new HashMap<Tracer, Collection<Tracer>>();
        for (Tracer tracer : tracers) {
            Tracer parentTracer;
            ArrayList<Tracer> kids;
            List backtrace = (List)tracer.getAgentAttribute("backtrace");
            if (null != backtrace) {
                backtraces.add(backtrace);
            }
            if ((kids = (ArrayList<Tracer>)children.get(parentTracer = tracer.getParentTracer())) == null) {
                kids = new ArrayList<Tracer>(parentTracer == null ? 1 : Math.max(1, parentTracer.getChildCount()));
                children.put(parentTracer, kids);
            }
            kids.add(tracer);
        }
        return children;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        ImmutableMap<String, ConcurrentMap<String, TransactionActivityTree>> map = ImmutableMap.of("stack_traces", this.threadProfiles.asMap(), "activity_traces", this.threadActivityProfiles.asMap());
        JSONObject.writeJSONString(map, out);
    }

    private final class MetricNameTime {
        private final MetricName name;
        private final long cpuTime;

        public MetricNameTime(MetricName name, long cpuTime) {
            this.name = name;
            this.cpuTime = cpuTime;
        }
    }
}

