/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.v2;

import com.newrelic.agent.ThreadService;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.cache.CacheLoader;
import com.newrelic.agent.deps.com.google.common.cache.LoadingCache;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.profile.ThreadType;
import com.newrelic.agent.profile.v2.DiscoveryProfile;
import com.newrelic.agent.profile.v2.Profile;
import com.newrelic.agent.profile.v2.TransactionProfile;
import com.newrelic.agent.profile.v2.TransactionProfileService;
import com.newrelic.agent.profile.v2.TransactionProfileSession;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.threads.BasicThreadInfo;
import com.newrelic.agent.threads.ThreadNameNormalizer;
import com.newrelic.agent.tracers.IgnoreChildSocketCalls;
import com.newrelic.agent.tracers.Tracer;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TransactionProfileSessionImpl
implements TransactionProfileSession {
    static final TransactionProfileService NO_OP_TRANSACTION_PROFILE_SERVICE = new TransactionProfileService(){

        @Override
        public boolean isTransactionProfileSessionActive() {
            return false;
        }

        @Override
        public TransactionProfileSession getTransactionProfileSession() {
            return NO_OP_TRANSACTION_PROFILE_SESSION;
        }
    };
    static final TransactionProfileSession NO_OP_TRANSACTION_PROFILE_SESSION = new TransactionProfileSession(){

        @Override
        public void writeJSONString(Writer out) throws IOException {
            JSONObject.writeJSONString(ImmutableMap.of(), out);
        }

        @Override
        public void transactionFinished(TransactionData transactionData) {
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public void noticeTracerStart(int signatureId, int tracerFlags, Tracer tracer) {
        }
    };
    private static final int STACK_CAPTURE_LIMIT_PER_METRIC_PER_PERIOD = 5;
    private final ThreadService threadService;
    private final LoadingCache<String, TransactionProfile> transactionProfileTrees;
    private final DiscoveryProfile discoveryProfile;
    private final LoadingCache<String, AtomicInteger> stackTraceLimits;
    private final Profile profile;

    public TransactionProfileSessionImpl(Profile profile, ThreadNameNormalizer threadNameNormalizer) {
        this(profile, threadNameNormalizer, ServiceFactory.getThreadService());
    }

    protected TransactionProfileSessionImpl(final Profile profile, final ThreadNameNormalizer threadNameNormalizer, ThreadService threadService) {
        this.threadService = threadService;
        this.profile = profile;
        this.transactionProfileTrees = CacheBuilder.newBuilder().build(new CacheLoader<String, TransactionProfile>(){

            @Override
            public TransactionProfile load(String transactionName) throws Exception {
                return new TransactionProfile(profile, threadNameNormalizer);
            }
        });
        this.discoveryProfile = new DiscoveryProfile(profile, threadNameNormalizer);
        this.stackTraceLimits = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build(new CacheLoader<String, AtomicInteger>(){

            @Override
            public AtomicInteger load(String metricName) throws Exception {
                return new AtomicInteger(0);
            }
        });
    }

    @Override
    public void transactionFinished(TransactionData transactionData) {
        TransactionProfile txProfile = this.transactionProfileTrees.getUnchecked(transactionData.getBlameMetricName());
        txProfile.transactionFinished(transactionData);
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        ImmutableMap<String, DiscoveryProfile> map = ImmutableMap.of("transactions", this.transactionProfileTrees.asMap(), "discovery", this.discoveryProfile);
        JSONObject.writeJSONString(map, out);
    }

    @Override
    public void noticeTracerStart(int signatureId, int tracerFlags, Tracer tracer) {
        if (!this.threadService.isCurrentThreadAnAgentThread()) {
            if (tracer == null) {
                this.discoveryProfile.noticeStartTracer(signatureId);
                Thread currentThread = Thread.currentThread();
                this.profile.addStackTrace(new BasicThreadInfo(currentThread), currentThread.getStackTrace(), true, ThreadType.BasicThreadType.OTHER);
            } else if ((tracer.isLeaf() || tracer instanceof IgnoreChildSocketCalls) && this.stackTraceLimits.getUnchecked(tracer.getMetricName()).getAndIncrement() < 5) {
                tracer.setAgentAttribute("backtrace", Thread.currentThread().getStackTrace());
            }
        }
    }

    @Override
    public boolean isActive() {
        return !ServiceFactory.getServiceManager().getCircuitBreakerService().isTripped();
    }
}

