/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.service.ServiceFactory;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class StackTraces {
    private StackTraces() {
    }

    public static StackTraceElement[] getThreadStackTraceElements(long threadId) {
        ThreadInfo threadInfo = ManagementFactory.getThreadMXBean().getThreadInfo(threadId, Integer.MAX_VALUE);
        if (threadInfo == null) {
            return null;
        }
        return threadInfo.getStackTrace();
    }

    public static Exception createStackTraceException(String message) {
        StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
        return StackTraces.createStackTraceException(message, stackTraces, true);
    }

    public static Exception createStackTraceException(String message, StackTraceElement[] stackTraces, boolean scrub) {
        return StackTraces.createStackTraceException(new Exception(message), stackTraces, scrub);
    }

    public static Exception createStackTraceException(Exception e, StackTraceElement[] stackTraces, boolean scrub) {
        List<StackTraceElement> scrubbedTrace = scrub ? StackTraces.scrubAndTruncate(stackTraces) : Arrays.asList(stackTraces);
        e.setStackTrace(scrubbedTrace.toArray(new StackTraceElement[0]));
        return e;
    }

    public static List<String> toStringList(List<StackTraceElement> stackElements) {
        ArrayList<String> stringList = new ArrayList<String>(stackElements.size());
        for (StackTraceElement element : stackElements) {
            stringList.add(element.toString());
        }
        return stringList;
    }

    public static List<String> toStringListRemoveParent(List<StackTraceElement> stackElements, List<StackTraceElement> parentBacktrace) {
        StackTraceElement current;
        if (parentBacktrace == null || parentBacktrace.size() <= 1) {
            return StackTraces.toStringList(stackElements);
        }
        if ((parentBacktrace = StackTraces.scrubAndTruncate(parentBacktrace)) == null || parentBacktrace.size() <= 1) {
            return StackTraces.toStringList(stackElements);
        }
        StackTraceElement parentLatestFirst = parentBacktrace.get(0);
        StackTraceElement parentLatestSecond = parentBacktrace.get(1);
        ArrayList<String> stringList = new ArrayList<String>();
        int currentLength = stackElements.size();
        for (int i = 0; !(i >= currentLength || StackTraces.isSameClassAndMethod(current = stackElements.get(i), parentLatestFirst) && i + 1 < currentLength && stackElements.get(i + 1).equals(parentLatestSecond)); ++i) {
            stringList.add(current.toString());
        }
        return stringList;
    }

    protected static boolean isSameClassAndMethod(StackTraceElement one, StackTraceElement two) {
        if (one == two) {
            return true;
        }
        return one.getClassName().equals(two.getClassName()) && one.getMethodName().equals(two.getMethodName());
    }

    public static List<StackTraceElement> scrubAndTruncate(StackTraceElement[] stackTraces) {
        return StackTraces.scrubAndTruncate(Arrays.asList(stackTraces));
    }

    public static List<StackTraceElement> scrubAndTruncate(List<StackTraceElement> stackTraces) {
        return StackTraces.scrubAndTruncate(stackTraces, ServiceFactory.getConfigService().getDefaultAgentConfig().getMaxStackTraceLines());
    }

    public static List<StackTraceElement> scrubAndTruncate(List<StackTraceElement> stackTraces, int maxStackTraceLines) {
        List<StackTraceElement> trimmedList = StackTraces.scrub(stackTraces);
        return maxStackTraceLines > 0 ? StackTraces.truncateStack(trimmedList, maxStackTraceLines) : trimmedList;
    }

    public static List<StackTraceElement> scrub(List<StackTraceElement> stackTraces) {
        for (int i = stackTraces.size() - 1; i >= 0; --i) {
            StackTraceElement element = stackTraces.get(i);
            if (!element.getClassName().startsWith("com.newrelic.agent.") && !element.getClassName().startsWith("com.newrelic.bootstrap.") && !element.getClassName().startsWith("com.newrelic.api.agent.") && !element.getClassName().startsWith("com.newrelic.weave.") && !element.getClassName().startsWith("com.nr.agent.instrumentation.") && (!"getAgentHandle".equals(element.getMethodName()) || !"java.lang.reflect.Proxy".equals(element.getClassName()))) continue;
            return stackTraces.subList(i + 1, stackTraces.size());
        }
        return stackTraces;
    }

    public static List<StackTraceElement> last(StackTraceElement[] elements, int count) {
        List<StackTraceElement> list = Arrays.asList(elements);
        if (list.size() <= count) {
            return list;
        }
        return list.subList(list.size() - count, list.size());
    }

    static List<StackTraceElement> truncateStack(List<StackTraceElement> elements, int maxDepth) {
        if (elements.size() <= maxDepth) {
            return elements;
        }
        int bottomLimit = Double.valueOf(Math.floor(maxDepth / 3)).intValue();
        int topLimit = maxDepth - bottomLimit;
        List<StackTraceElement> topStack = elements.subList(0, topLimit);
        List<StackTraceElement> bottomStack = elements.subList(elements.size() - bottomLimit, elements.size());
        int skipCount = elements.size() - bottomLimit - topLimit;
        elements = new ArrayList<StackTraceElement>(maxDepth + 1);
        elements.addAll(topStack);
        elements.add(new StackTraceElement("Skipping " + skipCount + " lines...", "", "", 0));
        elements.addAll(bottomStack);
        return elements;
    }

    public static Throwable getRootCause(Throwable throwable) {
        return throwable.getCause() == null ? throwable : throwable.getCause();
    }

    public static Collection<String> stackTracesToStrings(StackTraceElement[] stackTraces) {
        if (stackTraces == null || stackTraces.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> lines = new ArrayList<String>(stackTraces.length);
        for (StackTraceElement e : stackTraces) {
            lines.add('\t' + e.toString());
        }
        return lines;
    }

    public static boolean isInAgentInstrumentation(StackTraceElement[] stackTrace) {
        for (StackTraceElement element : stackTrace) {
            if (!element.getClassName().startsWith("com.newrelic.agent.") && !element.getClassName().startsWith("com.newrelic.weave.")) continue;
            return true;
        }
        return false;
    }
}

