/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.bootstrap;

import com.newrelic.agent.config.IBMUtils;
import com.newrelic.agent.config.JavaVersionUtils;
import com.newrelic.agent.modules.ClassLoaderUtilImpl;
import com.newrelic.agent.modules.ModuleUtilImpl;
import com.newrelic.bootstrap.BootstrapLoader;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Collection;

public class BootstrapAgent {
    private static final String AGENT_CLASS_NAME = "com.newrelic.agent.Agent";
    private static final String JAVA_LOG_MANAGER = "java.util.logging.manager";
    private static final String WS_SERVER_JAR = "ws-server.jar";
    private static final String WS_LOG_MANAGER = "com.ibm.ws.kernel.boot.logging.WsLogManager";
    private static final String IBM_VENDOR = "IBM";

    public static URL getAgentJarUrl() {
        return BootstrapAgent.class.getProtectionDomain().getCodeSource().getLocation();
    }

    public static void main(String[] args) {
        try {
            Collection<URL> urls = BootstrapLoader.getJarURLs();
            urls.add(BootstrapAgent.getAgentJarUrl());
            URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[0]), null);
            Class<?> agentClass = classLoader.loadClass(AGENT_CLASS_NAME);
            Method main = agentClass.getDeclaredMethod("main", String[].class);
            main.invoke(null, new Object[]{args});
        }
        catch (Throwable t) {
            System.err.println(MessageFormat.format("Error invoking the New Relic command: {0}", t));
            t.printStackTrace();
        }
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        String javaSpecVersion = JavaVersionUtils.getJavaSpecificationVersion();
        if (!JavaVersionUtils.isAgentSupportedJavaSpecVersion(javaSpecVersion)) {
            System.err.println("----------");
            System.err.println(JavaVersionUtils.getUnsupportedAgentJavaSpecVersionMessage(javaSpecVersion));
            System.err.println("----------");
            return;
        }
        String sysPropEnabled = System.getProperty("newrelic.config.agent_enabled");
        String envVarEnabled = System.getenv("NEW_RELIC_AGENT_ENABLED");
        if (sysPropEnabled != null && !Boolean.parseBoolean(sysPropEnabled)) {
            System.err.println("----------");
            System.err.println("New Relic Agent is disabled by -Dnewrelic.config.agent_enabled system property.");
            System.err.println("----------");
            return;
        }
        if (envVarEnabled != null && !Boolean.parseBoolean(envVarEnabled)) {
            System.err.println("----------");
            System.err.println("New Relic Agent is disabled by NEW_RELIC_AGENT_ENABLED environment variable.");
            System.err.println("----------");
            return;
        }
        BootstrapAgent.checkAndApplyIBMLibertyProfileLogManagerWorkaround();
        BootstrapAgent.startAgent(agentArgs, inst);
    }

    private static void checkAndApplyIBMLibertyProfileLogManagerWorkaround() {
        String javaClassPath;
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor != null && javaVendor.startsWith(IBM_VENDOR) && (javaClassPath = System.getProperty("java.class.path")) != null && javaClassPath.contains(WS_SERVER_JAR) && System.getProperty(JAVA_LOG_MANAGER) == null) {
            try {
                Class.forName(WS_LOG_MANAGER, false, BootstrapAgent.class.getClassLoader());
                System.setProperty(JAVA_LOG_MANAGER, WS_LOG_MANAGER);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void startAgent(String agentArgs, Instrumentation inst) {
        try {
            ClassLoader classLoader;
            long startTime = System.currentTimeMillis();
            String javaVersion = System.getProperty("java.version", "");
            BootstrapLoader.load(inst, BootstrapAgent.isJavaSqlLoadedOnPlatformClassLoader(javaVersion));
            boolean ibmWorkaround = IBMUtils.getIbmWorkaroundDefault();
            if (System.getProperty("ibm_iv25688_workaround") != null) {
                ibmWorkaround = Boolean.parseBoolean(System.getProperty("ibm_iv25688_workaround"));
            }
            if (ibmWorkaround) {
                classLoader = ClassLoader.getSystemClassLoader();
            } else {
                URL[] codeSource;
                ClassLoader agentClassLoaderParent = BootstrapAgent.getPlatformClassLoaderOrNull();
                if (BootstrapAgent.isJavaSqlLoadedOnPlatformClassLoader(javaVersion)) {
                    URL url = BootstrapLoader.getDatastoreJarURL();
                    codeSource = new URL[]{BootstrapAgent.getAgentJarUrl(), url};
                } else {
                    codeSource = new URL[]{BootstrapAgent.getAgentJarUrl()};
                }
                classLoader = new JVMAgentClassLoader(codeSource, agentClassLoaderParent);
                BootstrapAgent.exportModulesToUnnamedModule(inst, classLoader);
            }
            Class<?> agentClass = classLoader.loadClass(AGENT_CLASS_NAME);
            Method continuePremain = agentClass.getDeclaredMethod("continuePremain", String.class, Instrumentation.class, Long.TYPE);
            continuePremain.invoke(null, agentArgs, inst, startTime);
        }
        catch (Throwable t) {
            System.err.println(MessageFormat.format("Error bootstrapping New Relic agent: {0}", t));
            t.printStackTrace();
        }
    }

    private static ClassLoader getPlatformClassLoaderOrNull() {
        try {
            ClassLoaderUtilImpl util = new ClassLoaderUtilImpl();
            return util.getPlatformClassLoaderOrNull();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static void exportModulesToUnnamedModule(Instrumentation inst, ClassLoader agentClassLoader) {
        try {
            ModuleUtilImpl util = new ModuleUtilImpl();
            util.redefineModules(inst, agentClassLoader);
        }
        catch (Throwable t) {
            System.err.println("The agent failed to redefine modules as necessary. " + t);
        }
    }

    private static boolean isJavaSqlLoadedOnPlatformClassLoader(String javaVersion) {
        return !javaVersion.startsWith("1.");
    }

    private static class JVMAgentClassLoader
    extends URLClassLoader {
        public JVMAgentClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        static {
            try {
                JVMAgentClassLoader.registerAsParallelCapable();
            }
            catch (Throwable t) {
                System.err.println(MessageFormat.format("Unable to register as parallel-capable: {0}", t));
            }
        }
    }
}

