/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.database;

import com.newrelic.agent.Agent;
import com.newrelic.agent.database.DefaultDatabaseStatementParser;
import com.newrelic.agent.database.ParsedDatabaseStatement;
import com.newrelic.agent.database.StatementFactory;
import com.newrelic.agent.deps.org.apache.commons.lang3.StringUtils;
import com.newrelic.agent.util.Strings;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DefaultStatementFactory
implements StatementFactory {
    private final Pattern pattern;
    private final DefaultStatementFactory backupPattern;
    protected final String key;
    private final boolean generateMetric;

    public DefaultStatementFactory(String key, Pattern pattern, boolean generateMetric) {
        this.key = key;
        this.pattern = pattern;
        this.generateMetric = generateMetric;
        this.backupPattern = null;
    }

    public DefaultStatementFactory(String key, Pattern pattern, boolean generateMetric, Pattern backupPattern) {
        this.key = key;
        this.pattern = pattern;
        this.generateMetric = generateMetric;
        this.backupPattern = new DefaultStatementFactory(key, backupPattern, generateMetric);
    }

    protected boolean isMetricGenerator() {
        return this.generateMetric;
    }

    @Override
    public ParsedDatabaseStatement parseStatement(String statement) {
        if (!StringUtils.containsIgnoreCase(statement, this.key)) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(statement);
        if (matcher.find()) {
            String model;
            String string = model = matcher.groupCount() > 0 ? matcher.group(1).trim() : "unknown";
            if (model.length() == 0) {
                Agent.LOG.log(Level.FINE, MessageFormat.format("Parsed an empty model name for {0} statement : {1}", this.key, statement));
                return null;
            }
            model = Strings.unquoteDatabaseName(model);
            model = Strings.removeBrackets(model);
            if (this.generateMetric && !this.isValidModelName(model)) {
                if (Agent.LOG.isFineEnabled()) {
                    Agent.LOG.log(Level.FINE, "Parsed an invalid model name {0} for {1} statement : {2}", model, this.key, statement);
                }
                model = "ParseError";
            }
            return this.createParsedDatabaseStatement(model);
        }
        if (this.backupPattern != null) {
            return this.backupPattern.parseStatement(statement);
        }
        return null;
    }

    protected boolean isValidModelName(String name) {
        return DefaultDatabaseStatementParser.isValidName(name);
    }

    ParsedDatabaseStatement createParsedDatabaseStatement(String model) {
        return new ParsedDatabaseStatement(model.toLowerCase(), this.key, this.generateMetric);
    }

    @Override
    public String getOperation() {
        return this.key;
    }
}

