/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ExtendedTransactionListener;
import com.newrelic.agent.Harvestable;
import com.newrelic.agent.MetricNames;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.attributes.AttributeSender;
import com.newrelic.agent.attributes.AttributeValidator;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Caffeine;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.LoadingCache;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.model.AnalyticsEvent;
import com.newrelic.agent.model.CustomInsightsEvent;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.DistributedSamplingPriorityQueue;
import com.newrelic.agent.service.analytics.InsightsHarvestableImpl;
import com.newrelic.agent.service.analytics.InsightsService;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracing.DistributedTraceServiceImpl;
import com.newrelic.agent.transport.HttpError;
import com.newrelic.api.agent.Insights;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class InsightsServiceImpl
extends AbstractService
implements InsightsService {
    private volatile boolean enabled;
    private final ConcurrentMap<String, Boolean> isEnabledForApp = new ConcurrentHashMap<String, Boolean>();
    private volatile int maxSamplesStored;
    private final ConcurrentHashMap<String, DistributedSamplingPriorityQueue<CustomInsightsEvent>> reservoirForApp = new ConcurrentHashMap();
    private static final LoadingCache<String, String> stringCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterAccess(70L, TimeUnit.SECONDS).executor(Runnable::run).build(key -> key);
    protected final ExtendedTransactionListener transactionListener = new ExtendedTransactionListener(){

        @Override
        public void dispatcherTransactionStarted(Transaction transaction) {
        }

        @Override
        public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
            TransactionInsights data = (TransactionInsights)transactionData.getInsightsData();
            InsightsServiceImpl.this.storeEvents(transactionData.getApplicationName(), transactionData.getPriority(), data.events);
        }

        @Override
        public void dispatcherTransactionCancelled(Transaction transaction) {
            TransactionInsights data = (TransactionInsights)transaction.getInsightsData();
            InsightsServiceImpl.this.storeEvents(transaction.getApplicationName(), transaction.getPriority(), data.events);
        }
    };
    protected final AgentConfigListener configListener = new AgentConfigListener(){

        @Override
        public void configChanged(String appName, AgentConfig agentConfig) {
            InsightsServiceImpl.this.isEnabledForApp.remove(appName);
            InsightsServiceImpl.this.enabled = agentConfig.getInsightsConfig().isEnabled();
        }
    };
    private List<Harvestable> harvestables = new ArrayList<Harvestable>();

    public InsightsServiceImpl() {
        super("Insights");
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.maxSamplesStored = config.getInsightsConfig().getMaxSamplesStored();
        this.enabled = config.getInsightsConfig().isEnabled();
        this.isEnabledForApp.put(config.getApplicationName(), this.enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceFactory.getTransactionService().addTransactionListener(this.transactionListener);
        ServiceFactory.getConfigService().addIAgentConfigListener(this.configListener);
    }

    @Override
    protected void doStop() throws Exception {
        this.removeHarvestables();
        ServiceFactory.getTransactionService().removeTransactionListener(this.transactionListener);
        ServiceFactory.getConfigService().removeIAgentConfigListener(this.configListener);
        this.reservoirForApp.clear();
        this.isEnabledForApp.clear();
        stringCache.invalidateAll();
    }

    private void removeHarvestables() {
        for (Harvestable harvestable : this.harvestables) {
            ServiceFactory.getHarvestService().removeHarvestable(harvestable);
        }
    }

    public void recordCustomEvent(String eventType, Map<String, ?> attributes) {
        if (this.customEventsDisabled(eventType)) {
            return;
        }
        if (AnalyticsEvent.isValidType(eventType)) {
            Transaction transaction = ServiceFactory.getTransactionService().getTransaction(false);
            if (transaction == null || !transaction.isInProgress() || transaction.isIgnore()) {
                AgentConfig agentConfig;
                String applicationName = ServiceFactory.getRPMService().getApplicationName();
                if (transaction != null && transaction.getApplicationName() != null) {
                    applicationName = transaction.getApplicationName();
                }
                if (!this.getIsEnabledForApp(agentConfig = ServiceFactory.getConfigService().getAgentConfig(applicationName), applicationName)) {
                    this.reservoirForApp.remove(applicationName);
                    return;
                }
                this.storeEvent(applicationName, eventType, attributes);
            } else {
                transaction.getInsightsData().recordCustomEvent(eventType, attributes);
            }
            MetricNames.recordApiSupportabilityMetric("RecordCustomEvent");
        } else {
            Agent.LOG.log(Level.WARNING, "Custom event with invalid type of {0} was reported but ignored. Event types must match /^[a-zA-Z0-9:_ ]+$/, be non-null, and less than 256 chars.", eventType);
        }
    }

    private void storeEvents(String appName, float priority, Collection<CustomInsightsEvent> events) {
        if (events.size() > 0) {
            DistributedSamplingPriorityQueue<CustomInsightsEvent> eventList = this.getReservoir(appName);
            for (CustomInsightsEvent event : events) {
                event.setPriority(priority);
                eventList.add(event);
            }
        }
    }

    @Override
    public void addHarvestableToService(String appName) {
        InsightsHarvestableImpl harvestable = new InsightsHarvestableImpl(this, appName);
        ServiceFactory.getHarvestService().addHarvestable(harvestable);
        this.harvestables.add(harvestable);
    }

    @Override
    public int getMaxSamplesStored() {
        return this.maxSamplesStored;
    }

    @Override
    public void setMaxSamplesStored(int maxSamplesStored) {
        this.maxSamplesStored = maxSamplesStored;
    }

    @Override
    public void clearReservoir() {
        this.reservoirForApp.clear();
    }

    public void clearReservoir(String appName) {
        DistributedSamplingPriorityQueue<CustomInsightsEvent> reservoir = this.reservoirForApp.get(appName);
        if (reservoir != null) {
            reservoir.clear();
        }
    }

    @VisibleForTesting
    void configureHarvestables(long reportPeriodInMillis, int maxSamplesStored) {
        for (Harvestable h2 : this.harvestables) {
            h2.configure(reportPeriodInMillis, maxSamplesStored);
        }
    }

    @VisibleForTesting
    public void harvestHarvestables() {
        for (Harvestable h2 : this.harvestables) {
            h2.harvest();
        }
    }

    public void harvestPendingEvents() {
        for (String appName : this.reservoirForApp.keySet()) {
            this.harvestEvents(appName);
        }
    }

    @Override
    public void storeEvent(String appName, CustomInsightsEvent event) {
        if (this.customEventsDisabled(event.getType())) {
            return;
        }
        DistributedSamplingPriorityQueue<CustomInsightsEvent> eventList = this.getReservoir(appName);
        eventList.add(event);
        Agent.LOG.finest(MessageFormat.format("Added Custom Event of type {0}", event.getType()));
    }

    private void storeEvent(String appName, String eventType, Map<String, ?> attributes) {
        if (this.customEventsDisabled(eventType)) {
            return;
        }
        DistributedSamplingPriorityQueue<CustomInsightsEvent> eventList = this.getReservoir(appName);
        eventList.add(InsightsServiceImpl.createValidatedEvent(eventType, attributes));
        Agent.LOG.finest(MessageFormat.format("Added Custom Event of type {0}", eventType));
    }

    private boolean customEventsDisabled(String eventType) {
        if (!this.enabled) {
            if (ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
                Agent.LOG.log(Level.FINER, "Event of type {0} not collected due to high security mode being enabled.", eventType);
            } else {
                Agent.LOG.log(Level.FINER, "Event of type {0} not collected. custom_insights_events not enabled.", eventType);
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public DistributedSamplingPriorityQueue<CustomInsightsEvent> getReservoir(String appName) {
        DistributedSamplingPriorityQueue<CustomInsightsEvent> result = this.reservoirForApp.get(appName);
        while (result == null) {
            this.reservoirForApp.putIfAbsent(appName, new DistributedSamplingPriorityQueue(appName, "Insights Service", this.maxSamplesStored));
            result = this.reservoirForApp.get(appName);
        }
        return result;
    }

    @Override
    public void harvestEvents(final String appName) {
        if (!this.getIsEnabledForApp(ServiceFactory.getConfigService().getAgentConfig(appName), appName)) {
            this.reservoirForApp.remove(appName);
            return;
        }
        if (this.maxSamplesStored <= 0) {
            this.clearReservoir(appName);
            return;
        }
        long startTimeInNanos = System.nanoTime();
        final DistributedSamplingPriorityQueue reservoir = this.reservoirForApp.put(appName, new DistributedSamplingPriorityQueue(appName, "Insights Service", this.maxSamplesStored));
        if (reservoir != null && reservoir.size() > 0) {
            try {
                ServiceFactory.getRPMServiceManager().getOrCreateRPMService(appName).sendCustomAnalyticsEvents(this.maxSamplesStored, reservoir.getNumberOfTries(), Collections.unmodifiableList(reservoir.asList()));
                final long durationInNanos = System.nanoTime() - startTimeInNanos;
                ServiceFactory.getStatsService().doStatsWork(new StatsWork(){

                    @Override
                    public void doWork(StatsEngine statsEngine) {
                        InsightsServiceImpl.this.recordSupportabilityMetrics(statsEngine, durationInNanos, reservoir);
                    }

                    @Override
                    public String getAppName() {
                        return appName;
                    }
                }, reservoir.getServiceName());
                if (reservoir.size() < reservoir.getNumberOfTries()) {
                    int dropped = reservoir.getNumberOfTries() - reservoir.size();
                    Agent.LOG.log(Level.FINE, "Dropped {0} custom events out of {1}.", dropped, reservoir.getNumberOfTries());
                }
            }
            catch (HttpError e) {
                if (!e.discardHarvestData()) {
                    Agent.LOG.log(Level.FINE, "Unable to send custom events. Unsent events will be included in the next harvest.", e);
                    DistributedSamplingPriorityQueue<CustomInsightsEvent> currentReservoir = this.reservoirForApp.get(appName);
                    currentReservoir.retryAll(reservoir);
                } else {
                    reservoir.clear();
                    Agent.LOG.log(Level.FINE, "Unable to send custom events. Unsent events will be dropped.", e);
                }
            }
            catch (Exception e) {
                reservoir.clear();
                Agent.LOG.log(Level.FINE, "Unable to send custom events. Unsent events will be dropped.", e);
            }
        }
    }

    @Override
    public String getEventHarvestIntervalMetric() {
        return "Supportability/EventHarvest/Customer/interval";
    }

    @Override
    public String getReportPeriodInSecondsMetric() {
        return "Supportability/EventHarvest/CustomEventData/ReportPeriod";
    }

    @Override
    public String getEventHarvestLimitMetric() {
        return "Supportability/EventHarvest/CustomEventData/HarvestLimit";
    }

    private void recordSupportabilityMetrics(StatsEngine statsEngine, long durationInNanoseconds, DistributedSamplingPriorityQueue<CustomInsightsEvent> reservoir) {
        statsEngine.getStats("Supportability/Events/Customer/Sent").incrementCallCount(reservoir.size());
        statsEngine.getStats("Supportability/Events/Customer/Seen").incrementCallCount(reservoir.getNumberOfTries());
        statsEngine.getResponseTimeStats("Supportability/EventHarvest/Customer/transmit").recordResponseTime(durationInNanoseconds, TimeUnit.NANOSECONDS);
    }

    private boolean getIsEnabledForApp(AgentConfig config, String currentAppName) {
        Boolean appEnabled;
        Boolean bl = appEnabled = currentAppName == null ? null : (Boolean)this.isEnabledForApp.get(currentAppName);
        if (appEnabled == null) {
            appEnabled = config.getInsightsConfig().isEnabled();
            this.isEnabledForApp.put(currentAppName, appEnabled);
        }
        return appEnabled;
    }

    private static String mapInternString(String value) {
        return stringCache.get(value);
    }

    private static CustomInsightsEvent createValidatedEvent(String eventType, Map<String, ?> attributes) {
        HashMap<String, Object> userAttributes = new HashMap<String, Object>(attributes.size());
        CustomInsightsEvent event = new CustomInsightsEvent(InsightsServiceImpl.mapInternString(eventType), System.currentTimeMillis(), userAttributes, DistributedTraceServiceImpl.nextTruncatedFloat());
        CustomEventAttributeSender sender = new CustomEventAttributeSender(userAttributes);
        String method = "add custom event attribute";
        for (Map.Entry<String, ?> entry : attributes.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) {
                Agent.LOG.log(Level.WARNING, "Custom event with invalid attributes key or value of null was reported for a transaction but ignored. Each key should be a String and each value should be a String, Number, or Boolean.");
                continue;
            }
            InsightsServiceImpl.mapInternString(key);
            if (value instanceof String) {
                sender.addAttribute(key, InsightsServiceImpl.mapInternString((String)value), "add custom event attribute");
                continue;
            }
            if (value instanceof Number) {
                sender.addAttribute(key, (Number)value, "add custom event attribute");
                continue;
            }
            if (value instanceof Boolean) {
                sender.addAttribute(key, (Boolean)value, "add custom event attribute");
                continue;
            }
            sender.addAttribute(key, InsightsServiceImpl.mapInternString(value.toString()), "add custom event attribute");
        }
        return event;
    }

    @Override
    public Insights getTransactionInsights(AgentConfig config) {
        return new TransactionInsights(config);
    }

    public static final class TransactionInsights
    implements Insights {
        final LinkedBlockingQueue<CustomInsightsEvent> events;

        TransactionInsights(AgentConfig config) {
            int maxSamplesStored = config.getInsightsConfig().getMaxSamplesStored();
            this.events = new LinkedBlockingQueue(maxSamplesStored);
        }

        public void recordCustomEvent(String eventType, Map<String, ?> attributes) {
            if (ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity()) {
                Agent.LOG.log(Level.FINER, "Event of type {0} not collected due to high security mode being enabled.", eventType);
                return;
            }
            if (AnalyticsEvent.isValidType(eventType)) {
                CustomInsightsEvent event = InsightsServiceImpl.createValidatedEvent(eventType, attributes);
                if (this.events.offer(event)) {
                    Agent.LOG.finest(MessageFormat.format("Added Custom Event of type {0} in Transaction.", eventType));
                } else {
                    String applicationName = ServiceFactory.getRPMService().getApplicationName();
                    ServiceFactory.getServiceManager().getInsights().storeEvent(applicationName, event);
                }
            } else {
                Agent.LOG.log(Level.WARNING, "Custom event with invalid type of {0} was reported for a transaction but ignored. Event types must match /^[a-zA-Z0-9:_ ]+$/, be non-null, and less than 256 chars.", eventType);
            }
        }

        public List<CustomInsightsEvent> getEventsForTesting() {
            return new ArrayList<CustomInsightsEvent>(this.events);
        }
    }

    private static class CustomEventAttributeSender
    extends AttributeSender {
        private static final String ATTRIBUTE_TYPE = "custom";
        private final Map<String, Object> userAttributes;

        public CustomEventAttributeSender(Map<String, Object> userAttributes) {
            super(new AttributeValidator(ATTRIBUTE_TYPE));
            this.userAttributes = userAttributes;
            this.setTransactional(false);
        }

        @Override
        protected String getAttributeType() {
            return ATTRIBUTE_TYPE;
        }

        @Override
        protected Map<String, Object> getAttributeMap() {
            if (ServiceFactory.getConfigService().getDefaultAgentConfig().isCustomParametersAllowed()) {
                return this.userAttributes;
            }
            return null;
        }
    }
}

