/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.sql;

import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.sql.DefaultSlowQueryListener;
import com.newrelic.agent.sql.NopSlowQueryListener;
import com.newrelic.agent.sql.SlowQueryAggregator;
import com.newrelic.agent.sql.SlowQueryAggregatorImpl;
import com.newrelic.agent.sql.SlowQueryListener;
import com.newrelic.agent.sql.SqlTrace;
import com.newrelic.agent.sql.SqlTraceService;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.TransactionStats;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

public class SqlTraceServiceImpl
extends AbstractService
implements SqlTraceService,
TransactionListener,
HarvestListener {
    private static final SlowQueryListener NOP_SLOW_QUERY_LISTENER = new NopSlowQueryListener();
    private final ConcurrentMap<String, SlowQueryAggregator> slowQueryAggregators = new ConcurrentHashMap<String, SlowQueryAggregator>();
    private final SlowQueryAggregator defaultSlowQueryAggregator;
    private final String defaultAppName = ServiceFactory.getConfigService().getDefaultAgentConfig().getApplicationName();

    public SqlTraceServiceImpl() {
        super(SqlTraceService.class.getSimpleName());
        this.defaultSlowQueryAggregator = this.createSlowQueryAggregator();
    }

    private boolean isEnabled(AgentConfig agentConfig) {
        if (!agentConfig.getSqlTraceConfig().isEnabled()) {
            return false;
        }
        TransactionTracerConfig ttConfig = agentConfig.getTransactionTracerConfig();
        if ("off".equals(ttConfig.getRecordSql())) {
            return false;
        }
        if (ttConfig.isLogSql()) {
            return false;
        }
        return ttConfig.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() {
        ServiceFactory.getTransactionService().addTransactionListener(this);
        ServiceFactory.getHarvestService().addHarvestListener(this);
    }

    @Override
    protected void doStop() {
        ServiceFactory.getTransactionService().removeTransactionListener(this);
        ServiceFactory.getHarvestService().removeHarvestListener(this);
    }

    @Override
    public void dispatcherTransactionFinished(TransactionData td, TransactionStats transactionStats) {
        SlowQueryAggregator aggregator = this.getOrCreateSlowQueryAggregator(td.getApplicationName());
        aggregator.addSlowQueriesFromTransaction(td);
    }

    @Override
    public SlowQueryListener getSlowQueryListener(String appName) {
        AgentConfig agentConfig = ServiceFactory.getConfigService().getAgentConfig(appName);
        if (this.isEnabled(agentConfig)) {
            double threshold = agentConfig.getTransactionTracerConfig().getExplainThresholdInMillis();
            return new DefaultSlowQueryListener(appName, threshold);
        }
        return NOP_SLOW_QUERY_LISTENER;
    }

    @Override
    public void afterHarvest(String appName) {
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        block6: {
            try {
                SlowQueryAggregator aggregator = this.getOrCreateSlowQueryAggregator(appName);
                List<SqlTrace> sqlTraces = aggregator.getAndClearSlowQueries();
                try {
                    ServiceFactory.getRPMServiceManager().getOrCreateRPMService(appName).sendSqlTraceData(sqlTraces);
                }
                catch (Exception e) {
                    String msg = MessageFormat.format("Error sending sql traces for {0}: {1}", appName, e);
                    if (this.getLogger().isLoggable(Level.FINEST)) {
                        this.getLogger().log(Level.FINEST, msg, e);
                        break block6;
                    }
                    this.getLogger().fine(msg);
                }
            }
            catch (Throwable thr) {
                if (this.getLogger().isLoggable(Level.FINEST)) {
                    this.getLogger().log(Level.FINEST, thr, "Error grabbing sql tracers during harvest for app {0}", appName);
                }
                this.getLogger().log(Level.FINE, "Error grabbing sql tracers during harvest for app {0}. {1}", appName, thr.getMessage());
            }
        }
    }

    private SlowQueryAggregator getOrCreateSlowQueryAggregator(String appName) {
        SlowQueryAggregator slowQueryAggregator = this.getSlowQueryAggregator(appName);
        if (slowQueryAggregator != null) {
            return slowQueryAggregator;
        }
        slowQueryAggregator = this.createSlowQueryAggregator();
        SlowQueryAggregator oldSlowQueryAggregator = this.slowQueryAggregators.putIfAbsent(appName, slowQueryAggregator);
        return oldSlowQueryAggregator == null ? slowQueryAggregator : oldSlowQueryAggregator;
    }

    private SlowQueryAggregator getSlowQueryAggregator(String appName) {
        if (appName == null || appName.equals(this.defaultAppName)) {
            return this.defaultSlowQueryAggregator;
        }
        return (SlowQueryAggregator)this.slowQueryAggregators.get(appName);
    }

    private SlowQueryAggregator createSlowQueryAggregator() {
        return new SlowQueryAggregatorImpl();
    }
}

