/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.bootstrap;

import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.CacheLoader;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Caffeine;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.LoadingCache;
import com.newrelic.bootstrap.BootstrapLoader;
import com.newrelic.bootstrap.EmbeddedJarFiles;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class EmbeddedJarFilesImpl
implements EmbeddedJarFiles {
    private static final String[] INTERNAL_JAR_FILE_NAMES = new String[]{"agent-bridge", "newrelic-api", "newrelic-weaver-api"};
    public static final EmbeddedJarFiles INSTANCE = new EmbeddedJarFilesImpl();
    private final LoadingCache<String, File> embeddedAgentJarFiles = Caffeine.newBuilder().executor(Runnable::run).build(new CacheLoader<String, File>(){

        @Override
        public File load(String jarNameWithoutExtension) throws IOException {
            InputStream jarStream = EmbeddedJarFilesImpl.class.getClassLoader().getResourceAsStream(jarNameWithoutExtension + ".jar");
            if (jarStream == null) {
                throw new FileNotFoundException(jarNameWithoutExtension + ".jar");
            }
            File file = File.createTempFile(jarNameWithoutExtension, ".jar", BootstrapLoader.getTempDir());
            file.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(file);){
                BootstrapLoader.copy(jarStream, out, 8096, true);
                File file2 = file;
                return file2;
            }
        }
    });
    private final String[] jarFileNames;

    public EmbeddedJarFilesImpl() {
        this(INTERNAL_JAR_FILE_NAMES);
    }

    public EmbeddedJarFilesImpl(String[] jarFileNames) {
        this.jarFileNames = jarFileNames;
    }

    @Override
    public File getJarFileInAgent(String jarNameWithoutExtension) throws IOException {
        return this.embeddedAgentJarFiles.get(jarNameWithoutExtension);
    }

    @Override
    public String[] getEmbeddedAgentJarFileNames() {
        return this.jarFileNames;
    }
}

