/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry;

import com.newrelic.telemetry.BaseConfig;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.spans.SpanBatchSender;
import java.util.function.Supplier;

public interface SpanBatchSenderFactory {
    default public SpanBatchSender createBatchSender(String apiKey) {
        SenderConfiguration.SenderConfigurationBuilder configuration = SpanBatchSender.configurationBuilder().apiKey(apiKey).httpPoster(this.getPoster());
        return SpanBatchSender.create(configuration.build());
    }

    default public SenderConfiguration.SenderConfigurationBuilder configureWith(BaseConfig baseConfig) {
        return this.configureWith(baseConfig.getApiKey()).auditLoggingEnabled(baseConfig.isAuditLoggingEnabled()).secondaryUserAgent(baseConfig.getSecondaryUserAgent());
    }

    default public SenderConfiguration.SenderConfigurationBuilder configureWith(String apiKey) {
        return SpanBatchSender.configurationBuilder().apiKey(apiKey).httpPoster(this.getPoster());
    }

    public HttpPoster getPoster();

    public static SpanBatchSenderFactory fromHttpImplementation(Supplier<HttpPoster> creator) {
        return creator::get;
    }
}

