/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.JmxConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

class JmxConfigImpl
extends BaseConfig
implements JmxConfig {
    public static final String ENABLED = "enabled";
    public static final String REGISTER_LINKING_METADATA_MBEAN = "linkingMetadataMBean";
    public static final String DISABLED_JMX_FRAMEWORKS = "disabled_jmx_frameworks";
    public static final boolean DEFAULT_REGISTER_LINKING_METADATA_MBEAN = false;
    public static final Boolean DEFAULT_ENABLED = Boolean.TRUE;
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.jmx.";
    private final boolean isEnabled = this.getProperty("enabled", DEFAULT_ENABLED);
    private final Collection<String> disabledJmxFrameworks = this.getUniqueStrings("disabled_jmx_frameworks", ",");

    public JmxConfigImpl(Map<String, Object> pProps) {
        super(pProps, SYSTEM_PROPERTY_ROOT);
    }

    static JmxConfigImpl createJmxConfig(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new JmxConfigImpl(settings);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public Collection<String> getDisabledJmxFrameworks() {
        return this.disabledJmxFrameworks;
    }

    @Override
    public boolean registerLinkingMetadataMBean() {
        return this.getProperty(REGISTER_LINKING_METADATA_MBEAN, false);
    }
}

