/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.io.grpc.internal;

import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.com.google.common.base.MoreObjects;
import com.newrelic.agent.deps.com.google.common.base.Preconditions;
import com.newrelic.agent.deps.com.google.common.util.concurrent.MoreExecutors;
import com.newrelic.agent.deps.io.grpc.Attributes;
import com.newrelic.agent.deps.io.grpc.CallOptions;
import com.newrelic.agent.deps.io.grpc.ClientCall;
import com.newrelic.agent.deps.io.grpc.Codec;
import com.newrelic.agent.deps.io.grpc.Compressor;
import com.newrelic.agent.deps.io.grpc.CompressorRegistry;
import com.newrelic.agent.deps.io.grpc.Context;
import com.newrelic.agent.deps.io.grpc.Contexts;
import com.newrelic.agent.deps.io.grpc.Deadline;
import com.newrelic.agent.deps.io.grpc.DecompressorRegistry;
import com.newrelic.agent.deps.io.grpc.InternalConfigSelector;
import com.newrelic.agent.deps.io.grpc.InternalDecompressorRegistry;
import com.newrelic.agent.deps.io.grpc.Metadata;
import com.newrelic.agent.deps.io.grpc.MethodDescriptor;
import com.newrelic.agent.deps.io.grpc.Status;
import com.newrelic.agent.deps.io.grpc.internal.CallTracer;
import com.newrelic.agent.deps.io.grpc.internal.ClientStream;
import com.newrelic.agent.deps.io.grpc.internal.ClientStreamListener;
import com.newrelic.agent.deps.io.grpc.internal.ContextRunnable;
import com.newrelic.agent.deps.io.grpc.internal.FailingClientStream;
import com.newrelic.agent.deps.io.grpc.internal.GrpcUtil;
import com.newrelic.agent.deps.io.grpc.internal.InsightBuilder;
import com.newrelic.agent.deps.io.grpc.internal.LogExceptionRunnable;
import com.newrelic.agent.deps.io.grpc.internal.NoopClientStream;
import com.newrelic.agent.deps.io.grpc.internal.RetriableStream;
import com.newrelic.agent.deps.io.grpc.internal.SerializeReentrantCallsDirectExecutor;
import com.newrelic.agent.deps.io.grpc.internal.SerializingExecutor;
import com.newrelic.agent.deps.io.grpc.internal.StreamListener;
import com.newrelic.agent.deps.io.perfmark.Link;
import com.newrelic.agent.deps.io.perfmark.PerfMark;
import com.newrelic.agent.deps.io.perfmark.Tag;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class ClientCallImpl<ReqT, RespT>
extends ClientCall<ReqT, RespT> {
    private static final Logger log;
    private static final byte[] FULL_STREAM_DECOMPRESSION_ENCODINGS;
    @VisibleForTesting
    static final long DEADLINE_EXPIRATION_CANCEL_DELAY_NANOS;
    private final MethodDescriptor<ReqT, RespT> method;
    private final Tag tag;
    private final Executor callExecutor;
    private final boolean callExecutorIsDirect;
    private final CallTracer channelCallsTracer;
    private final Context context;
    private final boolean unaryRequest;
    private final CallOptions callOptions;
    private ClientStream stream;
    private volatile boolean cancelListenersShouldBeRemoved;
    private boolean cancelCalled;
    private boolean halfCloseCalled;
    private final ClientStreamProvider clientStreamProvider;
    private ContextCancellationListener cancellationListener;
    private final ScheduledExecutorService deadlineCancellationExecutor;
    private boolean fullStreamDecompression;
    private DecompressorRegistry decompressorRegistry = DecompressorRegistry.getDefaultInstance();
    private CompressorRegistry compressorRegistry = CompressorRegistry.getDefaultInstance();
    private volatile ScheduledFuture<?> deadlineCancellationNotifyApplicationFuture;
    private volatile ScheduledFuture<?> deadlineCancellationSendToServerFuture;
    private boolean observerClosed = false;

    ClientCallImpl(MethodDescriptor<ReqT, RespT> method, Executor executor, CallOptions callOptions, ClientStreamProvider clientStreamProvider, ScheduledExecutorService deadlineCancellationExecutor, CallTracer channelCallsTracer, InternalConfigSelector configSelector) {
        this.method = method;
        this.tag = PerfMark.createTag(method.getFullMethodName(), System.identityHashCode(this));
        if (executor == MoreExecutors.directExecutor()) {
            this.callExecutor = new SerializeReentrantCallsDirectExecutor();
            this.callExecutorIsDirect = true;
        } else {
            this.callExecutor = new SerializingExecutor(executor);
            this.callExecutorIsDirect = false;
        }
        this.channelCallsTracer = channelCallsTracer;
        this.context = Context.current();
        this.unaryRequest = method.getType() == MethodDescriptor.MethodType.UNARY || method.getType() == MethodDescriptor.MethodType.SERVER_STREAMING;
        this.callOptions = callOptions;
        this.clientStreamProvider = clientStreamProvider;
        this.deadlineCancellationExecutor = deadlineCancellationExecutor;
        PerfMark.event("ClientCall.<init>", this.tag);
    }

    ClientCallImpl<ReqT, RespT> setFullStreamDecompression(boolean fullStreamDecompression) {
        this.fullStreamDecompression = fullStreamDecompression;
        return this;
    }

    ClientCallImpl<ReqT, RespT> setDecompressorRegistry(DecompressorRegistry decompressorRegistry) {
        this.decompressorRegistry = decompressorRegistry;
        return this;
    }

    ClientCallImpl<ReqT, RespT> setCompressorRegistry(CompressorRegistry compressorRegistry) {
        this.compressorRegistry = compressorRegistry;
        return this;
    }

    @VisibleForTesting
    static void prepareHeaders(Metadata headers, DecompressorRegistry decompressorRegistry, Compressor compressor, boolean fullStreamDecompression) {
        headers.discardAll(GrpcUtil.MESSAGE_ENCODING_KEY);
        if (compressor != Codec.Identity.NONE) {
            headers.put(GrpcUtil.MESSAGE_ENCODING_KEY, compressor.getMessageEncoding());
        }
        headers.discardAll(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
        byte[] advertisedEncodings = InternalDecompressorRegistry.getRawAdvertisedMessageEncodings(decompressorRegistry);
        if (advertisedEncodings.length != 0) {
            headers.put(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY, advertisedEncodings);
        }
        headers.discardAll(GrpcUtil.CONTENT_ENCODING_KEY);
        headers.discardAll(GrpcUtil.CONTENT_ACCEPT_ENCODING_KEY);
        if (fullStreamDecompression) {
            headers.put(GrpcUtil.CONTENT_ACCEPT_ENCODING_KEY, FULL_STREAM_DECOMPRESSION_ENCODINGS);
        }
    }

    @Override
    public void start(ClientCall.Listener<RespT> observer, Metadata headers) {
        PerfMark.startTask("ClientCall.start", this.tag);
        try {
            this.startInternal(observer, headers);
        }
        finally {
            PerfMark.stopTask("ClientCall.start", this.tag);
        }
    }

    private void startInternal(ClientCall.Listener<RespT> observer, Metadata headers) {
        boolean deadlineExceeded;
        Compressor compressor;
        Preconditions.checkState(this.stream == null, "Already started");
        Preconditions.checkState(!this.cancelCalled, "call was cancelled");
        Preconditions.checkNotNull(observer, "observer");
        Preconditions.checkNotNull(headers, "headers");
        if (this.context.isCancelled()) {
            this.stream = NoopClientStream.INSTANCE;
            this.executeCloseObserverInContext(observer, Contexts.statusFromCancelled(this.context));
            return;
        }
        String compressorName = this.callOptions.getCompressor();
        if (compressorName != null) {
            compressor = this.compressorRegistry.lookupCompressor(compressorName);
            if (compressor == null) {
                this.stream = NoopClientStream.INSTANCE;
                Status status = Status.INTERNAL.withDescription(String.format("Unable to find compressor by name %s", compressorName));
                this.executeCloseObserverInContext(observer, status);
                return;
            }
        } else {
            compressor = Codec.Identity.NONE;
        }
        ClientCallImpl.prepareHeaders(headers, this.decompressorRegistry, compressor, this.fullStreamDecompression);
        Deadline effectiveDeadline = this.effectiveDeadline();
        boolean bl = deadlineExceeded = effectiveDeadline != null && effectiveDeadline.isExpired();
        if (!deadlineExceeded) {
            ClientCallImpl.logIfContextNarrowedTimeout(effectiveDeadline, this.context.getDeadline(), this.callOptions.getDeadline());
            this.stream = this.clientStreamProvider.newStream(this.method, this.callOptions, headers, this.context);
        } else {
            this.stream = new FailingClientStream(Status.DEADLINE_EXCEEDED.withDescription("ClientCall started after deadline exceeded: " + effectiveDeadline));
        }
        if (this.callExecutorIsDirect) {
            this.stream.optimizeForDirectExecutor();
        }
        if (this.callOptions.getAuthority() != null) {
            this.stream.setAuthority(this.callOptions.getAuthority());
        }
        if (this.callOptions.getMaxInboundMessageSize() != null) {
            this.stream.setMaxInboundMessageSize(this.callOptions.getMaxInboundMessageSize());
        }
        if (this.callOptions.getMaxOutboundMessageSize() != null) {
            this.stream.setMaxOutboundMessageSize(this.callOptions.getMaxOutboundMessageSize());
        }
        if (effectiveDeadline != null) {
            this.stream.setDeadline(effectiveDeadline);
        }
        this.stream.setCompressor(compressor);
        if (this.fullStreamDecompression) {
            this.stream.setFullStreamDecompression(this.fullStreamDecompression);
        }
        this.stream.setDecompressorRegistry(this.decompressorRegistry);
        this.channelCallsTracer.reportCallStarted();
        this.cancellationListener = new ContextCancellationListener(observer);
        this.stream.start(new ClientStreamListenerImpl(observer));
        this.context.addListener(this.cancellationListener, MoreExecutors.directExecutor());
        if (effectiveDeadline != null && !effectiveDeadline.equals(this.context.getDeadline()) && this.deadlineCancellationExecutor != null && !(this.stream instanceof FailingClientStream)) {
            this.deadlineCancellationNotifyApplicationFuture = this.startDeadlineNotifyApplicationTimer(effectiveDeadline, observer);
        }
        if (this.cancelListenersShouldBeRemoved) {
            this.removeContextListenerAndCancelDeadlineFuture();
        }
    }

    private static void logIfContextNarrowedTimeout(Deadline effectiveDeadline, @Nullable Deadline outerCallDeadline, @Nullable Deadline callDeadline) {
        if (!log.isLoggable(Level.FINE) || effectiveDeadline == null || !effectiveDeadline.equals(outerCallDeadline)) {
            return;
        }
        long effectiveTimeout = Math.max(0L, effectiveDeadline.timeRemaining(TimeUnit.NANOSECONDS));
        StringBuilder builder = new StringBuilder(String.format("Call timeout set to '%d' ns, due to context deadline.", effectiveTimeout));
        if (callDeadline == null) {
            builder.append(" Explicit call timeout was not set.");
        } else {
            long callTimeout = callDeadline.timeRemaining(TimeUnit.NANOSECONDS);
            builder.append(String.format(" Explicit call timeout was '%d' ns.", callTimeout));
        }
        log.fine(builder.toString());
    }

    private void removeContextListenerAndCancelDeadlineFuture() {
        this.context.removeListener(this.cancellationListener);
        ScheduledFuture<?> f = this.deadlineCancellationSendToServerFuture;
        if (f != null) {
            f.cancel(false);
        }
        if ((f = this.deadlineCancellationNotifyApplicationFuture) != null) {
            f.cancel(false);
        }
    }

    private ScheduledFuture<?> startDeadlineNotifyApplicationTimer(Deadline deadline, final ClientCall.Listener<RespT> observer) {
        final long remainingNanos = deadline.timeRemaining(TimeUnit.NANOSECONDS);
        class DeadlineExceededNotifyApplicationTimer
        implements Runnable {
            DeadlineExceededNotifyApplicationTimer() {
            }

            @Override
            public void run() {
                Status status = ClientCallImpl.this.buildDeadlineExceededStatusWithRemainingNanos(remainingNanos);
                ClientCallImpl.this.delayedCancelOnDeadlineExceeded(status, observer);
            }
        }
        return this.deadlineCancellationExecutor.schedule(new LogExceptionRunnable(new DeadlineExceededNotifyApplicationTimer()), remainingNanos, TimeUnit.NANOSECONDS);
    }

    private Status buildDeadlineExceededStatusWithRemainingNanos(long remainingNanos) {
        InsightBuilder insight = new InsightBuilder();
        this.stream.appendTimeoutInsight(insight);
        long seconds = Math.abs(remainingNanos) / TimeUnit.SECONDS.toNanos(1L);
        long nanos = Math.abs(remainingNanos) % TimeUnit.SECONDS.toNanos(1L);
        StringBuilder buf = new StringBuilder();
        buf.append("deadline exceeded after ");
        if (remainingNanos < 0L) {
            buf.append('-');
        }
        buf.append(seconds);
        buf.append(String.format(".%09d", nanos));
        buf.append("s. ");
        buf.append(insight);
        return Status.DEADLINE_EXCEEDED.augmentDescription(buf.toString());
    }

    private void delayedCancelOnDeadlineExceeded(final Status status, ClientCall.Listener<RespT> observer) {
        if (this.deadlineCancellationSendToServerFuture != null) {
            return;
        }
        class DeadlineExceededSendCancelToServerTimer
        implements Runnable {
            DeadlineExceededSendCancelToServerTimer() {
            }

            @Override
            public void run() {
                ClientCallImpl.this.stream.cancel(status);
            }
        }
        this.deadlineCancellationSendToServerFuture = this.deadlineCancellationExecutor.schedule(new LogExceptionRunnable(new DeadlineExceededSendCancelToServerTimer()), DEADLINE_EXPIRATION_CANCEL_DELAY_NANOS, TimeUnit.NANOSECONDS);
        this.executeCloseObserverInContext(observer, status);
    }

    private void executeCloseObserverInContext(final ClientCall.Listener<RespT> observer, final Status status) {
        class CloseInContext
        extends ContextRunnable {
            CloseInContext() {
                super(ClientCallImpl.this.context);
            }

            @Override
            public void runInContext() {
                ClientCallImpl.this.closeObserver(observer, status, new Metadata());
            }
        }
        this.callExecutor.execute(new CloseInContext());
    }

    private void closeObserver(ClientCall.Listener<RespT> observer, Status status, Metadata trailers) {
        if (!this.observerClosed) {
            this.observerClosed = true;
            observer.onClose(status, trailers);
        }
    }

    @Nullable
    private Deadline effectiveDeadline() {
        return ClientCallImpl.min(this.callOptions.getDeadline(), this.context.getDeadline());
    }

    @Nullable
    private static Deadline min(@Nullable Deadline deadline0, @Nullable Deadline deadline1) {
        if (deadline0 == null) {
            return deadline1;
        }
        if (deadline1 == null) {
            return deadline0;
        }
        return deadline0.minimum(deadline1);
    }

    @Override
    public void request(int numMessages) {
        PerfMark.startTask("ClientCall.request", this.tag);
        try {
            Preconditions.checkState(this.stream != null, "Not started");
            Preconditions.checkArgument(numMessages >= 0, "Number requested must be non-negative");
            this.stream.request(numMessages);
        }
        finally {
            PerfMark.stopTask("ClientCall.request", this.tag);
        }
    }

    @Override
    public void cancel(@Nullable String message, @Nullable Throwable cause) {
        PerfMark.startTask("ClientCall.cancel", this.tag);
        try {
            this.cancelInternal(message, cause);
        }
        finally {
            PerfMark.stopTask("ClientCall.cancel", this.tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelInternal(@Nullable String message, @Nullable Throwable cause) {
        if (message == null && cause == null) {
            cause = new CancellationException("Cancelled without a message or cause");
            log.log(Level.WARNING, "Cancelling without a message or cause is suboptimal", cause);
        }
        if (this.cancelCalled) {
            return;
        }
        this.cancelCalled = true;
        try {
            if (this.stream != null) {
                Status status = Status.CANCELLED;
                status = message != null ? status.withDescription(message) : status.withDescription("Call cancelled without message");
                if (cause != null) {
                    status = status.withCause(cause);
                }
                this.stream.cancel(status);
            }
        }
        finally {
            this.removeContextListenerAndCancelDeadlineFuture();
        }
    }

    @Override
    public void halfClose() {
        PerfMark.startTask("ClientCall.halfClose", this.tag);
        try {
            this.halfCloseInternal();
        }
        finally {
            PerfMark.stopTask("ClientCall.halfClose", this.tag);
        }
    }

    private void halfCloseInternal() {
        Preconditions.checkState(this.stream != null, "Not started");
        Preconditions.checkState(!this.cancelCalled, "call was cancelled");
        Preconditions.checkState(!this.halfCloseCalled, "call already half-closed");
        this.halfCloseCalled = true;
        this.stream.halfClose();
    }

    @Override
    public void sendMessage(ReqT message) {
        PerfMark.startTask("ClientCall.sendMessage", this.tag);
        try {
            this.sendMessageInternal(message);
        }
        finally {
            PerfMark.stopTask("ClientCall.sendMessage", this.tag);
        }
    }

    private void sendMessageInternal(ReqT message) {
        Preconditions.checkState(this.stream != null, "Not started");
        Preconditions.checkState(!this.cancelCalled, "call was cancelled");
        Preconditions.checkState(!this.halfCloseCalled, "call was half-closed");
        try {
            if (this.stream instanceof RetriableStream) {
                RetriableStream retriableStream = (RetriableStream)this.stream;
                retriableStream.sendMessage(message);
            } else {
                this.stream.writeMessage(this.method.streamRequest(message));
            }
        }
        catch (RuntimeException e) {
            this.stream.cancel(Status.CANCELLED.withCause(e).withDescription("Failed to stream message"));
            return;
        }
        catch (Error e) {
            this.stream.cancel(Status.CANCELLED.withDescription("Client sendMessage() failed with Error"));
            throw e;
        }
        if (!this.unaryRequest) {
            this.stream.flush();
        }
    }

    @Override
    public void setMessageCompression(boolean enabled) {
        Preconditions.checkState(this.stream != null, "Not started");
        this.stream.setMessageCompression(enabled);
    }

    @Override
    public boolean isReady() {
        return this.stream.isReady();
    }

    @Override
    public Attributes getAttributes() {
        if (this.stream != null) {
            return this.stream.getAttributes();
        }
        return Attributes.EMPTY;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("method", this.method).toString();
    }

    static {
        ClientCallImpl.class.getName();
        log = Logger.global;
        FULL_STREAM_DECOMPRESSION_ENCODINGS = "gzip".getBytes(Charset.forName("US-ASCII"));
        DEADLINE_EXPIRATION_CANCEL_DELAY_NANOS = TimeUnit.SECONDS.toNanos(1L);
    }

    private class ClientStreamListenerImpl
    implements ClientStreamListener {
        private final ClientCall.Listener<RespT> observer;
        private Status exceptionStatus;

        public ClientStreamListenerImpl(ClientCall.Listener<RespT> observer) {
            this.observer = Preconditions.checkNotNull(observer, "observer");
        }

        private void exceptionThrown(Status status) {
            this.exceptionStatus = status;
            ClientCallImpl.this.stream.cancel(status);
        }

        @Override
        public void headersRead(final Metadata headers) {
            PerfMark.startTask("ClientStreamListener.headersRead", ClientCallImpl.this.tag);
            final Link link = PerfMark.linkOut();
            try {
                final class HeadersRead
                extends ContextRunnable {
                    HeadersRead() {
                        super(ClientCallImpl.this.context);
                    }

                    @Override
                    public void runInContext() {
                        PerfMark.startTask("ClientCall$Listener.headersRead", ClientCallImpl.this.tag);
                        PerfMark.linkIn(link);
                        try {
                            this.runInternal();
                        }
                        finally {
                            PerfMark.stopTask("ClientCall$Listener.headersRead", ClientCallImpl.this.tag);
                        }
                    }

                    private void runInternal() {
                        if (ClientStreamListenerImpl.this.exceptionStatus != null) {
                            return;
                        }
                        try {
                            ClientStreamListenerImpl.this.observer.onHeaders(headers);
                        }
                        catch (Throwable t2) {
                            ClientStreamListenerImpl.this.exceptionThrown(Status.CANCELLED.withCause(t2).withDescription("Failed to read headers"));
                        }
                    }
                }
                ClientCallImpl.this.callExecutor.execute(new HeadersRead());
            }
            finally {
                PerfMark.stopTask("ClientStreamListener.headersRead", ClientCallImpl.this.tag);
            }
        }

        @Override
        public void messagesAvailable(final StreamListener.MessageProducer producer) {
            PerfMark.startTask("ClientStreamListener.messagesAvailable", ClientCallImpl.this.tag);
            final Link link = PerfMark.linkOut();
            try {
                final class MessagesAvailable
                extends ContextRunnable {
                    MessagesAvailable() {
                        super(ClientCallImpl.this.context);
                    }

                    @Override
                    public void runInContext() {
                        PerfMark.startTask("ClientCall$Listener.messagesAvailable", ClientCallImpl.this.tag);
                        PerfMark.linkIn(link);
                        try {
                            this.runInternal();
                        }
                        finally {
                            PerfMark.stopTask("ClientCall$Listener.messagesAvailable", ClientCallImpl.this.tag);
                        }
                    }

                    private void runInternal() {
                        if (ClientStreamListenerImpl.this.exceptionStatus != null) {
                            GrpcUtil.closeQuietly(producer);
                            return;
                        }
                        try {
                            InputStream message;
                            while ((message = producer.next()) != null) {
                                try {
                                    ClientStreamListenerImpl.this.observer.onMessage(ClientCallImpl.this.method.parseResponse(message));
                                }
                                catch (Throwable t2) {
                                    GrpcUtil.closeQuietly(message);
                                    throw t2;
                                }
                                message.close();
                            }
                        }
                        catch (Throwable t3) {
                            GrpcUtil.closeQuietly(producer);
                            ClientStreamListenerImpl.this.exceptionThrown(Status.CANCELLED.withCause(t3).withDescription("Failed to read message."));
                        }
                    }
                }
                ClientCallImpl.this.callExecutor.execute(new MessagesAvailable());
            }
            finally {
                PerfMark.stopTask("ClientStreamListener.messagesAvailable", ClientCallImpl.this.tag);
            }
        }

        @Override
        public void closed(Status status, Metadata trailers) {
            this.closed(status, ClientStreamListener.RpcProgress.PROCESSED, trailers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closed(Status status, ClientStreamListener.RpcProgress rpcProgress, Metadata trailers) {
            PerfMark.startTask("ClientStreamListener.closed", ClientCallImpl.this.tag);
            try {
                this.closedInternal(status, rpcProgress, trailers);
            }
            finally {
                PerfMark.stopTask("ClientStreamListener.closed", ClientCallImpl.this.tag);
            }
        }

        private void closedInternal(Status status, ClientStreamListener.RpcProgress rpcProgress, Metadata trailers) {
            Deadline deadline = ClientCallImpl.this.effectiveDeadline();
            if (status.getCode() == Status.Code.CANCELLED && deadline != null && deadline.isExpired()) {
                InsightBuilder insight = new InsightBuilder();
                ClientCallImpl.this.stream.appendTimeoutInsight(insight);
                status = Status.DEADLINE_EXCEEDED.augmentDescription("ClientCall was cancelled at or after deadline. " + insight);
                trailers = new Metadata();
            }
            final Status savedStatus = status;
            final Metadata savedTrailers = trailers;
            final Link link = PerfMark.linkOut();
            final class StreamClosed
            extends ContextRunnable {
                StreamClosed() {
                    super(ClientCallImpl.this.context);
                }

                @Override
                public void runInContext() {
                    PerfMark.startTask("ClientCall$Listener.onClose", ClientCallImpl.this.tag);
                    PerfMark.linkIn(link);
                    try {
                        this.runInternal();
                    }
                    finally {
                        PerfMark.stopTask("ClientCall$Listener.onClose", ClientCallImpl.this.tag);
                    }
                }

                private void runInternal() {
                    Status status = savedStatus;
                    Metadata trailers = savedTrailers;
                    if (ClientStreamListenerImpl.this.exceptionStatus != null) {
                        status = ClientStreamListenerImpl.this.exceptionStatus;
                        trailers = new Metadata();
                    }
                    ClientCallImpl.this.cancelListenersShouldBeRemoved = true;
                    try {
                        ClientCallImpl.this.closeObserver(ClientStreamListenerImpl.this.observer, status, trailers);
                    }
                    finally {
                        ClientCallImpl.this.removeContextListenerAndCancelDeadlineFuture();
                        ClientCallImpl.this.channelCallsTracer.reportCallEnded(status.isOk());
                    }
                }
            }
            ClientCallImpl.this.callExecutor.execute(new StreamClosed());
        }

        @Override
        public void onReady() {
            if (ClientCallImpl.this.method.getType().clientSendsOneMessage()) {
                return;
            }
            PerfMark.startTask("ClientStreamListener.onReady", ClientCallImpl.this.tag);
            final Link link = PerfMark.linkOut();
            try {
                final class StreamOnReady
                extends ContextRunnable {
                    StreamOnReady() {
                        super(ClientCallImpl.this.context);
                    }

                    @Override
                    public void runInContext() {
                        PerfMark.startTask("ClientCall$Listener.onReady", ClientCallImpl.this.tag);
                        PerfMark.linkIn(link);
                        try {
                            this.runInternal();
                        }
                        finally {
                            PerfMark.stopTask("ClientCall$Listener.onReady", ClientCallImpl.this.tag);
                        }
                    }

                    private void runInternal() {
                        if (ClientStreamListenerImpl.this.exceptionStatus != null) {
                            return;
                        }
                        try {
                            ClientStreamListenerImpl.this.observer.onReady();
                        }
                        catch (Throwable t2) {
                            ClientStreamListenerImpl.this.exceptionThrown(Status.CANCELLED.withCause(t2).withDescription("Failed to call onReady."));
                        }
                    }
                }
                ClientCallImpl.this.callExecutor.execute(new StreamOnReady());
            }
            finally {
                PerfMark.stopTask("ClientStreamListener.onReady", ClientCallImpl.this.tag);
            }
        }
    }

    static interface ClientStreamProvider {
        public ClientStream newStream(MethodDescriptor<?, ?> var1, CallOptions var2, Metadata var3, Context var4);
    }

    private final class ContextCancellationListener
    implements Context.CancellationListener {
        private ClientCall.Listener<RespT> observer;

        private ContextCancellationListener(ClientCall.Listener<RespT> observer) {
            this.observer = observer;
        }

        @Override
        public void cancelled(Context context) {
            if (context.getDeadline() == null || !context.getDeadline().isExpired()) {
                ClientCallImpl.this.stream.cancel(Contexts.statusFromCancelled(context));
            } else {
                Status status = Contexts.statusFromCancelled(context);
                ClientCallImpl.this.delayedCancelOnDeadlineExceeded(status, this.observer);
            }
        }
    }
}

